/***************************************************************************
 *   Copyright (C) 2006 by John Schneiderman                               *
 *   JohnMS@member.fsf.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "cribbageblock.h"

#include <qpoint.h>
#include <qpainter.h>

CribbageBlock::CribbageBlock(const QColor &colour, int numberOfPegs, int x, int y, int orientation, QWidget *parent, const char *name): QWidget(parent, name, WPaintClever | WRepaintNoErase)
{
    m_orientation=orientation;
    m_pegs=numberOfPegs;
    m_positionX=x;
    m_positionY=y;
    m_height=(m_pegs * 2) + 1; // Cacluate how tall to make the block
    m_colour=colour;
}

QPoint CribbageBlock::position() const
{
    return QPoint(m_positionX, m_positionY);
}

void CribbageBlock::setPosition(int x, int y)
{
    m_positionX=x;
    m_positionY=y;
}

int CribbageBlock::height() const
{
    return m_height;
}

void CribbageBlock::setHeight(int h)
{
    m_height=h;
}

void CribbageBlock::draw(QPainter *painter)
{
    QBrush brush=painter->brush();

    painter->setBrush(m_colour);
    //Determine if we're going to be vertically or horizontally drawn
    if (m_orientation == VERTICAL)
    {
        painter->drawRect(m_positionX, m_positionY, BLOCK_WIDTH, m_height);
        painter->setBrush(QBrush(black));
        for (int i=0, offset=1; i < m_pegs; ++i, offset+=2)
            painter->drawEllipse(m_positionX + 1, m_positionY + offset, BLOCK_WIDTH / 2, BLOCK_WIDTH / 2);
    }
    else if (m_orientation == HORIZONTAL)
    {
        painter->drawRect(m_positionX, m_positionY, m_height, BLOCK_WIDTH);
        painter->setBrush(QBrush(black));
        for (int i=0, offset=0; i < m_pegs; ++i, offset+=2)
            painter->drawEllipse(m_positionX + offset, m_positionY + 1, BLOCK_WIDTH / 2, BLOCK_WIDTH / 2);
    }
    painter->setBrush(brush);
}
