/***************************************************************************
 *   Copyright (C) 2006 by John Schneiderman                               *
 *   JohnMS@member.fsf.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 ***************************************************************************/
#include "heartsplayer.h"
#include "aibase.h"

HeartsPlayer::HeartsPlayer(AIBase &aiBase): ComputerPlayer(aiBase), m_rules()
{}

HeartsPlayer::~HeartsPlayer()
{}

Card HeartsPlayer::playCard(const CardSequence& playSequence) const
{
    if ( isTurn() )
        return m_pAIBase->whichCards("hearts", playSequence, m_rules, m_hand, m_gameInformation).front();
    else
        return Card();
}

CardSequence HeartsPlayer::passCards(const CardSequence& playSequence) const
{
    return m_pAIBase->whichCards("heartsPassPhase", playSequence, m_rules, m_hand, m_gameInformation);
}
