/***************************************************************************
 *   Copyright (C) 2007 by John Schneiderman                               *
 *   JohnMS@member.fsf.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 ***************************************************************************/
#ifndef OLD_MAID_H
#define OLD_MAID_H

#include "gamebase.h"
#include "oldmaidrules.h"
#include "carddeck.h"

class OldMaidInterface;

/**
 * This controls and keeps track of the state of the game Old Maid.
 *
 * @author John Schneiderman
 */
class OldMaid: public GameBase
{
public:
    /**
     * The constructor for Old Maid.
     * @param gameInterface is the interface for the game.
     * @param profileDatabase is the user profile database.
     */
    OldMaid(OldMaidInterface *gameInterface, UserProfileDatabase &profileDatabase);
    /**
     * The destructor.
     */
    ~OldMaid();
    /**
     * This starts the game of Old Maid.
     */
    virtual void startPlay();
    /**
     * This saves the game of Old Maid.
     * @param filename is the name of the file to save the game to.
     * @return true if we successfully save the game, false elsewise.
     */
    virtual bool save(const QString &filename);
    /**
     * This loads the game of Old Maid.
     * @param filename is the name of the file to load.
     * @return true if we load the game successfully, false elsewise.
     */
    virtual bool load(const QString &filename);
    /**
     * This gives the minimum number of players needed to play the game of Old Maid.
     * @return the minimum number of players.
     */
    virtual int minimumPlayers() const;
    /**
     * This gives the maximum number of players allowed to play the game of Old Maid.
     * @return the maximum number of players.
     */
    virtual int maximumPlayers() const;

protected:
    /// @param m_rules is the rules to the game of Old Maid.
    OldMaidRules m_rules;
    /// @param m_humanPlayerIndex is the index for the human player.
    int m_humanPlayerIndex;

    /**
     * Handles a card being played.
     * @param card is the card the player wants to play.
     */
    virtual void cardPlayed(const Card &card);
    /**
     * Deals out the cards to each player.
     */
    virtual void deal();
    /**
     * Disables the current player, and enables the next player's turn.
     */
    virtual void setupNextPlayer();
    /**
     * Determines and handles the various stages in game play.
     * @return the last major GameStatusCode value after handling the changes.
     */
    virtual int handleGameStatus();
    /**
     * Calcualtes the index of the player who has cards and is to the left of the current player.
     * @throw KardsGTError if no player to the left has cards.
     * @return the left player's index.
     */
    int leftPlayerIndex() const;

private:
    /// @param m_pInterface is the interface to our graphical interface.
    OldMaidInterface *m_pInterface;
    /// @param m_deck is the deck of cards used in the game.
    CardDeck m_deck;
    /**
     * These are the games status codes.
     * @param NORMAL means the status is normal.
     * @param GAME_OVER means we have met the conditions for the game to end.
     */
    enum GameStatusCodes
    {
    	NORMAL = 0,
    	GAME_OVER = 1
    };

	/**
	 * Handles all the pair removals for all the players.
	 */
	void handlePairs();
    int numberOfPairs(CardSequence seq) const;
};
#endif
