/***************************************************************************
 *   Copyright (C) 2006 by John Schneiderman                               *
 *   JohnMS@member.fsf.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 ***************************************************************************/
#ifndef SPADESPLAYER_H
#define SPADESPLAYER_H

#include "computerplayer.h"
#include "spadesrules.h"

class AIBase;
class CardSequence;

/**
 * This is a computer player for the game of spades.
 *
 * @author John Schneiderman
 */
class SpadesPlayer: public ComputerPlayer
{
public:
    /**
     * The general constructor.
     * @param aiBase is the AI for our computer player.
     */
    SpadesPlayer(AIBase &aiBase);
    /**
     * The default destructor.
     */
    ~SpadesPlayer();
    /**
     * Requests that the AI choose a card for game play.
     * @param playSequence is the current play sequence.
     * @return the card the AI has chosen.
     */
    virtual Card playCard(const CardSequence& playSequence) const;
    /**
     * Requests that the AI decided if it wants to bid double nil.
     * @return the special bid type made.
     */
    SpadesRules::SpecialBidTypes bidDoubleNil() const;
    /**
     * Requests that the AI select cards to pass because of a nil or double nil bid.
     * @return the cards selected to pass.
     */
    CardSequence selectExchangeCards() const;
    /**
     * Requests that the AI make a bid for the contract.
     * @return the bid for the contract.
     */
    int bid() const;
    /**
     * This sets the rules for the spades player.
     * @param rules is the rules for the spades player.
     * @note The rules must be the same object as used in the game.
     */
    void setRules(const SpadesRules &rules);

private:
    /// @param m_pRules are the rules for the game of spades.
    const SpadesRules *m_pRules;
};
#endif
