/***************************************************************************
 *   Copyright (C) 2005 by John Schneiderman                               *
 *   JohnMS@member.fsf.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 ***************************************************************************/
#include "kardmessagedisplay.h"
#include "kard.h"
#include "kardsgterror.h"

#include <qlayout.h>
#include <qlabel.h>
#include <qpushbutton.h>

KardMessageDisplay::KardMessageDisplay(const QString &caption, const CardSequence &hand, const QString &message, const QString &cardImagePath, const QString &cardBackImage, QWidget *parent, const char *name, bool modal): QDialog(parent, name, modal, WPaintClever | WRepaintNoErase)
{
    setMaximumSize(parent->width(), parent->height());
    setCaption(caption);
    vector<CardSequence> hands;
    vector<QString> messages;

    hands.push_back(hand);
    messages.push_back(message);
    displayMessage(hands, messages, cardImagePath, cardBackImage);
}

KardMessageDisplay::KardMessageDisplay(const QString &caption, const vector<CardSequence> &hands, const vector<QString> &messages, const QString &cardImagePath, const QString &cardBackImage, QWidget *parent, const char *name, bool modal): QDialog(parent, name, modal, WPaintClever | WRepaintNoErase)
{
    setMaximumSize(parent->width(), parent->height());
    setCaption(caption);

    displayMessage(hands, messages, cardImagePath, cardBackImage);
}

KardMessageDisplay::~KardMessageDisplay()
{
    if (m_pDisplay != NULL)
        delete m_pDisplay;
    if (m_pBttnOkay != NULL)
        delete m_pBttnOkay;
}

void KardMessageDisplay::displayMessage(const vector<CardSequence> &hands, const vector<QString> &messages, const QString &cardImagePath, const QString &cardBackImage)
{
    Kard *kard;

    if (hands.size() != messages.size())
        throw KardsGTError("KardMessageDisplay", "displayMessage", "hands is not the same size as messages!");
    m_hands=hands;
    m_messages=messages;
    for (int i=0; i < static_cast<int>(m_hands.size()); ++i)
    {
        m_messageLayouts.push_back(new QHBoxLayout());

        // Create a Kard from the sequence
        for (int j=0; j < m_hands[i].size(); ++j)
        {
            kard=new Kard(this, "KardMessageDisplay kard");
            kard->setCardBack(cardBackImage);
            kard->setCardPath(cardImagePath);
            kard->setCard(m_hands[i][j]);
            kard->flipCard();
            m_messageLayouts[i]->addWidget(kard);
        }

        // Create a qlabel to m_pDisplay the message
        QLabel *qlabel;
        qlabel=new QLabel(this);
        qlabel->setText(m_messages[i]);
        m_messageLayouts[i]->addWidget(qlabel);
    }

    //Create selecting button.
    m_pBttnOkay=new QPushButton(this, "okay button");
    m_pBttnOkay->setText(tr("Okay"));
    m_pBttnOkay->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);

    // Create the layout of the dialogue
    m_pDisplay=new QVBoxLayout(this);
    m_pDisplay->setMargin(11);
    m_pDisplay->setSpacing(6);
    for (int i=0; i < static_cast<int>(m_messageLayouts.size()); ++i)
        m_pDisplay->addLayout(m_messageLayouts[i]);
    m_pDisplay->addWidget(m_pBttnOkay);
    connect(m_pBttnOkay, SIGNAL(clicked()), this, SLOT(accept()));
}
