/***************************************************************************
 *   Copyright (C) 2007 by John Schneiderman                               *
 *   JohnMS@member.fsf.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "suitrequest.h"
#include "kardsgterror.h"

#include <qpushbutton.h>
#include <qlabel.h>
#include <qcombobox.h>
#include <qlayout.h>

SuitRequest::SuitRequest(const QString &caption, bool canPass, bool canBidNoSuit, QWidget *parent, const char *name, bool modal): QDialog(parent, name, modal, WPaintClever | WRepaintNoErase)
{
    setMaximumSize(parent->width(), parent->height());
    setCaption(caption);
    m_pLayout = new QVBoxLayout(this);

    // Create instructions label
    m_pLblInstructions = new QLabel(this, "m_pLblInstructions");
    m_pLblInstructions->setText("Please select a suit:");
    m_pLayout->addWidget(m_pLblInstructions);

    // Create horizontal layout for spin box and button
    QHBoxLayout *m_pSpinBoxButtonLayout = new QHBoxLayout(m_pLayout);

    // Create Combo Box
    m_pCmbBxSuit = new QComboBox( this, "m_pCmbBxSuit" );
    m_pCmbBxSuit->insertItem("Spades");
    m_pCmbBxSuit->insertItem("Hearts");
    m_pCmbBxSuit->insertItem("Clubs");
    m_pCmbBxSuit->insertItem("Diamonds");
    if (canPass)
        m_pCmbBxSuit->insertItem("Pass");
    if (canBidNoSuit)
        m_pCmbBxSuit->insertItem("No Suit");
    m_pCmbBxSuit->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);
    m_pSpinBoxButtonLayout->addSpacing(15);
    m_pSpinBoxButtonLayout->addWidget(m_pCmbBxSuit);
    // Create Button
    m_pBttnSuit = new QPushButton(this, "m_pBttnSuit");
    m_pBttnSuit->setText("Select");
    m_pBttnSuit->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);
    connect(m_pBttnSuit, SIGNAL(clicked()), this, SLOT(accept()));
    m_pSpinBoxButtonLayout->addSpacing(30);
    m_pSpinBoxButtonLayout->addWidget(m_pBttnSuit);
    m_pSpinBoxButtonLayout->addSpacing(15);
}

SuitRequest::~SuitRequest()
{
    delete m_pBttnSuit;
    delete m_pLblInstructions;
    delete m_pCmbBxSuit;
    delete m_pLayout;
}

Card::Suit SuitRequest::suit() const
{
    Card::Suit selectedSuit;

    switch (m_pCmbBxSuit->currentItem())
    {
    case 0:
        selectedSuit = Card::SPADES;
        break;
    case 1:
        selectedSuit = Card::HEARTS;
        break;
    case 2:
        selectedSuit = Card::CLUBS;
        break;
    case 3:
        selectedSuit = Card::DIAMONDS;
        break;
    case 4:
    case 5:
        selectedSuit = Card::SUIT_ERR;
        break;
    default:
        throw KardsGTError("SuitRequest", "suit", "Failed to determine suit selection!");
    }
    return selectedSuit;
}
