/***************************************************************************
 *   Copyright (C) 2005 by John Schneiderman                               *
 *   JohnMS@member.fsf.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 ***************************************************************************/
#ifndef CRIBBAGEPLAYER_H
#define CRIBBAGEPLAYER_H

#include "computerplayer.h"
#include "cribbagerules.h"

class AIBase;
class Card;
class CardSequence;
class CribbageRules;

/**
 * This is a cribbage computer player.
 *
 * @author John Schneiderman
 */
class CribbagePlayer: public ComputerPlayer
{
public:
    /**
     * This is the default constructor.
     * @param aiBase is the information on how we want to play Cribbage.
     */
    CribbagePlayer(AIBase &aiBase);
    /**
     * This is the default destructor.
     */
    ~CribbagePlayer();
    /**
     * This requests that the computer play a card.
     * @param playSequence is the current play sequence in the round.
     * @return the card to play.
     */
    virtual Card playCard(const CardSequence &playSequence) const;
    /**
     * This requests that the computer pass two cards to the crib.
     * @note The cards that the player selects are removed from the players hand.
     * @return the cards to pass to the crib.
     */
    CardSequence passToCrib();

private:
    /// @param m_rules is the rules to the game.
    CribbageRules m_rules;
};
#endif
