/***************************************************************************
 *   Copyright (C) 2006 by John Schneiderman                               *
 *   JohnMS@member.fsf.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 ***************************************************************************/
#include "spadesplayer.h"
#include "cardsequence.h"
#include "aibase.h"

SpadesPlayer::SpadesPlayer(AIBase &aiBase): ComputerPlayer(aiBase)
{
    m_pRules = 0;
}

SpadesPlayer::~SpadesPlayer()
{}

Card SpadesPlayer::playCard(const CardSequence& playSequence) const
{
    return m_pAIBase->whichCards("spades", playSequence, *m_pRules, m_hand, m_gameInformation).front();
}

SpadesRules::SpecialBidTypes SpadesPlayer::bidDoubleNil() const
{
    if (m_pAIBase->decision("spadesBidDoubleNil", CardSequence(), *m_pRules, m_hand, m_gameInformation, m_score) == SpadesRules::DOUBLE_NIL)
        return SpadesRules::DOUBLE_NIL;
    else
        return SpadesRules::NON_BID;
}

CardSequence SpadesPlayer::selectExchangeCards() const
{
    return m_pAIBase->whichCards("spadesExchangeCards", CardSequence(), *m_pRules, m_hand, m_gameInformation);
}

int SpadesPlayer::bid() const
{
    return m_pAIBase->decision("spadesBidNil", CardSequence(), *m_pRules, m_hand, m_gameInformation, m_score);
}

void SpadesPlayer::setRules(const SpadesRules &rules)
{
    m_pRules = &rules;
}
