/***************************************************************************************************
*****    This file is part of KardsGT.                                                         *****
*****                                                                                          *****
*****    Copyright (C) 2008  John Schneiderman <JohnMS@member.fsf.org>                         *****
*****                                                                                          *****
*****    This program is free software: you can redistribute it and/or modify it under the     *****
*****    terms of the GNU General Public License as published by the Free Software Foundation, *****
*****    either version 3 of the License, or (at your option) any later version.               *****
*****                                                                                          *****
*****    This program is distributed in the hope that it will be useful, but WITHOUT ANY       *****
*****    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A       *****
*****    PARTICULAR PURPOSE.  See the GNU General Public License for more details.             *****
*****                                                                                          *****
*****    You should have received a copy of the GNU General Public License along with this     *****
*****    program. If not, see <http://www.gnu.org/licenses/>.                                  *****
***************************************************************************************************/
#include "configurekardsgt.h"
#include "userprofiledatabase.h"

#include <QDialog>
#include <QWidget>
#include <QFileDialog>
#include <QMessageBox>

#include <vector>
using std::vector;
using std::pair;

ConfigureKardsGT::ConfigureKardsGT(const UserProfileDatabase &database, QWidget *parent): QDialog(parent)
{
    int index = -1;

    Ui::ConfigureKardsGT::setupUi(this);
    // signals and slots connections
    connect(buttonOk, SIGNAL(clicked()), this, SLOT(accept()));
    connect(buttonCancel, SIGNAL(clicked()), this, SLOT(reject()));
    connect(m_pButtonCardBackImageFilename, SIGNAL(clicked()), this, SLOT(setCardBackImageFilename()));
    connect(m_pButtonCardFrontImagePath, SIGNAL(clicked()), this, SLOT(setCardFrontImagePath()));
    connect(m_pButtonNeutralMoodFilename, SIGNAL(clicked()), this, SLOT(setNeutralMoodFilename()));
    connect(m_pButtonHelp, SIGNAL(clicked()), this, SLOT(displayHelp()));
    connect(m_pButtonDefaults, SIGNAL(clicked()), this, SLOT(setDefaults()));
    connect(m_pCardBackImageFilename, SIGNAL(textChanged(const QString&)), this, SLOT(cardBackChange()));
    // Set the card image paths
    m_pCardFrontImagePath->setText(database.pathToCardFrontImages());
    index = m_pCardBackImageFilename->findText(database.cardBackImageFilename());
    if (index != -1)
        m_pCardBackImageFilename->setCurrentIndex(index);
    else
    {
        m_pCardBackImageFilename->addItem(database.cardBackImageFilename());
        m_pCardBackImageFilename->setCurrentIndex(m_pCardBackImageFilename->findText(database.cardBackImageFilename()));
    }
    cardBackChange();
    // Set the player image paths
    index = m_pNeutralMoodFilename->findText(database.userMoodImage("NeutralMood"));
    if (index != -1)
        m_pNeutralMoodFilename->setCurrentIndex(index);
    else
    {
        m_pNeutralMoodFilename->addItem(database.userMoodImage("NeutralMood"));
        index = m_pNeutralMoodFilename->findText(database.userMoodImage("NeutralMood"));
        m_pNeutralMoodFilename->setCurrentIndex(index);
    }
}

QString ConfigureKardsGT::cardFrontImagePath() const
{
    return m_pCardFrontImagePath->text();
}

QString ConfigureKardsGT::cardBackImageFilename() const
{
    return m_pCardBackImageFilename->currentText();
}

QString ConfigureKardsGT::neutralMoodFilename() const
{
    return m_pNeutralMoodFilename->currentText();
}

void ConfigureKardsGT::cardBackChange()
{
    m_pCardBackDisplay->setPixmap(QPixmap(QString(":/cardBacks/" + m_pCardBackImageFilename->currentText())));
    if (m_pCardBackDisplay->pixmap()->isNull())
        m_pCardBackDisplay->setPixmap(m_pCardBackImageFilename->currentText());
}

void ConfigureKardsGT::setCardBackImageFilename()
{
    QString path = QFileDialog::getOpenFileName(
                       this,
                       "Choose the image for the card back",
                       ".",
                       tr("PNG (*.png)\n" "BMP (*.bmp)\n" "JPEG (*.jpeg)\n" "JPG (*.jpg)\n" "XPM (*.xpm)\n" "All files (*)")
                   );

    if (! path.isEmpty())
    {
        m_pCardBackImageFilename->addItem(path);
        m_pCardBackImageFilename->setCurrentIndex(m_pCardBackImageFilename->findText(path));
    }
}

void ConfigureKardsGT::setCardFrontImagePath()
{
    QString path = QFileDialog::getExistingDirectory(
                       this,
                       "Choose the directory that has the card images",
                       "."
                   );

    if (! path.isEmpty())
        m_pCardFrontImagePath->setText(path);
}

void ConfigureKardsGT::setNeutralMoodFilename()
{
    QString path = QFileDialog::getOpenFileName(
                       this,
                       "Choose the image for player's neutral mood",
                       ".",
                       tr("PNG (*.png)\n" "BMP (*.bmp)\n" "JPEG (*.jpeg)\n" "JPG (*.jpg)\n" "XPM (*.xpm)\n" "All files (*)")
                   );

    if (! path.isEmpty())
    {
        m_pNeutralMoodFilename->addItem(path);
        m_pNeutralMoodFilename->setCurrentIndex(m_pNeutralMoodFilename->findText(path));
    }
}

void ConfigureKardsGT::displayHelp()
{
    QMessageBox::information(this, "Configure Help", "Enter the paths you wish to change into the boxes by using the keyboard, or\n using the buttons on the right of the boxes.\n Once you have made the changes you desire, press OK to save.\n If you do not want to save any changes, press cancel.");
}

void ConfigureKardsGT::setDefaults()
{
    m_pCardFrontImagePath->setText("default");
    m_pCardBackImageFilename->setCurrentIndex(0);
    // Set the player image paths
    m_pNeutralMoodFilename->setCurrentIndex(0);
}
