/***************************************************************************************************
*****    This file is part of KardsGT.                                                         *****
*****                                                                                          *****
*****    Copyright (C) 2005-2008  John Schneiderman <JohnMS@member.fsf.org>                    *****
*****                                                                                          *****
*****    This program is free software: you can redistribute it and/or modify it under the     *****
*****    terms of the GNU General Public License as published by the Free Software Foundation, *****
*****    either version 3 of the License, or (at your option) any later version.               *****
*****                                                                                          *****
*****    This program is distributed in the hope that it will be useful, but WITHOUT ANY       *****
*****    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A       *****
*****    PARTICULAR PURPOSE.  See the GNU General Public License for more details.             *****
*****                                                                                          *****
*****    You should have received a copy of the GNU General Public License along with this     *****
*****    program. If not, see <http://www.gnu.org/licenses/>.                                  *****
***************************************************************************************************/
#ifndef BIT_MANIPULATOR_H
#define BIT_MANIPULATOR_H

#include <string>
using std::string;
#include <vector>
using std::vector;

/**
 * This is used to make it easy to work with bits.
 *
 * @author John Schneiderman
 */
class BitManipulator
{
public:
    /**
     * Creates a bit extraction mask.
     * @param maskLength is how many bits you want your mask to be.
     * @param maskStart is where the first bit is that you wish to start extracting from.
     * @return the mask bit pattern needed to extract a sequence of bits.
     */
    static unsigned mask(int maskLength, short maskStart);
    /**
     * Creates a representation of a base 10 number in base 2.
     * @param number is the base 10 number you wish to convert.
     * @return a string that represents the base 2 number equivalent.
     */
    static string base10ToBase2(long number);
    /**
     * Prints out the bit pattern of a variable.
     * @param variable is the variable whose bits you wish to display.
     * @param numberBits is how many bits of the variable to print out to.
     * @param breakUp is how the bits should be grouped.
     */
    static void printBits(unsigned variable, int numberBits, int breakUp);
    /**
     * Generates a bit sequence.
     * @param length is the number of bits to generate the sequence to.
     * @return an array filled with the numbers starting from 1 to length in base 2.
     */
    static vector<string> binarySequence(int length);
};
#endif
