/***************************************************************************************************
*****    This file is part of KardsGT.                                                         *****
*****                                                                                          *****
*****    Copyright (C) 2006-2008  John Schneiderman <JohnMS@member.fsf.org>                    *****
*****                                                                                          *****
*****    This program is free software: you can redistribute it and/or modify it under the     *****
*****    terms of the GNU General Public License as published by the Free Software Foundation, *****
*****    either version 3 of the License, or (at your option) any later version.               *****
*****                                                                                          *****
*****    This program is distributed in the hope that it will be useful, but WITHOUT ANY       *****
*****    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A       *****
*****    PARTICULAR PURPOSE.  See the GNU General Public License for more details.             *****
*****                                                                                          *****
*****    You should have received a copy of the GNU General Public License along with this     *****
*****    program. If not, see <http://www.gnu.org/licenses/>.                                  *****
***************************************************************************************************/
#include "bidrequest.h"

#include <QPushButton>
#include <QLabel>
#include <QSpinBox>
#include <QLayout>
#include <QVBoxLayout>
#include <QHBoxLayout>

BidRequest::BidRequest(const QString &caption, int minimum, int maximum, const QString &specialText, QWidget *parent, bool modal): QDialog(parent)
{
    if (parent)
        setMaximumSize(parent->width(), parent->height());
    setWindowTitle(caption);
    setModal(modal);
    m_pLayout = new QVBoxLayout(this);

    // Create instructions label
    m_pLblInstructions = new QLabel();
    if (specialText != "NONE")
        m_pLblInstructions->setText(QString("Bid range:\n Minimum bid: %1\n Maximum bid: %2").arg(specialText).arg(maximum));
    else
        m_pLblInstructions->setText(QString("Bid range:\n Minimum bid: %1\n Maximum bid: %2").arg(minimum).arg(maximum));
    m_pLayout->addWidget(m_pLblInstructions);

    // Create horizontal layout for spin box and button
    QHBoxLayout *m_pSpinBoxButtonLayout = new QHBoxLayout;

    // Create Spin Box
    m_pSpnbxBid = new QSpinBox();
    m_pSpnbxBid->setMinimum(minimum);
    m_pSpnbxBid->setMaximum(maximum);
    if (specialText != "NONE")
        m_pSpnbxBid->setSpecialValueText(specialText);
    m_pSpnbxBid->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);
    m_pSpinBoxButtonLayout->addWidget(m_pSpnbxBid);
    // Create Button
    m_pBttnBid = new QPushButton();
    m_pBttnBid->setText("Place Bid");
    m_pBttnBid->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);
    connect(m_pBttnBid, SIGNAL(clicked()), this, SLOT(accept()));
    m_pSpinBoxButtonLayout->addWidget(m_pBttnBid);
    m_pLayout->addLayout(m_pSpinBoxButtonLayout);
    setLayout(m_pLayout);
}

BidRequest::~BidRequest()
{
    delete m_pBttnBid;
    delete m_pLblInstructions;
    delete m_pSpnbxBid;
    delete m_pLayout;
}

int BidRequest::bid() const
{
    return m_pSpnbxBid->value();
}
