/***************************************************************************************************
*****    This file is part of KardsGT.                                                         *****
*****                                                                                          *****
*****    Copyright (C) 2008  John Schneiderman <JohnMS@member.fsf.org>                         *****
*****                                                                                          *****
*****    This program is free software: you can redistribute it and/or modify it under the     *****
*****    terms of the GNU General Public License as published by the Free Software Foundation, *****
*****    either version 3 of the License, or (at your option) any later version.               *****
*****                                                                                          *****
*****    This program is distributed in the hope that it will be useful, but WITHOUT ANY       *****
*****    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A       *****
*****    PARTICULAR PURPOSE.  See the GNU General Public License for more details.             *****
*****                                                                                          *****
*****    You should have received a copy of the GNU General Public License along with this     *****
*****    program. If not, see <http://www.gnu.org/licenses/>.                                  *****
***************************************************************************************************/
#ifndef CRAZY_EIGHTS_PLAYER_H
#define CRAZY_EIGHTS_PLAYER_H

#include "computerplayer.h"
#include "crazyeightsrules.h"

class AIBase;

/**
 * This is a computer player for the game of Crazy Eights.
 *
 * @author John Schneiderman
 */
class CrazyEightsPlayer: public ComputerPlayer
{
public:
    /**
     * The general constructor.
     * @param aiBase is the AI for our computer player.
     */
    CrazyEightsPlayer(AIBase &aiBase);
    /**
     * The default destructor.
     */
    ~CrazyEightsPlayer();
    /**
     * Requests that the AI choose a card for game play.
     * @param playSequence is the current play sequence.
     * @return the card the AI has chosen, or an empty card if the player wishes to pass or draw.
     */
    virtual Card playCard(const CardSequence& playSequence) const;
    /**
     * Requests that the Computer Player to choose a suit to play with.
     * @param playSequence is the current discard sequence in the game. 
     * @return the suit the player wishes to play.
     */
    Card::Suit selectSuit(const CardSequence& playSequence) const;

private:
    /// @param m_rules are the rules for the game of Crazy Eights.
    CrazyEightsRules m_rules;
};
#endif
