/***************************************************************************************************
*****    This file is part of KardsGT.                                                         *****
*****                                                                                          *****
*****    Copyright (C) 2006-2008  John Schneiderman <JohnMS@member.fsf.org>                    *****
*****                                                                                          *****
*****    This program is free software: you can redistribute it and/or modify it under the     *****
*****    terms of the GNU General Public License as published by the Free Software Foundation, *****
*****    either version 3 of the License, or (at your option) any later version.               *****
*****                                                                                          *****
*****    This program is distributed in the hope that it will be useful, but WITHOUT ANY       *****
*****    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A       *****
*****    PARTICULAR PURPOSE.  See the GNU General Public License for more details.             *****
*****                                                                                          *****
*****    You should have received a copy of the GNU General Public License along with this     *****
*****    program. If not, see <http://www.gnu.org/licenses/>.                                  *****
***************************************************************************************************/
#ifndef CRIBBAGEBLOCK_H
#define CRIBBAGEBLOCK_H

#include <QColor>
#include <QWidget>

/**
 * This is a widget to draw the rectangles in a cribbage board.
 *
 * @author John Schneiderman
 */
class CribbageBlock: public QWidget
{
public:
    /**
     * These are the constants used in the creation of the blocks.
     * @param BLOCK_WIDTH is the width of the block.
     * @param BLOCK_HEIGHT is the height of the block.
     * @param VERTICAL says that the brick runs vertically.
     * @param HORIZONTAL says that the brick runs horizontally.
     */
    enum BlockConstants
    {
        BLOCK_WIDTH=4,
        BLOCK_HEIGHT=2,
        VERTICAL=0,
        HORIZONTAL=1
    };

    /**
     * Default constructor.
     * @param colour is the colour of our block.
     * @param numberOfPegs this is how many pegs this block should contain.
     * @param x this is the upper left x coordinate of the block.
     * @param y this is the upper left y coordinate of the block.
     * @param orientation is how this block should orient itself.
     * @param parent is the parent of this widget.
     */
    CribbageBlock(const QColor &colour, int numberOfPegs=1, int x=0, int y=0, int orientation=VERTICAL, QWidget *parent=0);
    /**
     * This gives the current upper left coordinate.
     * @return the upper left coordinate.
     */
    QPoint position() const;
    /**
     * This sets the upper left coordinate.
     * @param x coordinate of the upper left corner.
     * @param y coordinate of the upper left corner.
     */
    void setPosition(int x, int y);
    /**
     * Gives the height of the block.
     * @return how high the block is.
     */
    int height() const;
    /**
     * Sets how high to make the block.
     * @param height is how high to set the block.
     */
    void setHeight(int height);
    /**
     * Draws the a cribbage block.
     * @param painter is where to draw the block.
     */
    void draw(QPainter *painter);

private:
    /// @param m_pegs is the number of pegs in the rectangle.
    int m_pegs;
    /// @param m_positionX is the upper-left hand x-coordinate position of the rectangle.
    int m_positionX;
    /// @param m_positionY is the upper-left hand y-coordinate position of the rectangle.
    int m_positionY;
    /// @param m_height is the height of the rectangle.
    int m_height;
    /// @param m_orientation is the orientation of the rectangle.
    int m_orientation;
    /// @param m_colour is the colour of our block.
    QColor m_colour;
};
#endif
