/***************************************************************************************************
*****    This file is part of KardsGT.                                                         *****
*****                                                                                          *****
*****    Copyright (C) 2006-2008  John Schneiderman <JohnMS@member.fsf.org>                    *****
*****                                                                                          *****
*****    This program is free software: you can redistribute it and/or modify it under the     *****
*****    terms of the GNU General Public License as published by the Free Software Foundation, *****
*****    either version 3 of the License, or (at your option) any later version.               *****
*****                                                                                          *****
*****    This program is distributed in the hope that it will be useful, but WITHOUT ANY       *****
*****    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A       *****
*****    PARTICULAR PURPOSE.  See the GNU General Public License for more details.             *****
*****                                                                                          *****
*****    You should have received a copy of the GNU General Public License along with this     *****
*****    program. If not, see <http://www.gnu.org/licenses/>.                                  *****
***************************************************************************************************/
#include "cribbagepeg.h"

#include <QPainter>

CribbagePeg::CribbagePeg(const QColor &colour, const QPoint &position, bool leadPeg, QWidget *parent): QWidget(parent)
{
    m_score=0;
    m_colour=colour;
    m_lead=m_startLead=leadPeg;
    m_positionX=m_startX=position.x();
    m_positionY=m_startY=position.y();
}

int CribbagePeg::x() const
{
    return m_positionX;
}

int CribbagePeg::y() const
{
    return m_positionY;
}

QPoint CribbagePeg::position() const
{
    return QPoint(m_positionX, m_positionY);
}

QPoint CribbagePeg::startPosition() const
{
    return QPoint(m_startX, m_startY);
}

void CribbagePeg::setPosition(int x, int y)
{
    m_positionX=x;
    m_positionY=y;
}

void CribbagePeg::setPosition(const QPoint &point)
{
    m_positionX=point.x();
    m_positionY=point.y();
}

int CribbagePeg::score() const
{
    return m_score;
}

void CribbagePeg::setScore(int score)
{
    m_score=score;
}

void CribbagePeg::draw(QPainter *painter)
{
    QBrush brush=painter->brush();
    QPen pen=painter->pen();

    painter->setBrush(QBrush(m_colour));
    painter->drawEllipse(m_positionX, m_positionY, PEG_WIDTH, PEG_HEIGHT); // Bottom Peg
    painter->drawEllipse(m_positionX - 2, m_positionY - 2, PEG_WIDTH, PEG_HEIGHT); // Top Peg
    painter->setPen(QPen(m_colour, PEN_WIDTH, Qt::SolidLine));
    painter->drawLine(m_positionX - 1, m_positionY - 1, m_positionX, m_positionY);
    painter->setBrush(brush);
    painter->setPen(pen);
}

const QColor& CribbagePeg::colour() const
{
    return m_colour;
}

bool CribbagePeg::isFront() const
{
    return m_lead;
}

void CribbagePeg::setLead(bool lead)
{
    m_lead=lead;
}

void CribbagePeg::reset()
{
    m_lead=m_startLead;
    setPosition(m_startX, m_startY);
    setScore(0);
}
