/***************************************************************************************************
*****    This file is part of KardsGT.                                                         *****
*****                                                                                          *****
*****    Copyright (C) 2007-2008  John Schneiderman <JohnMS@member.fsf.org>                    *****
*****                                                                                          *****
*****    This program is free software: you can redistribute it and/or modify it under the     *****
*****    terms of the GNU General Public License as published by the Free Software Foundation, *****
*****    either version 3 of the License, or (at your option) any later version.               *****
*****                                                                                          *****
*****    This program is distributed in the hope that it will be useful, but WITHOUT ANY       *****
*****    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A       *****
*****    PARTICULAR PURPOSE.  See the GNU General Public License for more details.             *****
*****                                                                                          *****
*****    You should have received a copy of the GNU General Public License along with this     *****
*****    program. If not, see <http://www.gnu.org/licenses/>.                                  *****
***************************************************************************************************/
#include "euchreplayer.h"
#include "euchrerules.h"
#include "aibase.h"
#include "card.h"
#include "cardsequence.h"

EuchrePlayer::EuchrePlayer(AIBase &aiBase): ComputerPlayer(aiBase)
{
    m_pRules = 0;
}

EuchrePlayer::~EuchrePlayer()
{}

Card EuchrePlayer::playCard(const CardSequence& playSequence) const
{
    return m_pAIBase->whichCards("euchre", playSequence, *m_pRules, m_hand, m_gameInformation).front();
}

bool EuchrePlayer::makeTurnUp(Card::Suit suit) const
{
    CardSequence testSequence;

    testSequence.addCard(Card(Card::RANK_ERR, suit));
    if (m_pAIBase->decision("euchreMakeTurnUp", testSequence, *m_pRules, m_hand, m_gameInformation, m_score) == EuchreRules::WANT_TURN_UP)
        return true;
    else
        return false;
}

Card::Suit EuchrePlayer::selectTrump(Card::Suit suit) const
{
    CardSequence testSequence;
    Card::Suit chosenSuit = Card::SUIT_ERR;

    testSequence.addCard(Card(Card::RANK_ERR, suit));
    chosenSuit = static_cast<Card::Suit>(m_pAIBase->decision("euchreSelectTrump", testSequence, *m_pRules, m_hand, m_gameInformation, m_score));
    return chosenSuit;
}

bool EuchrePlayer::playAlone() const
{
    if (m_pAIBase->decision("euchrePlayAlone", CardSequence(), *m_pRules, m_hand, m_gameInformation, m_score) == EuchreRules::PLAY_ALONE)
        return true;
    else
        return false;
}

bool EuchrePlayer::defendAlone() const
{
    if (m_pAIBase->decision("euchreDefendAlone", CardSequence(), *m_pRules, m_hand, m_gameInformation, m_score) == EuchreRules::DEFEND_ALONE)
        return true;
    else
        return false;
}

void EuchrePlayer::setRules(const EuchreRules &rules)
{
    m_pRules = &rules;
}

bool EuchrePlayer::dealerWantsTurnUp(const Card &turnUp) const
{
    CardSequence testSequence;

    testSequence.addCard(turnUp);
    if (m_pAIBase->decision("euchreWantsTurnUp", testSequence, *m_pRules, m_hand, m_gameInformation, m_score) == EuchreRules::WANT_TURN_UP_CARD)
        return true;
    else
        return false;
}

Card EuchrePlayer::discard() const
{
    return m_pAIBase->whichCards("euchreDiscard", CardSequence(), *m_pRules, m_hand, m_gameInformation).front();
}

