/***************************************************************************************************
*****    This file is part of KardsGT.                                                         *****
*****                                                                                          *****
*****    Copyright (C) 2007-2008  John Schneiderman <JohnMS@member.fsf.org>                    *****
*****                                                                                          *****
*****    This program is free software: you can redistribute it and/or modify it under the     *****
*****    terms of the GNU General Public License as published by the Free Software Foundation, *****
*****    either version 3 of the License, or (at your option) any later version.               *****
*****                                                                                          *****
*****    This program is distributed in the hope that it will be useful, but WITHOUT ANY       *****
*****    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A       *****
*****    PARTICULAR PURPOSE.  See the GNU General Public License for more details.             *****
*****                                                                                          *****
*****    You should have received a copy of the GNU General Public License along with this     *****
*****    program. If not, see <http://www.gnu.org/licenses/>.                                  *****
***************************************************************************************************/
#include "oldmaidplayer.h"
#include "kardsgterror.h"

#include <cmath>
#include <algorithm>
#include <vector>
using std::vector;

OldMaidPlayer::OldMaidPlayer(AIBase &aiBase): ComputerPlayer(aiBase), m_rules()
{
    time_t seconds;

    time(&seconds);
    srand(seconds);
}

OldMaidPlayer::~OldMaidPlayer()
{}

Card OldMaidPlayer::playCard(const CardSequence& ) const
{
    throw KardsGTError("OldMaidRules", "playCard", "Not implemented!");
    return Card();
}

CardSequence OldMaidPlayer::discardPairs() const
{
    CardSequence pairs;
    CardSequence hand = m_hand;
    int size = m_hand.size() - 1;

    sort(hand.begin(), hand.end());
    for (int index=0; index < size; ++index)
        if (m_rules.rankValue(hand[index]) == m_rules.rankValue(hand[index + 1]))
        {
            pairs.addCard(hand[index]);
            pairs.addCard(hand[index + 1]);
            ++index;
        }
    return pairs;
}

int OldMaidPlayer::selectCardIndex(int size) const
{
    return rand() % size;
}

void OldMaidPlayer::rearrangeCards()
{
    int shouldWeShuffle = 0;

    shouldWeShuffle = rand() % 99;
    if (shouldWeShuffle < 75) // Shuffle 75% of the time
        random_shuffle(m_hand.begin(), m_hand.end());
}
