/***************************************************************************************************
*****    This file is part of KardsGT.                                                         *****
*****                                                                                          *****
*****    Copyright (C) 2007-2008  John Schneiderman <JohnMS@member.fsf.org>                    *****
*****                                                                                          *****
*****    This program is free software: you can redistribute it and/or modify it under the     *****
*****    terms of the GNU General Public License as published by the Free Software Foundation, *****
*****    either version 3 of the License, or (at your option) any later version.               *****
*****                                                                                          *****
*****    This program is distributed in the hope that it will be useful, but WITHOUT ANY       *****
*****    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A       *****
*****    PARTICULAR PURPOSE.  See the GNU General Public License for more details.             *****
*****                                                                                          *****
*****    You should have received a copy of the GNU General Public License along with this     *****
*****    program. If not, see <http://www.gnu.org/licenses/>.                                  *****
***************************************************************************************************/
#ifndef OLD_MAID_PLAYER_H
#define OLD_MAID_PLAYER_H

#include "computerplayer.h"
#include "oldmaidrules.h"

class AIBase;

/**
 * This is a computer player for the game of old maid.
 *
 * @author John Schneiderman
 */
class OldMaidPlayer: public ComputerPlayer
{
public:
    /**
     * The general constructor.
     * @param aiBase is the AI for our computer player.
     */
    OldMaidPlayer(AIBase &aiBase);
    /**
     * The default destructor.
     */
    ~OldMaidPlayer();
    /**
     * @throw KardsGTError as this method is not used.
     */
    virtual Card playCard(const CardSequence& playSequence) const;
    /**
     * This requests that our AI discard all his pairs.
     * @return all pairs found.
     */
    CardSequence discardPairs() const;
    /**
     * This requests that our AI select a card index from his left player.
     * @param size is the size of the left player's hand.
     * @return the index of the left player's hand.
     */
    int selectCardIndex(int size) const;
    /**
     * This requests that our AI re-arrange his hand.
     */
    void rearrangeCards();

private:
    /// @param m_rules are the rules for the game of oldmaid.
    OldMaidRules m_rules;
};
#endif
