/***************************************************************************************************
*****    This file is part of KardsGT.                                                         *****
*****                                                                                          *****
*****    Copyright (C) 2007-2008  John Schneiderman <JohnMS@member.fsf.org>                    *****
*****                                                                                          *****
*****    This program is free software: you can redistribute it and/or modify it under the     *****
*****    terms of the GNU General Public License as published by the Free Software Foundation, *****
*****    either version 3 of the License, or (at your option) any later version.               *****
*****                                                                                          *****
*****    This program is distributed in the hope that it will be useful, but WITHOUT ANY       *****
*****    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A       *****
*****    PARTICULAR PURPOSE.  See the GNU General Public License for more details.             *****
*****                                                                                          *****
*****    You should have received a copy of the GNU General Public License along with this     *****
*****    program. If not, see <http://www.gnu.org/licenses/>.                                  *****
***************************************************************************************************/
#include "oldmaidrules.h"
#include "playerlist.h"
#include "kardsgterror.h"

OldMaidRules::OldMaidRules()
{}

OldMaidRules::~OldMaidRules()
{}

bool OldMaidRules::isGameOver(const PlayerList& players) const
{
    int size = players.size();
    int numberOfCardHolders = 0;

    for (int index = 0; index < size; ++index)
        if (! players[index].hand().isEmpty())
            ++numberOfCardHolders;
    if (numberOfCardHolders > 1)
        return false;
    else
        return true;
}

bool OldMaidRules::isLegalPlay(const CardSequence& leftPlayer, const Card& cardPlayed, const Player &player) const
{
    if (player.hand().isEmpty())
        return false;
    if (leftPlayer.hasCard(cardPlayed))
        return true;
    return false;
}

bool OldMaidRules::isPhaseOver(const PlayerList &, const CardSequence &) const
{
    throw KardsGTError("OldMaidRules", "isPhaseOver", "Not implemented!");
    return false;
}

bool OldMaidRules::isRoundOver(const PlayerList& ) const
{
    throw KardsGTError("OldMaidRules", "isRoundOver", "Not implemented!");
    return false;
}

int OldMaidRules::cardValue(const Card& ) const
{
    throw KardsGTError("OldMaidRules", "cardValue", "Not implemented!");
    return -1;
}

int OldMaidRules::rankValue(const Card& card) const
{
    return card.rank();
}

int OldMaidRules::maximumNumberOfPlayers() const
{
    return MAXIMUM_PLAYERS;
}

int OldMaidRules::minimumNumberOfPlayers() const
{
    return MINIMUM_PLAYERS;
}

int OldMaidRules::numberOfCardsToDeal(int) const
{
    throw KardsGTError("OldMaidRules", "numberOfCardsToDeal", "Not implemented!");
}

int OldMaidRules::winningGameScore(int) const
{
    throw KardsGTError("OldMaidRules", "winningGameScore", "Not implemented!");
    return -1;
}
