/***************************************************************************************************
*****    This file is part of KardsGT.                                                         *****
*****                                                                                          *****
*****    Copyright (C) 2007-2008  John Schneiderman <JohnMS@member.fsf.org>                    *****
*****                                                                                          *****
*****    This program is free software: you can redistribute it and/or modify it under the     *****
*****    terms of the GNU General Public License as published by the Free Software Foundation, *****
*****    either version 3 of the License, or (at your option) any later version.               *****
*****                                                                                          *****
*****    This program is distributed in the hope that it will be useful, but WITHOUT ANY       *****
*****    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A       *****
*****    PARTICULAR PURPOSE.  See the GNU General Public License for more details.             *****
*****                                                                                          *****
*****    You should have received a copy of the GNU General Public License along with this     *****
*****    program. If not, see <http://www.gnu.org/licenses/>.                                  *****
***************************************************************************************************/
#ifndef OLD_MAID_RULES_H
#define OLD_MAID_RULES_H

#include "rulebase.h"

class CardSequence;

/**
 * The rules for a game of old maid.
 *
 * @author John Schneiderman
 */
class OldMaidRules : public RuleBase
{
public:
    /**
     * Default constructor.
     */
    OldMaidRules();
    /**
     * Default destructor.
     */
    ~OldMaidRules();
    /**
     * This determines if the conditions have been met for the game to end.
     * @param players are the players in the game.
     * @return true if the conditions have been met, false elsewise.
     */
    virtual bool isGameOver(const PlayerList& players) const;
    /**
     * This determines if a card being played is a legal play.
     * @param sequence is the hand of the player to the left of the current player.
     * @param cardPlayed is the card the player wants to player.
     * @param player is the player who played the card.
     * @return true if the card played is a legal play, false elsewise.
     */
    virtual bool isLegalPlay(const CardSequence& sequence, const Card& cardPlayed, const Player& player) const;
    /**
     * @throw KardsGTError as this method is not used.
     */
    virtual bool isPhaseOver(const PlayerList &, const CardSequence &) const;
    /**
     * @throw KardsGTError as this method is not used.
     */
    virtual bool isRoundOver(const PlayerList& players) const;
    /**
     * @throw KardsGTError as this method is not used.
     */
    virtual int cardValue(const Card& card) const;
    /**
     * Gives the rank order value for a card.
     * @param card is the card we wish to examine.
     * @return the rank value of the card.
     */
    virtual int rankValue(const Card &card) const;
    /**
     * Gives the maximum number of players allowed in the game.
     * @return the maximum number of players.
     */
    virtual int maximumNumberOfPlayers() const;
    /**
     * Gives the minimum number of players need for the game.
     * @return the minimum number of players.
     */
    virtual int minimumNumberOfPlayers() const;
    /**
     * @throw KardsGTError as this method is not used.
     */
    virtual int numberOfCardsToDeal(int numberOfPlayers) const;
    /**
     * @throw KardsGTError as this method is not used.
     */
    virtual int winningGameScore(int numberOfPlayers = -1) const;

private:
    /**
     * These are the private constants for the rules of Old Maid.
     * @param MINIMUM_PLAYERS is the minimum number of players needed.
     * @param MAXIMUM_PLAYERS is the maximum number of players allowed.
     */
    enum PrivateConstants
    {
        MINIMUM_PLAYERS = 2,
        MAXIMUM_PLAYERS = 8,
    };
};
#endif
