/***************************************************************************
                          khttrackmainwizard.h  -  description
                             -------------------
    begin                : Wed Jun 19 2002
    copyright            : (C) 2002 by Stphane Chapeau
    email                : nuscly-devel@laposte.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KHTTRACKMAINWIZARD_H
#define KHTTRACKMAINWIZARD_H


#include <qwidget.h>
#include <mainwizard.h>

// manipulation widgets graphiques
#include <qcombobox.h>
#include <qmultilineedit.h>
#include <qlineedit.h>
#include <qradiobutton.h>

#include <qstring.h>

#include "khproject.h"
#include "khttrackoptions.h"
#include "khttrackstruct.h"

#include "khttrackmirror.h"

/**
  *@author Stphane Chapeau
  */

//class KhttrackStruct;

class KhttrackMainWizard : public MainWizard  {
   Q_OBJECT
public: 
	KhttrackMainWizard(QWidget *parent=0, const char *name=0);
	~KhttrackMainWizard();

  /** Graphics init and construction */
  void initWizard();
  KhttrackOptions *options;

  /** project link */
  KhttrackStruct *project;

  /** mirror link launch */
  KhttrackMirror *kMirrorView;
private:

public slots:
   void slotAction();
   void slotOption();
   void slotProjectBrowse();
   void slotProjectInfo();
   void slotProjectName();
   void slotProjectPath();
   void slotStartHour();
   void slotStartNow();
   void slotStartSave();
   void slotTimeHour();
   void slotTimeMin();
   void slotTimeSec();
   void slotUrlAdd();
   void slotUrlBrowse();
   void slotUrlEdit();
   void slotUrlPath();

   // Close window
   void accept();
   void help ();
private: // Private methods


};

#endif
