# Makefile.inc
#
# Copyright 2011-2012 Roan Trail, Inc.
#
# This file is part of Kinetophone.
#
# Kinetophone is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published
# by the Free Software Foundation, either version 2 of the License,
# or (at your option) any later version.
#
# Kinetophone is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.  You should have received
# a copy of the GNU General Public License along with Kinetophone. If
# not, see <http://www.gnu.org/licenses/>.

# Note: can define KINETOPHONE_CONFIG_DIR to override default of "../share/kinetophone"
# for custom location of configuration data for example:
# TODO: add this as a configuration option?
#
# -DKINETOPHONE_CONFIG_DIR="\"/../data/kinetophone\""

#
# Debug options
#
if CFG_COND_DEBUG
#  debug
FLAG_OPTIMIZE = -g
FLAG_DEF_NDEBUG =
FLAG_STRIP_SYMBOLS =
else
#  non-debug
FLAG_OPTIMIZE = -O2
FLAG_DEF_NDEBUG = -DNDEBUG
FLAG_STRIP_SYMBOLS = -s
endif

######################################
# Options to enforce code standards: #
######################################

# Note: flag/warning mapping to relevant standards rule:
#
# (FOR DOCUMENTATION ONLY, DO NOT UNCOMMENT!)
#
#   -std=c++98 -pedantic-errors # Standards Rule 8
#   -Wtrigraphs -- Standards Rule 11 (enabled by -Wall)
#   -Weffc++ -- Standards Rule 74 (EFFC++ #12), Rule 76 (EFFC++ #11), Rule 78 (EFFC++ #14),
#            --   Rule 82 (EFFC++ #15), Rule 111 (EFFC++ #23), Rule 159 (MEC++ #7)
#   -Wreorder -- Standards Rule 75
#   -Wmissing-braces -- Standards Rule 144 (enabled by -Wall)
#   -Wparentheses -- Standards Rule 160
#   -Wsign-compare -- Standards Rule 162 (enabled by -Wextra)
#   -Wswitch-enum -- Standards Rule 194 (enabled by -Wall)
#   -Wswitch
#   -Wfloat-equal -- Standards Rule 202
#   -Wsequence-point -- Standards Rule 204, Rule 204.1 (enabled by -Wall)
#   -fstrict-overflow -Wstrict-overflow=5 -- Standards Rule 212?
# EXTRA_STANDARDS_WARNINGS:
#   -Wold-style-cast -- Standards Rule 185
#   -Wshadow -- Standards Rule 135
#   -Wuninitialized -O1 -- Standards Rule 142
#   -Wunreachable-code -- Standards Rule 186

if CFG_COND_STANDARDS
STANDARDS_WARNINGS = -Weffc++ \
                     -Wreorder \
                     -Wparentheses \
                     -Wfloat-equal \
                     -fstrict-overflow -Wstrict-overflow=5
STANDARDS_FLAGS = -std=c++98 -pedantic-errors
else
STANDARDS_WARNINGS =
STANDARDS_FLAGS =
endif

if CFG_COND_EXTRA_STANDARDS
#   Can cause false positives but are useful in code review
EXTRA_STANDARDS_WARNINGS = -Wold-style-cast \
                           -Wshadow \
                           -Wuninitialized -O1 \
                           -Wunreachable-code
else
EXTRA_STANDARDS_WARNINGS =
endif

if CFG_COND_EXTRA_STRICT
EXTRA_STRICT_WERROR = -Werror
EXTRA_STRICT_WARNINGS = -Wextra \
                        -Wswitch-default \
                        -Wformat=2 -Wunused -Winit-self \
                        -Wconversion -Wsign-conversion -Waddress -Wlogical-op \
                        -Wmissing-declarations -Woverloaded-virtual
else
EXTRA_STRICT_WERROR =
EXTRA_STRICT_WARNINGS =
endif

CXX_WARNINGS = -Wall \
               $(EXTRA_STRICT_WERROR) \
               $(EXTRA_STRICT_WARNINGS) \
               $(STANDARDS_FLAGS) $(STANDARDS_WARNINGS) $(EXTRA_STANDARDS_WARNINGS)

#
# Setup the automake compiler flags
#
#   Preprocessor flags
AM_CPPFLAGS = $(FLAG_DEF_NDEBUG)
#   C++ flags
AM_CXXFLAGS = -fmessage-length=0 -pthread \
              -fno-nonansi-builtins \
              $(FLAG_OPTIMIZE) @CFG_FLAG_ARCH@ @CFG_FLAG_OFFSET_64@ \
              $(CXX_WARNINGS)
#   C flags
AM_CFLAGS = -fmessage-length=0 $(EXTRA_STRICT_WERROR) -Wall \
            $(FLAG_OPTIMIZE) @CFG_FLAG_ARCH@ @CFG_FLAG_OFFSET_64@
#   Linker flags
AM_LDFLAGS = $(FLAG_STRIP_SYMBOLS)

# Statically link Boost libraries
# BOOST_LIBS = @BOOST_LIB_DIR@/libboost_program_options.a \
#              @BOOST_LIB_DIR@/libboost_filesystem.a \
#              @BOOST_LIB_DIR@/libboost_system.a

# Shared Boost libraries
BOOST_LIBS = @BOOST_PROGRAM_OPTIONS_LIB@ @BOOST_FILESYSTEM_LIB@ \
             @BOOST_SYSTEM_LIB@

LIBS = @LIBS@ ${BOOST_LIBS} @CFG_PORTAUDIO_LIBS@ @CFG_LIBSNDFILE_LIBS@
