// Application.hpp
//
// Copyright 2011-2012 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef APPLICATION_HPP_
#define APPLICATION_HPP_

#include <string>

using std::string;

namespace Roan_trail
{
  class Application
  {
  public:
    // Constructor/destructor/copy
    Application(int argc, const char** argv);
    virtual ~Application();
    // accessors
    const int argc() { return m_argc; }
    const char** argv() { return m_argv; }
    const string &installation_dir() { return m_installation_dir; }
    static Application* application();
    // mutators
    void set_installation_dir(const string& installation_dir);
    // other
    virtual int run() = 0;
    virtual void terminate(int code, const string &message);
  protected:
    // invariant check
    bool mf_invariant(bool check_base_class = true) const;
  private:
    const int m_argc;
    const char** m_argv;
    string m_installation_dir;
    static Application *m_application;
    static bool m_class_initialized;
    // prevent compiler from generating
    Application(const Application& app);
    Application& operator=(const Application& app);
  };
}

#endif // APPLICATION_HPP_
