// Narration_recorder_importer.hpp
//
// Copyright 2012 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef NARRATION_RECORDER_IMPORTER_HPP_
#define NARRATION_RECORDER_IMPORTER_HPP_

#include "common.hpp"
#include "Recorder.hpp"
#include <string>
#include <vector>

namespace xmlpp
{
  class Node;
}

using std::string;
using std::vector;
using xmlpp::Node;

namespace Roan_trail
{
  class Error;
  class Error_param;

  namespace Recorder
  {
    class Segment;

    class Narration_recorder_importer : public Recorder {
    public:
      static bool import_segments_from_XML(const string& file_path,
                                           const Node* XML_node,
                                           vector<Segment>& return_segments,
                                           Error_param& return_error);
      static bool import_audio_recording_from_XML(const string& file_path,
                                                  const Node* XML_node,
                                                  string& return_audio_recording_path,
                                                  Long_int& return_audio_recording_frame_rate,
                                                  Error_param& return_error);
    private:
      // prevent compiler from generating
      Narration_recorder_importer();
      Narration_recorder_importer(const Narration_recorder_importer& i);
      Narration_recorder_importer& operator=(const Narration_recorder_importer& i);
    };
  }
}

#endif // NARRATION_RECORDER_IMPORTER_HPP_
