// Recorder.cpp
//
// Copyright 2011-2012 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#include "Recorder.hpp"
#include "error/Error.hpp"

using namespace Roan_trail::Recorder;

//
// Control
//

void Recorder::record()
{
  precondition((state_recording != m_state)
               && mf_invariant());

  m_state = state_recording;

  postcondition((state_recording == m_state)
                && mf_invariant());
}

void Recorder::pause()
{
  precondition((state_recording == m_state)
               && mf_invariant());

  m_state = state_paused;

  postcondition((state_paused == m_state)
                && mf_invariant());
}

void Recorder::stop()
{
  precondition((state_stopped != m_state)
               && mf_invariant());

  m_state = state_stopped;

  postcondition((state_stopped == m_state)
                && mf_invariant());
}

//
// State constants
//

const int Recorder::state_stopped;
const int Recorder::state_paused;
const int Recorder::state_recording;

//
// Protected member functions
//

// invariant check
bool Recorder::mf_invariant(bool check_base_class) const
{
  static_cast<void>(check_base_class); // avoid unused warning

  bool return_value = false;

  if ((m_state < Recorder::state_stopped) || (m_state > Recorder::state_recording))
  {
    goto exit_point;
  }

  return_value = true;

 exit_point:

  return return_value;
}
