// Sound_recorder_config.hpp
//
// Copyright 2011 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef SOUND_RECORDER_CONFIG_HPP_
#define SOUND_RECORDER_CONFIG_HPP_

#include <map>
#include <string>

using std::string;
using std::map;

// helper struct to store sound recorder settings

namespace Roan_trail
{
  namespace Recorder
  {
    struct Sound_file_config;

    struct Sound_recorder_config
    {
    public:
      // constructor/destructor/copy
      Sound_recorder_config();
      ~Sound_recorder_config();
      Sound_recorder_config(const Sound_recorder_config& r);
      Sound_recorder_config& operator=(const Sound_recorder_config& r);
      // structure data members
      int input_device;
      int frames_per_buffer;
      int write_buffer_factor; // factor to multiply frames_per_buffer (input) to get write buffer size
      int RMS_level_integration_period;
      Sound_file_config *sound_file;
      bool file_overwrite;
      // operators
      bool operator==(const Sound_recorder_config& config) const;
      bool operator!=(const Sound_recorder_config& config) const;
      bool from_map(const map<string, string>& config_map);
      bool to_map(map<string, string>& return_config_map) const;
      // struct constants
      //   default constants
      static const int default_input_device;
      static const int default_frames_per_buffer;
      static const int default_write_buffer_factor;
      static const int default_RMS_level_integration_period; // milliseconds
    };
  }
}

#endif // SOUND_RECORDER_CONFIG_HPP_
