// Sound_source.hpp
//
// Copyright 2012 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef SOUND_SOURCE_HPP_
#define SOUND_SOURCE_HPP_

#include "common.hpp"
#include <string>

using std::string;

namespace Roan_trail
{
  class Error;
  class Error_param;

  namespace Recorder
  {
    struct Sound_file_config;
  }

  using Recorder::Sound_file_config;

  namespace Builder
  {
    class Sound_source
    {
    public:
      // sound source functions
      //   accessors
      virtual const Sound_file_config& config() const = 0;
      virtual int frame_size() const = 0;
      //   used to request a count of frames from a sound source,
      //   returns the actual (less than or equal to the request)
      //   frames generated or 0 if no more are available
      virtual const uint8_t* sound(Long_int start_frame,
                                   Long_int request_frame_count,
                                   Long_int& return_frame_count,
                                   Error_param& error_param) = 0;
      //   used to request a count of silence frames
      //   returns the actual (less than or equal to the request)
      //   frames generated
      virtual const uint8_t* silence(Long_int request_frame_count,
                                     Long_int& return_frame_count,
                                     Error_param& error_param) = 0;
    };
  }
}

#endif // SOUND_SOURCE_HPP_
