// Build_error.hpp
//
// Copyright 2011-2012 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef BUILD_ERROR_HPP_
#define BUILD_ERROR_HPP_

#include "Error.hpp"
#include <map>

using std::map;

namespace Roan_trail
{
  namespace Builder
  {
    class Build_error : public Error
    {
    public:
      // constructor/destructor/copy/clone
      Build_error(const char* file,
                  const char* function,
                  int line,
                  int code,
                  const Error* base_error = 0);
      Build_error(const char* file,
                  const char* function,
                  int line,
                  int code,
                  const string& file_path,
                  const string& to_path = "",
                  const string& diagnostic = "",
                  const Error* base_error = 0);
      virtual Build_error* clone() const { return new Build_error(*this); }
      // other
      virtual string error_class() const { return "Build_error"; }
      // error codes
      // code for none should always be 0
      static const int none                                 = 0x000 + 0;
      // code for general error should always be 1
      static const int general                              = 0x000 + 1;
      // pre-build checks
      //   output directory
      static const int prebuild_output_dir_access           = 0x100 + 0;
      static const int prebuild_insuff_output_space         = 0x100 + 1;
      //   output movies
      static const int prebuild_movie_exists_overwrite      = 0x100 + 2;
      static const int prebuild_movie_exists_no_overwrite   = 0x100 + 3;
      //   temporary directory
      static const int prebuild_insuff_temp_space           = 0x100 + 4;
      // sound
      //   source
      static const int source_sound_file_read_alignment     = 0x200 + 0;
      static const int source_sound_file_open               = 0x200 + 1;
      static const int source_sound_file_read               = 0x200 + 2;
      static const int source_sound_file_convert            = 0x200 + 3;
      static const int source_sound_file_convert_format     = 0x200 + 4;
      static const int source_sound_file_close              = 0x200 + 5;
      //   temporary
      static const int temporary_sound_file_create          = 0x300 + 0;
      static const int temporary_sound_file_initialize      = 0x300 + 1;
      static const int temporary_sound_file_write           = 0x300 + 2;
      static const int temporary_sound_file_close           = 0x300 + 3;
      static const int temporary_sound_file_remove          = 0x300 + 4;
      // movie
      //   temporary
      static const int temporary_movie_create               = 0x400 + 0;
      static const int temporary_movie_write                = 0x400 + 1;
      static const int temporary_movie_close                = 0x400 + 2;
      static const int temporary_movie_remove               = 0x400 + 3;
      //   destination
      static const int destination_movie_remove             = 0x500 + 0;
      static const int move_temporary_to_destination_movie  = 0x500 + 1;
      static const int destination_movie_change_permissions = 0x500 + 2;
      // image source
      static const int image_source_not_available           = 0x600 + 0;
      // misc
      static const int setup                                = 0x700 + 0;
    protected:
      // invariant check
      bool mf_invariant(bool check_base_class = true) const;
    private:
      static map<int, string> m_default_diagnostic_map;
      //
      static void mf_setup_default_diagnostic_map();
      //
      void mf_set_diagnostic(const string& diagnostic);
      // prevent compiler from generating
      Build_error operator=(const Build_error& e);
    };
  }
}

#endif // BUILD_ERROR_HPP_
