// Curses_error.cpp
//
// Copyright 2011-2012 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#include "Curses_error.hpp"
#include "../common.hpp"
#include <string>

using std::string;
using namespace Roan_trail;

//
// Constructor/destructor/copy
//

Curses_error::Curses_error(const char* curses_function_name, const Error* base_error)
  : Error(0,
          curses_function_name,
          0,
          0,
          base_error)
{
  Error_dictionary &dict = error_dictionary();
  string diagnostic = "console I/O error";
  if (curses_function_name && (*curses_function_name != '\0'))
  {
    const string fn_name = string(curses_function_name);
    diagnostic += string(" when ") + mf_fn_description(fn_name)
      + string(" (function name: ") + fn_name + string(")");
  }
  dict[Error::diagnostic_error_key] = diagnostic;

  postcondition(mf_invariant(false));
}

//
// Protected member functions
//

bool Curses_error::mf_invariant(bool check_base_class) const
{
  bool return_value = false;

  if (!file().empty() || line() || code())
  {
    goto exit_point;
  }
  else if (m_fn_description_map.empty())
  {
    goto exit_point;
  }
  else
  {
    return_value = (!check_base_class || Error::mf_invariant(check_base_class));
  }

 exit_point:

  return return_value;
}

//
// Private class members
//

Curses_error::Fn_description_map Curses_error::m_fn_description_map;

//
// Private member functions
//

string Curses_error::mf_fn_description(const string& fn_name)
{
  if (!m_fn_description_map.size())
  {
    // function description map is a singleton for this class
    m_fn_description_map[string("newterm")] = string("intializing console");
    m_fn_description_map[string("def_prog_mode")] = string("setting console for program");
    m_fn_description_map[string("raw")] = string("setting raw mode for console");
    m_fn_description_map[string("noecho")] = string("setting no echo of input to console");
    m_fn_description_map[string("timeout")] = string("setting amount of time waiting for input");
    m_fn_description_map[string("curs_set")] = string("setting cursor visibility");
    m_fn_description_map[string("printw")] = string("printing to console");
  }

  string description = m_fn_description_map[fn_name];
  if ("" == description)
  {
    description = "performing a console operation";
  }

  return description;
}
