// Kinetophone_error.hpp
//
// Copyright 2011-2012 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef KINETOPHONE_ERROR_HPP_
#define KINETOPHONE_ERROR_HPP_

#include "Error.hpp"

namespace Roan_trail
{
  namespace Kinetophone
  {
    class Kinetophone_error : public Error
    {
    public:
      // constructor/destructor/copy
      Kinetophone_error(const char* file,
                        const char* function,
                        int line,
                        int code,
                        const string& diagnostic,
                        const Error* base_error = 0);
      Kinetophone_error(const char* file,
                        const char* function,
                        int line,
                        int code,
                        const string& diagnostic,
                        const string& file_path,
                        const Error* base_error = 0);
      Kinetophone_error(const char* file,
                        const char* function,
                        int line,
                        int code,
                        const Error* base_error = 0);
      virtual Kinetophone_error* clone() const { return new Kinetophone_error(*this); }
      //
      virtual string error_class() const { return "Kinetophone_error"; }
      // error codes
      static const int none               =  0; // code for none should always be 0
      static const int general            =  1; // code for general error should always be 1
      static const int startup            =  2;
      static const int record             =  3;
      static const int shutdown           =  4;
      static const int list_devices       =  5;
      static const int command_line       =  6;
      static const int console            =  7;
      static const int window             =  8;
      static const int server             =  9;
      static const int client             = 10;
      static const int source_load        = 11;
      static const int build              = 12;
      static const int build_warning      = 13;
      static const int file_IO            = 14;
    protected:
      // invariant check
      bool mf_invariant(bool check_base_class = true) const;
      //
      virtual bool mf_is_user_error() const { return code() != general; }
    private:
      static Error_code_string_map m_code_string_map;
      // private member functions
      string mf_set_error_code_string(int code);
      // prevent compiler from generating
      Kinetophone_error operator=(const Kinetophone_error& e);
    };
  }
}

#endif // KINETOPHONE_ERROR_HPP_
