// Record_error.cpp
//
// Copyright 2011-2012 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#include "Record_error.hpp"
#include "../common.hpp"

using namespace Roan_trail::Recorder;

//
// Constructor/destructor/copy
//

Record_error::Record_error(const char* file,
                           const char* function,
                           int line,
                           int code,
                           const Error* base_error)
  : Error(file,
          function,
          line,
          code,
          base_error)
{
  postcondition(mf_invariant(false));
}

Record_error::Record_error(const char* file,
                           const char* function,
                           int line,
                           int code,
                           const string& diagnostic,
                           const string& file_path,
                           const Error* base_error)
  : Error(file,
          function,
          line,
          code,
          base_error)
{
  if ("" != diagnostic)
  {
    error_dictionary()[Error::diagnostic_error_key] = diagnostic;
  }

  if ("" != file_path)
  {
    error_dictionary()[Error::file_path_error_key] = file_path;
  }

  postcondition(mf_invariant(false));
}

//
// Error codes
//
const int Record_error::none;
const int Record_error::general;
const int Record_error::startup;
const int Record_error::record_callback;
const int Record_error::record_write;
const int Record_error::open_input_stream;
const int Record_error::record;
const int Record_error::pause;
const int Record_error::mute;
const int Record_error::stop;
const int Record_error::invalid_state;
const int Record_error::parse_segments;
const int Record_error::load;
const int Record_error::save;
const int Record_error::shutdown;

//
// Protected member functions
//

bool Record_error::mf_invariant(bool check_base_class) const
{
  bool return_value = false;

  if ((code() < Record_error::none) || (code() > Record_error::shutdown))
  {
    goto exit_point;
  }
  else
  {
    return_value = (!check_base_class || Error::mf_invariant(check_base_class));
  }

 exit_point:

  return return_value;
}
