// Sndfile_error.hpp
//
// Copyright 2011-2012 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef SNDFILE_ERROR_HPP_
#define SNDFILE_ERROR_HPP_

#include "Error.hpp"
#include <string>

using std::string;

namespace Roan_trail
{
  namespace Recorder
  {
    class Sndfile_error : public Error
    {
    public:
      // constructor/destructor/copy/clone
      Sndfile_error(int error_code,
                    const char* function_name,
                    const char* file_path,
                    const Error* base_error = 0);
      virtual Sndfile_error* clone() const { return new Sndfile_error(*this); }
      // other
      virtual string error_class() const { return "Sndfile_error"; }
    protected:
      // invariant check
      bool mf_invariant(bool check_base_class = true) const;
    private:
      // prevent compiler from generating
      Sndfile_error operator=(const Sndfile_error& e);
    };
  }
}

#endif // SNDFILE_ERROR_HPP_
