// Console_controller.hpp
//
// Copyright 2011 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef CONSOLE_CONTROLLER_HPP_
#define CONSOLE_CONTROLLER_HPP_

#include <vector>

using std::vector;

namespace Roan_trail
{
  class Error;
  class Error_param;

  class Console_controller
  {
  public:
    Console_controller() {}
    virtual ~Console_controller() {}
    virtual bool process_input(bool& return_done, Error_param& return_error) = 0;
  protected:
    // invariant check
    bool mf_invariant(bool check_base_class = true) const;
  private:
    // prevent the compiler from generating
    Console_controller(const Console_controller& c);
    Console_controller& operator=(const Console_controller& c);
  };
}

#endif // CONSOLE_CONTROLLER_HPP_
