// Kinetophone_console_view.hpp
//
// Copyright 2011 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef KINETOPHONE_CONSOLE_VIEW_HPP_
#define KINETOPHONE_CONSOLE_VIEW_HPP_

#include "../base/View.hpp"
#include <string>
#include <vector>

using std::string;
using std::vector;

namespace Roan_trail
{
  class Error;
  class Error_param;
  class Console_level_meter_view;

  namespace Kinetophone
  {
    class Kinetophone_model;
    class Kinetophone_console_config;

    class Kinetophone_console_view : public View
    {
    public:
      Kinetophone_console_view(const Kinetophone_model& model, const Kinetophone_console_config& config);
      ~Kinetophone_console_view();
      // accessors
      bool confirm_overwrite() const { return m_confirm_overwrite; }
      bool confirm_stop() const { return m_confirm_stop; }
      bool has_level_meter() const { return m_level_meter_view != 0; }
      bool level_meter_peak_mode() const;
      // mutators
      void resize();
      void set_confirm_overwrite(bool confirm) { m_confirm_overwrite = confirm; }
      void set_confirm_stop(bool confirm) { m_confirm_stop = confirm; }
      void set_level_meter_peak_mode(bool peak_mode);
      // view update
      virtual bool update(Error_param& return_error);
      // commands
      void clear();
      // commands (class member functions)
      static void output(const string& message);
      static void output_error(const string& message);
      static bool list_devices(Error_param& return_error);
    protected:
      // invariant check
      bool mf_invariant(bool check_base_class = true) const;
    private:
      const Kinetophone_model& m_model;
      const Kinetophone_console_config& m_config;
      Console_level_meter_view* m_level_meter_view;
      int m_console_width;
      int m_console_height;
      mutable string m_display_string_cache;
      mutable string m_file_size_string_cache;
      mutable string m_available_string_cache;
      mutable string m_audio_info_string_cache;
      string m_recording_file;
      vector<double> m_level;
      bool m_confirm_overwrite;
      bool m_confirm_stop;
      //
      static const int m_default_console_width;
      static const int m_default_console_height;
      static const int m_minimum_console_width;
      //
      const string& mf_format_display_string() const;
      const string& mf_format_file_size_string() const;
      const string& mf_format_available_string() const;
      const string& mf_format_audio_info_string() const;
      // prevent the compiler from generating defaults
      Kinetophone_console_view(const Kinetophone_console_view& view);
      Kinetophone_console_view& operator=(const Kinetophone_console_view& view);
    };
  }
}

#endif // KINETOPHONE_CONSOLE_VIEW_HPP_
