// Kinetophone_dbus_client_recorder.hpp
//
// Copyright 2011 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef KINETOPHONE_DBUS_CLIENT_RECORDER_HPP_
#define KINETOPHONE_DBUS_CLIENT_RECORDER_HPP_

#include <dbus-c++/dbus.h>
#include "Kinetophone_dbus_client_glue.hpp"

using DBus::Connection;
using DBus::IntrospectableProxy;
using DBus::ObjectProxy;

namespace Roan_trail
{
  namespace Kinetophone {
    class Kinetophone_dbus_client_recorder
      : public com::roantrail::dbus::kinetophone::recorder_proxy,
        public IntrospectableProxy,
        public ObjectProxy
    {
    public:
      // constructor, destructor
      Kinetophone_dbus_client_recorder(Connection& connection,
                                       const char* path,
                                       const char* name);
    protected:
      bool mf_invariant(bool check_base_class = true) const;
    private:
      // prevent compiler from generating
      Kinetophone_dbus_client_recorder(const Kinetophone_dbus_client_recorder& client);
      Kinetophone_dbus_client_recorder& operator=(const Kinetophone_dbus_client_recorder& client);
    };
  }
}

#endif // KINETOPHONE_DBUS_CLIENT_RECORDER_HPP_

