// Fraction_bar_widget.hpp
//
// Copyright 2011 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef FRACTION_BAR_WIDGET_HPP_
#define FRACTION_BAR_WIDGET_HPP_

#include <gtkmm/widget.h>
#include "../base/View.hpp"

#include <vector>

namespace Gdk
{
  class Color;
  class Rectangle;
}

namespace Glib
{
  template <class T> class RefPtr;
}

namespace Gtk
{
  class Widget;
}

using Gdk::Color;
using Gdk::Rectangle;
using Glib::RefPtr;
using Gtk::Allocation;
using Gtk::Requisition;
using Gtk::Widget;
using std::vector;

namespace Roan_trail
{
  class Error;
  class Error_param;
  class View;

  namespace Kinetophone
  {
    class Fraction_bar_widget : public View, public Widget
    {
    public:
      // constructor/destructor
      Fraction_bar_widget(bool enabled,
                          bool vertical = false,
                          double fraction = -1.0,
                          double warning_fraction = -1.0,
                          double critical_fraction = -1.0,
                          double empty_fraction = -1.0,
                          int bar_thickness = -1,
                          int bar_width = -1,
                          int border_padding = 0);
      virtual ~Fraction_bar_widget();
      // view update
      virtual bool update(Error_param& return_error);
      // accessors
      // mutators
      virtual void set_enabled(bool enabled);
      virtual void set_fraction(double fraction);
      virtual void set_warning_fraction(double warning_fraction);
      virtual void set_critical_fraction(double warning_fraction);
    protected:
      // invariant check
      bool mf_invariant(bool check_base_class = true) const;
      // signal handlers
      virtual void on_size_request(Requisition* return_requisition);
      virtual void on_size_allocate(Allocation& allocation);
      virtual void on_map();
      virtual void on_unmap();
      virtual void on_realize();
      virtual void on_unrealize();
      virtual bool on_expose_event(GdkEventExpose* event);
      //
      RefPtr<Gdk::Window> m_ref_window;
    private:
      bool m_enabled;
      bool m_vertical;
      double m_fraction;
      double m_warning_fraction;
      double m_critical_fraction;
      double m_empty_fraction;
      bool m_show_warning;
      bool m_show_critical;
      bool m_show_empty;
      // rectangles
      //   cached between resize
      Rectangle m_window_rect;
      Rectangle m_bar_background_rect;
      //   cached when update member function is called
      Rectangle m_bar_rect;
      // colors
      Color m_normal_color;
      Color m_empty_color;
      Color m_warning_color;
      Color m_critical_color;
      Color m_background_color;
      Color m_disabled_color;
      //
      const int m_bar_thickness;
      const int m_bar_length;
      const int m_border_padding;
      //
      bool m_widget_sized;
      //
      void mf_calc_widget_size(int& return_height, int& return_width);
      void mf_calc_fixed_rects(const Rectangle& rect);
      void mf_update_bar();
      void mf_setup_colors();
      // prevent compiler from generating
      Fraction_bar_widget(const Fraction_bar_widget& fraction_bar);
      Fraction_bar_widget& operator=(const Fraction_bar_widget& fraction_bar);
    };
  }
}

#endif // FRACTION_BAR_WIDGET_HPP_
