// Kinetophone_narrator_window.hpp
//
// Copyright 2011 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef KINETOPHONE_NARRATOR_WINDOW_HPP_
#define KINETOPHONE_NARRATOR_WINDOW_HPP_

#include <gtkmm/window.h>

#include <string>
#include <vector>

using std::string;
using std::vector;

namespace Gtk
{
  class Alignment;
  class AspectFrame;
  class Builder;
  class Button;
  class ComboBoxText;
  class HButtonBox;
  class Image;
  class InfoBar;
  class Label;
  class MenuItem;
  class Statusbar;
  class TextView;
  class ToggleButton;
  class ToggleToolButton;
  class ToolButton;
  class ToolItem;
  class Widget;
  class Window;
}

using Gtk::Alignment;
using Gtk::AspectFrame;
using Gtk::Builder;
using Gtk::Button;
using Gtk::ComboBoxText;
using Gtk::HButtonBox;
using Gtk::Image;
using Gtk::InfoBar;
using Gtk::Label;
using Gtk::MenuItem;
using Gtk::Statusbar;
using Gtk::TextView;
using Gtk::ToggleButton;
using Gtk::ToggleToolButton;
using Gtk::ToolButton;
using Gtk::ToolItem;
using Gtk::Widget;

namespace Roan_trail
{
  class Error;
  class Error_param;

  namespace Kinetophone
  {
    class Level_meter_widget;
    class Fraction_bar_widget;
    class Scaled_image_widget;
    class Kinetophone_narrator_config;

    class Kinetophone_narrator_window : public Gtk::Window
    {
    public:
      // constructor/destructor/copy
      Kinetophone_narrator_window(const Kinetophone_narrator_config& config);
      ~Kinetophone_narrator_window();
      // commands
      void setup() { m_setup = true; }
      // widgets
      //   standard
      ToolButton* retake_tool_button() { return m_retake_tool_button; }
      ToolButton* previous_tool_button() { return m_previous_tool_button; }
      ToolButton* next_tool_button() { return m_next_tool_button; }
      ToggleToolButton* mute_toggle_tool_button() { return m_mute_toggle_tool_button; }
      ToggleToolButton* pause_toggle_tool_button() { return m_pause_toggle_tool_button; }
      ToggleToolButton* record_toggle_tool_button() { return m_record_toggle_tool_button; }
      ComboBoxText* slide_combo_box_text() { return m_slide_combo_box_text; }
      ToggleButton* level_toggle_button() { return m_level_toggle_button; }
      MenuItem* file_export_session_menu_item() { return m_file_export_session_menu_item; }
      MenuItem* file_quit_menu_item() { return m_file_quit_menu_item; }
      MenuItem* edit_cut_menu_item() { return m_edit_cut_menu_item; }
      MenuItem* edit_copy_menu_item() { return m_edit_copy_menu_item; }
      MenuItem* edit_paste_menu_item() { return m_edit_paste_menu_item; }
      MenuItem* help_about_menu_item() { return m_help_about_menu_item; }
      InfoBar* session_info_bar() { return m_session_info_bar; }
      Label* session_info_label() { return m_session_info_label; }
      Label* space_time_label() { return m_space_time_label; }
      Statusbar* statusbar() { return m_statusbar; }
      AspectFrame* image_aspectframe() { return m_image_aspectframe; }
      Label* record_time_label() { return m_record_time_label; }
      TextView* notes_text_view() { return m_notes_text_view; }
      Button* notes_editing_done_button() { return m_notes_editing_done_button; }
      HButtonBox* thumbnail_browser_hbutton_box() { return m_thumbnail_browser_hbutton_box; }
      //   custom
      Level_meter_widget* audio_level_meter_widget() { return m_audio_level_meter_widget; }
      Fraction_bar_widget* space_available_widget() { return m_space_available_widget; }
      Scaled_image_widget* slide_image_widget() { return m_slide_image_widget; }
      Image* record_icon_start() { return m_record_icon_start; }
      Image* record_icon_stop() { return m_record_icon_stop; }
      Image* record_icon() { return m_record_icon; }
    protected:
      // invariant check
      bool mf_invariant(bool check_base_class = true) const;
    private:
      bool m_setup;
      // widgets
      //   standard
      ToolButton* m_retake_tool_button;
      ToolButton* m_previous_tool_button;
      ToolButton* m_next_tool_button;
      ToggleToolButton* m_mute_toggle_tool_button;
      ToggleToolButton* m_pause_toggle_tool_button;
      ToggleToolButton* m_record_toggle_tool_button;
      ComboBoxText* m_slide_combo_box_text;
      ToggleButton* m_level_toggle_button;
      MenuItem* m_file_export_session_menu_item;
      MenuItem* m_file_quit_menu_item;
      MenuItem* m_edit_cut_menu_item;
      MenuItem* m_edit_copy_menu_item;
      MenuItem* m_edit_paste_menu_item;
      MenuItem* m_help_about_menu_item;
      InfoBar* m_session_info_bar;
      Label* m_session_info_label;
      Label* m_space_time_label;
      Statusbar* m_statusbar;
      AspectFrame* m_image_aspectframe;
      Label* m_record_time_label;
      TextView* m_notes_text_view;
      Button* m_notes_editing_done_button;
      HButtonBox* m_thumbnail_browser_hbutton_box;
      //   custom
      Level_meter_widget *m_audio_level_meter_widget;
      Fraction_bar_widget *m_space_available_widget;
      Scaled_image_widget* m_slide_image_widget;
      //   icon
      Image* m_record_icon_start;
      Image* m_record_icon_stop;
      Image* m_record_icon;
      // window setup functions
      void mf_setup(const Kinetophone_narrator_config& config);
      Widget* mf_setup_menu_bar();
      Widget* mf_setup_control_toolbar();
      Widget* mf_setup_session_info_bar();
      Widget* mf_setup_viewer();
      Widget* mf_setup_accessories(const Kinetophone_narrator_config& config);
      Widget* mf_setup_thumbnail_browser();
      Widget* mf_setup_statusbar();
      void mf_setup_accelerators();
      // prevent compiler from generating
      Kinetophone_narrator_window(const Kinetophone_narrator_window& w);
      Kinetophone_narrator_window& operator=(const Kinetophone_narrator_window& w);
    };
  }
}

#endif // KINETOPHONE_NARRATOR_WINDOW_HPP_
