// Level_meter_widget.hpp
//
// Copyright 2011 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#ifndef LEVEL_METER_WIDGET_HPP_
#define LEVEL_METER_WIDGET_HPP_

#include <gtkmm/button.h>

#include "../base/Level_meter_view.hpp"
#include <vector>

namespace Gdk
{
  class Color;
  class Rectangle;
}

namespace Glib
{
  template <class T> class RefPtr;
}

namespace Gtk
{
  class Button;
}

using Gdk::Color;
using Gdk::Rectangle;
using Glib::RefPtr;
using Gtk::Allocation;
using Gtk::Button;
using Gtk::Requisition;
using std::vector;

namespace Roan_trail
{
  class Error;
  class Error_param;
  class Level_meter_view;

  namespace Kinetophone
  {
    class Level_meter_widget : public Level_meter_view, public Button
    {
    public:
      // constructor/destructor
      Level_meter_widget(int channels,
                         int rate,
                         bool is_vertical = false,
                         bool has_clip_indicator = true,
                         bool has_peak = true,
                         bool model_ballistics = true,
                         int attack_period = -1,
                         int decay_period = -1,
                         int peak_hold_period = -1,
                         int bar_thickness = -1,
                         int bar_length = -1,
                         int clip_indicator_size = -1,
                         int spacing = -1,
                         int border_width = -1);
      virtual ~Level_meter_widget();
      // view update
      virtual bool update(Error_param& return_error);
      // accessors
      int bar_thickness() const { return m_bar_thickness; }
      int bar_length() const { return m_bar_thickness; }
      int clip_indicator_size() const { return m_clip_indicator_size; }
      int spacing() const { return m_spacing; }
      int border_width() const { return m_border_width; }
      bool channel_enabled(int channel) const { return m_enabled[static_cast<size_t>(channel)]; }
      // mutators
      virtual void set_levels(const vector<double>& levels);
      virtual void set_enable_channel(int channel, bool channel_enabled)
      { m_enabled[channel] = channel_enabled; }
    protected:
      // invariant check
      bool mf_invariant(bool check_base_class = true) const;
      // signal handlers
      virtual void on_size_request(Requisition* requisition);
      virtual void on_size_allocate(Allocation& allocation);
      virtual void on_map();
      virtual void on_unmap();
      virtual void on_realize();
      virtual void on_unrealize();
      virtual bool on_expose_event(GdkEventExpose* event);
      virtual void on_clicked();
      //
      RefPtr<Gdk::Window> m_ref_window;
    private:
      // update logic
      vector<bool> m_enabled;
      vector<bool> m_show_warning;
      vector<bool> m_show_critical;
      vector<bool> m_show_peak;
      // rectangles
      //   cached between resize
      vector<Rectangle> m_bar_background_rect;
      vector<Rectangle> m_normal_background_rect;
      vector<Rectangle> m_warning_background_rect;
      vector<Rectangle> m_critical_background_rect;
      vector<Rectangle> m_clip_indicator_background_rect;
      //   cached when update member function is called
      vector<Rectangle> m_normal_rect;
      vector<Rectangle> m_warning_rect;
      vector<Rectangle> m_critical_rect;
      vector<Rectangle> m_peak_rect;
      // colors
      //   cached when update member function is called
      vector<Color> m_peak_color;
      //   class
      static bool m_have_colors;
      static Color m_normal_color;
      static Color m_warning_color;
      static Color m_critical_color;
      static Color m_background_normal_color;
      static Color m_background_warning_color;
      static Color m_background_critical_color;
      static Color m_disabled_color;
      // meter attributes
      bool m_has_clip_indicator;
      bool m_has_peak;
      int m_bar_thickness;
      int m_bar_length;
      int m_clip_indicator_size;
      int m_spacing;
      int m_border_width;
      //
      bool m_widget_sized;
      //
      void mf_resize_vectors();
      void mf_calc_widget_size(int& return_height, int& return_width);
      void mf_calc_fixed_rects(const Rectangle& rect);
      void mf_update_meters();
      //
      static void mf_setup_colors();
      // prevent compiler from generating
      Level_meter_widget(const Level_meter_widget& level_meter);
      Level_meter_widget& operator=(const Level_meter_widget& level_meter);
    };
  }
}

#endif // LEVEL_METER_WIDGET_HPP_
