// Check_basic_char_set.cpp
//
// Copyright 2011 Roan Trail, Inc.
//
// This file is part of Kinetophone.
//
// Kinetophone is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation, either version 2 of the License,
// or (at your option) any later version.
//
// Kinetophone is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.  You should have received
// a copy of the GNU General Public License along with Kinetophone. If
// not, see <http://www.gnu.org/licenses/>.

#include <iostream>
#include <fstream>
#include <string>
#include <cassert>
#include <cstring>

int main(int argc, char *argv[])
{
  int return_value = 1;

  char c;
  int line = 1;
  int col = 1;

  // omit \t\v\f from Standards Rule #96 character set, since we don't allow control characters
  std::string cpp_basic_char_set(" \n"
                                 "abcdefghijklmnopqrstuvwxyz"
                                 "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
                                 "0123456789"
                                 "_{}[]#()<>%:;.?*+-"
                                 "/^&|~!=,\\\"'");
  assert(cpp_basic_char_set.length() == 93 && "error, basic character set is not 93 characters");

  std::ifstream file(argv[1]);
  if (!file)
  {
    std::cerr << "Could not open file: " << argv[1] << std::endl;
    goto exit_point;
  }

  while (!file.eof()) {
    file.get(c);
    if (c == '\n')
    {
      ++line;
      col = 1;
    }
    int i = cpp_basic_char_set.find(c);
    if (std::string::npos == i)
    {
      std::cerr << "Found code not in C++ basic character set, code = " << c;
      std::cerr << " in " << argv[1] << " line " << line << " col " << col << std::endl;
      goto exit_point;
    }
    ++col;
  }

  return_value = 0;

 exit_point:
  return return_value;
}
