-- MySQL dump 10.9
--
-- Host: localhost    Database: koha2
-- ------------------------------------------------------
-- Server version	4.1.15-nt

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `academic_information`
--

DROP TABLE IF EXISTS `academic_information`;
CREATE TABLE `academic_information` (
  `borrowernumber` int(11) NOT NULL default '0',
  `id_career` mediumint(9) NOT NULL default '0',
  `student_number` varchar(20) default NULL,
  `enter_year` varchar(4) default NULL,
  `leave_year` varchar(4) default NULL,
  `notes` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`borrowernumber`,`id_career`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `accountlines`
--

DROP TABLE IF EXISTS `accountlines`;
CREATE TABLE `accountlines` (
  `borrowernumber` int(11) NOT NULL default '0',
  `accountno` smallint(6) NOT NULL default '0',
  `itemnumber` int(11) default NULL,
  `date` date default NULL,
  `amount` decimal(28,6) default NULL,
  `description` text character set utf8,
  `dispute` text character set utf8,
  `accounttype` varchar(5) character set utf8 default NULL,
  `amountoutstanding` decimal(28,6) default NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `offset` int(10) unsigned default NULL,
  KEY `acctsborridx` (`borrowernumber`),
  KEY `offset` (`offset`),
  KEY `acct` (`accountno`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_turkish_ci;

--
-- Table structure for table `accountoffsets`
--

DROP TABLE IF EXISTS `accountoffsets`;
CREATE TABLE `accountoffsets` (
  `borrowernumber` int(11) NOT NULL default '0',
  `accountno` smallint(6) NOT NULL default '0',
  `offsetaccount` smallint(6) NOT NULL default '0',
  `offsetamount` decimal(28,6) default NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `action_logs`
--

DROP TABLE IF EXISTS `action_logs`;
CREATE TABLE `action_logs` (
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `user` varchar(45) NOT NULL default '',
  `module` varchar(45) NOT NULL default '',
  `action` varchar(45) NOT NULL default '',
  `object` varchar(45) NOT NULL default '',
  `info` text NOT NULL,
  KEY `time` (`timestamp`),
  KEY `action` (`action`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `additionalauthors`
--

DROP TABLE IF EXISTS `additionalauthors`;
CREATE TABLE `additionalauthors` (
  `author` text NOT NULL,
  `biblionumber` int(11) NOT NULL default '0',
  KEY `bibidx` (`biblionumber`),
  FULLTEXT KEY `author` (`author`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `aqbasket`
--

DROP TABLE IF EXISTS `aqbasket`;
CREATE TABLE `aqbasket` (
  `basketno` int(11) NOT NULL auto_increment,
  `creationdate` date default NULL,
  `closedate` date default NULL,
  `booksellerid` varchar(10) default NULL,
  `authorisedby` varchar(10) default NULL,
  `booksellerinvoicenumber` text,
  PRIMARY KEY  (`basketno`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `aqbookfund`
--

DROP TABLE IF EXISTS `aqbookfund`;
CREATE TABLE `aqbookfund` (
  `bookfundid` varchar(5) NOT NULL default '''''',
  `bookfundname` text,
  `bookfundgroup` varchar(5) default NULL,
  PRIMARY KEY  (`bookfundid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `aqbooksellers`
--

DROP TABLE IF EXISTS `aqbooksellers`;
CREATE TABLE `aqbooksellers` (
  `id` int(11) default NULL,
  `name` text,
  `address1` text,
  `address2` text,
  `address3` text,
  `address4` text,
  `phone` varchar(30) default NULL,
  `accountnumber` text,
  `othersupplier` text,
  `currency` varchar(3) NOT NULL default '',
  `deliverydays` smallint(6) default NULL,
  `followupdays` smallint(6) default NULL,
  `followupscancel` smallint(6) default NULL,
  `specialty` text,
  `booksellerfax` text,
  `notes` text,
  `bookselleremail` text,
  `booksellerurl` text,
  `contact` varchar(100) default NULL,
  `postal` text,
  `url` varchar(255) default NULL,
  `contpos` varchar(100) default NULL,
  `contphone` varchar(100) default NULL,
  `contfax` varchar(100) default NULL,
  `contaltphone` varchar(100) default NULL,
  `contemail` varchar(100) default NULL,
  `contnotes` text,
  `active` tinyint(4) default NULL,
  `listprice` varchar(5) default NULL,
  `invoiceprice` varchar(5) default NULL,
  `gstreg` tinyint(4) default NULL,
  `listincgst` tinyint(4) default NULL,
  `invoiceincgst` tinyint(4) default NULL,
  `discount` float(6,4) default NULL,
  `fax` varchar(50) default NULL,
  `nocalc` int(11) default NULL,
  `invoicedisc` float(6,4) default NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `aqbudget`
--

DROP TABLE IF EXISTS `aqbudget`;
CREATE TABLE `aqbudget` (
  `bookfundid` char(5) NOT NULL default '',
  `startdate` date NOT NULL default '0000-00-00',
  `enddate` date default NULL,
  `budgetamount` decimal(13,2) default NULL,
  `aqbudgetid` tinyint(4) NOT NULL auto_increment,
  PRIMARY KEY  (`aqbudgetid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `aqorderbreakdown`
--

DROP TABLE IF EXISTS `aqorderbreakdown`;
CREATE TABLE `aqorderbreakdown` (
  `ordernumber` int(11) default NULL,
  `linenumber` int(11) default NULL,
  `branchcode` char(4) default NULL,
  `bookfundid` char(5) NOT NULL default '',
  `allocation` smallint(6) default NULL,
  KEY `ordernumber` (`ordernumber`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `aqorderdelivery`
--

DROP TABLE IF EXISTS `aqorderdelivery`;
CREATE TABLE `aqorderdelivery` (
  `ordernumber` date NOT NULL default '0000-00-00',
  `deliverynumber` smallint(6) NOT NULL default '0',
  `deliverydate` varchar(18) default NULL,
  `qtydelivered` smallint(6) default NULL,
  `deliverycomments` text,
  KEY `ordernumber` (`ordernumber`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `aqorders`
--

DROP TABLE IF EXISTS `aqorders`;
CREATE TABLE `aqorders` (
  `ordernumber` int(11) NOT NULL auto_increment,
  `biblionumber` int(11) default NULL,
  `title` text,
  `entrydate` date default NULL,
  `quantity` smallint(6) default NULL,
  `currency` varchar(3) default NULL,
  `listprice` decimal(28,6) default NULL,
  `totalamount` decimal(28,6) default NULL,
  `datereceived` date default NULL,
  `booksellerinvoicenumber` text,
  `freight` decimal(28,6) default NULL,
  `unitprice` decimal(28,6) default NULL,
  `quantityreceived` smallint(6) default NULL,
  `cancelledby` varchar(10) default NULL,
  `datecancellationprinted` date default NULL,
  `notes` text,
  `supplierreference` text,
  `purchaseordernumber` text,
  `subscription` tinyint(1) default NULL,
  `serialid` varchar(30) default NULL,
  `basketno` int(11) default NULL,
  `biblioitemnumber` int(11) default NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `rrp` decimal(13,2) default NULL,
  `ecost` decimal(13,2) default NULL,
  `gst` decimal(13,2) default NULL,
  `budgetdate` date default NULL,
  `sort1` varchar(80) default NULL,
  `sort2` varchar(80) default NULL,
  PRIMARY KEY  (`ordernumber`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `attempted_contacts`
--

DROP TABLE IF EXISTS `attempted_contacts`;
CREATE TABLE `attempted_contacts` (
  `borrowernumber` int(11) default NULL,
  `method` varchar(50) default NULL,
  `address` varchar(255) default NULL,
  `result` int(11) default NULL,
  `message` text,
  `date` datetime default NULL,
  KEY `borrowernumber` (`borrowernumber`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `auth_header`
--

DROP TABLE IF EXISTS `auth_header`;
CREATE TABLE `auth_header` (
  `authid` bigint(20) unsigned NOT NULL default '0',
  `authtypecode` varchar(10) NOT NULL default '',
  `datecreated` date NOT NULL default '0000-00-00',
  `datemodified` date default NULL,
  `origincode` varchar(20) default NULL,
  `summary` text NOT NULL,
  `linkid` bigint(20) unsigned NOT NULL default '0',
  `marc` blob NOT NULL,
  PRIMARY KEY  (`authid`,`linkid`),
  KEY `authority` (`authtypecode`),
  KEY `linkid` (`linkid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `auth_subfield_structure`
--

DROP TABLE IF EXISTS `auth_subfield_structure`;
CREATE TABLE `auth_subfield_structure` (
  `authtypecode` varchar(10) NOT NULL default '',
  `tagfield` varchar(3) NOT NULL default '',
  `tagsubfield` char(1) NOT NULL default '',
  `liblibrarian` varchar(255) NOT NULL default '',
  `libopac` varchar(255) NOT NULL default '',
  `repeatable` tinyint(4) NOT NULL default '0',
  `mandatory` tinyint(4) NOT NULL default '0',
  `tab` tinyint(1) default NULL,
  `authorised_value` varchar(10) default NULL,
  `value_builder` varchar(80) default NULL,
  `seealso` varchar(255) default NULL,
  `hidden` tinyint(3) unsigned zerofill NOT NULL default '000',
  `isurl` tinyint(1) unsigned default NULL,
  `kohafield` varchar(45) NOT NULL default '',
  `link` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`authtypecode`,`tagfield`,`tagsubfield`),
  KEY `tab` (`authtypecode`,`tab`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `auth_tag_structure`
--

DROP TABLE IF EXISTS `auth_tag_structure`;
CREATE TABLE `auth_tag_structure` (
  `authtypecode` char(10) NOT NULL default '',
  `tagfield` char(3) NOT NULL default '',
  `liblibrarian` char(255) NOT NULL default '',
  `libopac` char(255) NOT NULL default '',
  `repeatable` tinyint(4) NOT NULL default '0',
  `mandatory` tinyint(4) NOT NULL default '0',
  `authorised_value` char(10) default NULL,
  PRIMARY KEY  (`authtypecode`,`tagfield`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `auth_types`
--

DROP TABLE IF EXISTS `auth_types`;
CREATE TABLE `auth_types` (
  `authtypecode` varchar(10) NOT NULL default '',
  `authtypetext` varchar(255) NOT NULL default '',
  `auth_tag_to_report` varchar(3) NOT NULL default '',
  `summary` text NOT NULL,
  PRIMARY KEY  (`authtypecode`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `authorised_values`
--

DROP TABLE IF EXISTS `authorised_values`;
CREATE TABLE `authorised_values` (
  `id` int(11) NOT NULL auto_increment,
  `category` char(10) NOT NULL default '',
  `authorised_value` char(80) NOT NULL default '',
  `lib` char(80) default NULL,
  PRIMARY KEY  (`id`),
  KEY `name` (`category`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `biblio`
--

DROP TABLE IF EXISTS `biblio`;
CREATE TABLE `biblio` (
  `biblionumber` int(11) NOT NULL default '0',
  `author` text character set utf8,
  `title` text character set utf8,
  `unititle` text character set utf8,
  `notes` text character set utf8,
  `serial` tinyint(1) default NULL,
  `seriestitle` text character set utf8,
  `copyrightdate` smallint(6) default NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `abstract` text character set utf8,
  `frameworkcode` varchar(45) collate utf8_turkish_ci default '',
  PRIMARY KEY  (`biblionumber`),
  FULLTEXT KEY `titlesearch` (`title`,`unititle`,`seriestitle`),
  FULLTEXT KEY `author` (`author`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_turkish_ci;

--
-- Table structure for table `biblio_framework`
--

DROP TABLE IF EXISTS `biblio_framework`;
CREATE TABLE `biblio_framework` (
  `frameworkcode` char(4) NOT NULL default '',
  `frameworktext` char(255) NOT NULL default '',
  PRIMARY KEY  (`frameworkcode`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `biblioanalysis`
--

DROP TABLE IF EXISTS `biblioanalysis`;
CREATE TABLE `biblioanalysis` (
  `analyticaltitle` text,
  `biblionumber` int(11) NOT NULL default '0',
  `analyticalauthor` text,
  KEY `biblionumber` (`biblionumber`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `biblioitems`
--

DROP TABLE IF EXISTS `biblioitems`;
CREATE TABLE `biblioitems` (
  `biblioitemnumber` int(11) NOT NULL default '0',
  `biblionumber` int(11) NOT NULL default '0',
  `volume` text,
  `number` text,
  `classification` varchar(25) default NULL,
  `itemtype` varchar(4) default NULL,
  `isbn` varchar(14) default NULL,
  `issn` varchar(9) default NULL,
  `dewey` varchar(20) default NULL,
  `subclass` varchar(25) default NULL,
  `publicationyear` smallint(6) default NULL,
  `publishercode` varchar(255) default NULL,
  `volumedate` date default NULL,
  `volumeddesc` varchar(255) default NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `illus` varchar(255) default NULL,
  `pages` varchar(255) default NULL,
  `notes` text,
  `size` varchar(255) default NULL,
  `place` varchar(255) default NULL,
  `lccn` varchar(25) default NULL,
  `marc` blob,
  `url` varchar(255) default NULL,
  `language` varchar(20) default NULL,
  `lcsort` varchar(25) default NULL,
  PRIMARY KEY  (`biblioitemnumber`),
  KEY `bibnoidx` (`biblionumber`),
  KEY `lcindex` (`lcsort`,`subclass`),
  FULLTEXT KEY `isbn` (`isbn`,`issn`),
  FULLTEXT KEY `publisher` (`publishercode`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `bibliosubject`
--

DROP TABLE IF EXISTS `bibliosubject`;
CREATE TABLE `bibliosubject` (
  `subject` text NOT NULL,
  `biblionumber` int(11) NOT NULL default '0',
  KEY `biblionumber` (`biblionumber`),
  FULLTEXT KEY `subject` (`subject`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `bibliosubtitle`
--

DROP TABLE IF EXISTS `bibliosubtitle`;
CREATE TABLE `bibliosubtitle` (
  `subtitle` text NOT NULL,
  `biblionumber` int(11) NOT NULL default '0',
  KEY `bibsubidx` (`biblionumber`),
  FULLTEXT KEY `subtitle` (`subtitle`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `bibliothesaurus`
--

DROP TABLE IF EXISTS `bibliothesaurus`;
CREATE TABLE `bibliothesaurus` (
  `id` bigint(20) NOT NULL auto_increment,
  `freelib` char(255) NOT NULL default '',
  `stdlib` char(255) NOT NULL default '',
  `category` char(10) NOT NULL default '',
  `level` tinyint(4) NOT NULL default '1',
  `hierarchy` char(80) NOT NULL default '',
  `father` char(80) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `freelib` (`freelib`),
  KEY `stdlib` (`stdlib`),
  KEY `category` (`category`),
  KEY `hierarchy` (`hierarchy`),
  FULLTEXT KEY `category_2` (`category`,`freelib`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `bookshelf`
--

DROP TABLE IF EXISTS `bookshelf`;
CREATE TABLE `bookshelf` (
  `shelfnumber` int(11) NOT NULL auto_increment,
  `shelfname` char(255) default NULL,
  `owner` char(80) default NULL,
  `category` char(1) default NULL,
  PRIMARY KEY  (`shelfnumber`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `bookshelves_careers`
--

DROP TABLE IF EXISTS `bookshelves_careers`;
CREATE TABLE `bookshelves_careers` (
  `shelfnumber` int(11) NOT NULL default '0',
  `id_career` mediumint(9) NOT NULL default '0',
  PRIMARY KEY  (`shelfnumber`,`id_career`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `borexp`
--

DROP TABLE IF EXISTS `borexp`;
CREATE TABLE `borexp` (
  `borrowernumber` int(11) default NULL,
  `newexp` date default NULL,
  KEY `borrowernumber` (`borrowernumber`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `borrowers`
--

DROP TABLE IF EXISTS `borrowers`;
CREATE TABLE `borrowers` (
  `borrowernumber` int(11) NOT NULL auto_increment,
  `cardnumber` varchar(16) NOT NULL default '',
  `surname` text NOT NULL,
  `firstname` text NOT NULL,
  `title` text,
  `othernames` text,
  `initials` text NOT NULL,
  `streetaddress` text NOT NULL,
  `suburb` text,
  `city` text NOT NULL,
  `phone` text NOT NULL,
  `emailaddress` text,
  `faxnumber` text,
  `textmessaging` text,
  `altstreetaddress` text,
  `altsuburb` text,
  `altcity` text,
  `altphone` text,
  `dateofbirth` date default NULL,
  `branchcode` varchar(4) NOT NULL default '',
  `categorycode` varchar(2) default NULL,
  `dateenrolled` date default NULL,
  `gonenoaddress` tinyint(1) default NULL,
  `lost` tinyint(1) default NULL,
  `debarred` tinyint(1) default NULL,
  `studentnumber` text,
  `school` text,
  `contactname` text,
  `borrowernotes` text,
  `guarantor` int(11) default NULL,
  `area` varchar(2) default NULL,
  `ethnicity` varchar(50) default NULL,
  `ethnotes` varchar(255) default NULL,
  `sex` char(1) default NULL,
  `expiry` date default NULL,
  `altnotes` varchar(255) default NULL,
  `altrelationship` varchar(100) default NULL,
  `streetcity` text,
  `phoneday` varchar(50) default NULL,
  `preferredcont` char(1) default NULL,
  `physstreet` varchar(100) default NULL,
  `password` varchar(30) default NULL,
  `flags` int(11) default NULL,
  `userid` varchar(30) default NULL,
  `homezipcode` varchar(25) default NULL,
  `zipcode` varchar(25) default NULL,
  `sort1` varchar(80) default NULL,
  `sort2` varchar(80) default NULL,
  UNIQUE KEY `cardnumber` (`cardnumber`),
  KEY `borrowernumber` (`borrowernumber`),
  FULLTEXT KEY `namesearch` (`surname`,`firstname`,`othernames`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `branchcategories`
--

DROP TABLE IF EXISTS `branchcategories`;
CREATE TABLE `branchcategories` (
  `categorycode` varchar(4) NOT NULL default '',
  `categoryname` text,
  `codedescription` text,
  PRIMARY KEY  (`categorycode`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `branches`
--

DROP TABLE IF EXISTS `branches`;
CREATE TABLE `branches` (
  `branchcode` varchar(4) NOT NULL default '',
  `branchname` text NOT NULL,
  `branchaddress1` text,
  `branchaddress2` text,
  `branchaddress3` text,
  `branchphone` text,
  `branchfax` text,
  `branchemail` text,
  `issuing` tinyint(4) default NULL,
  UNIQUE KEY `branchcode` (`branchcode`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `branchrelations`
--

DROP TABLE IF EXISTS `branchrelations`;
CREATE TABLE `branchrelations` (
  `branchcode` varchar(4) default NULL,
  `categorycode` varchar(4) default NULL,
  KEY `branchcode` (`branchcode`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `branchtransfers`
--

DROP TABLE IF EXISTS `branchtransfers`;
CREATE TABLE `branchtransfers` (
  `itemnumber` int(11) NOT NULL default '0',
  `datesent` datetime default NULL,
  `frombranch` varchar(4) default NULL,
  `datearrived` datetime default NULL,
  `tobranch` varchar(4) default NULL,
  `comments` text,
  KEY `itemnumber` (`itemnumber`),
  KEY `branch` (`frombranch`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `careers`
--

DROP TABLE IF EXISTS `careers`;
CREATE TABLE `careers` (
  `id_career` mediumint(9) NOT NULL auto_increment,
  `id_institution` smallint(6) NOT NULL default '0',
  `career_name` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`id_career`),
  KEY `id_institution` (`id_institution`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `catalogueentry`
--

DROP TABLE IF EXISTS `catalogueentry`;
CREATE TABLE `catalogueentry` (
  `catalogueentry` text NOT NULL,
  `entrytype` varchar(2) default NULL,
  `see` text,
  `seealso` text,
  `seeinstead` text,
  `biblionumber` int(11) default NULL,
  KEY `biblionumber` (`biblionumber`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
CREATE TABLE `categories` (
  `categorycode` varchar(2) NOT NULL default '',
  `description` text,
  `enrolmentperiod` smallint(6) default NULL,
  `upperagelimit` smallint(6) default NULL,
  `dateofbirthrequired` tinyint(1) default NULL,
  `finetype` varchar(30) default NULL,
  `bulk` tinyint(1) default NULL,
  `enrolmentfee` decimal(28,6) default NULL,
  `overduenoticerequired` tinyint(1) default NULL,
  `issuelimit` smallint(6) default NULL,
  `reservefee` decimal(28,2) default NULL,
  `canmakepublicshelves` tinyint(4) default NULL,
  `allowrenewsfromopac` tinyint(4) default NULL,
  `addRequestToShelves` tinyint(4) default NULL,
  UNIQUE KEY `categorycode` (`categorycode`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `currency`
--

DROP TABLE IF EXISTS `currency`;
CREATE TABLE `currency` (
  `currency` varchar(10) default NULL,
  `rate` float(7,5) default NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `deletedbiblio`
--

DROP TABLE IF EXISTS `deletedbiblio`;
CREATE TABLE `deletedbiblio` (
  `biblionumber` int(11) NOT NULL default '0',
  `author` text,
  `title` text,
  `unititle` text,
  `notes` text,
  `serial` tinyint(1) default NULL,
  `seriestitle` text,
  `copyrightdate` smallint(6) default NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `marc` blob,
  `abstract` text,
  `frameworkcode` varchar(45) default '',
  KEY `blbnoidx` (`biblionumber`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `deletedbiblioitems`
--

DROP TABLE IF EXISTS `deletedbiblioitems`;
CREATE TABLE `deletedbiblioitems` (
  `biblioitemnumber` int(11) NOT NULL default '0',
  `biblionumber` int(11) NOT NULL default '0',
  `volume` text,
  `number` text,
  `classification` varchar(25) default NULL,
  `itemtype` varchar(4) default NULL,
  `isbn` varchar(14) default NULL,
  `issn` varchar(9) default NULL,
  `dewey` double(8,6) default NULL,
  `subclass` varchar(3) default NULL,
  `publicationyear` smallint(6) default NULL,
  `publishercode` varchar(255) default NULL,
  `volumedate` date default NULL,
  `volumeddesc` varchar(255) default NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `illus` varchar(255) default NULL,
  `pages` varchar(255) default NULL,
  `notes` text,
  `size` varchar(255) default NULL,
  `lccn` varchar(25) default NULL,
  `marc` text,
  `url` varchar(255) default NULL,
  PRIMARY KEY  (`biblioitemnumber`),
  KEY `bibinoidx` (`biblioitemnumber`),
  KEY `bibnoidx` (`biblionumber`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `deletedborrowers`
--

DROP TABLE IF EXISTS `deletedborrowers`;
CREATE TABLE `deletedborrowers` (
  `borrowernumber` int(11) NOT NULL default '0',
  `cardnumber` varchar(9) NOT NULL default '',
  `surname` text NOT NULL,
  `firstname` text NOT NULL,
  `title` text,
  `othernames` text,
  `initials` text NOT NULL,
  `streetaddress` text NOT NULL,
  `suburb` text,
  `city` text NOT NULL,
  `phone` text NOT NULL,
  `emailaddress` text,
  `faxnumber` text,
  `altstreetaddress` text,
  `altsuburb` text,
  `altcity` text,
  `altphone` text,
  `dateofbirth` date default NULL,
  `branchcode` varchar(4) NOT NULL default '',
  `categorycode` varchar(2) default NULL,
  `dateenrolled` date default NULL,
  `gonenoaddress` tinyint(1) default NULL,
  `lost` tinyint(1) default NULL,
  `debarred` tinyint(1) default NULL,
  `studentnumber` text,
  `school` text,
  `contactname` text,
  `borrowernotes` text,
  `guarantor` int(11) default NULL,
  `area` varchar(2) default NULL,
  `ethnicity` varchar(50) default NULL,
  `ethnotes` varchar(255) default NULL,
  `sex` char(1) default NULL,
  `expiry` date default NULL,
  `altnotes` varchar(255) default NULL,
  `altrelationship` varchar(100) default NULL,
  `streetcity` text,
  `phoneday` varchar(50) default NULL,
  `preferredcont` varchar(100) default NULL,
  `physstreet` varchar(100) default NULL,
  KEY `borrowernumber` (`borrowernumber`),
  KEY `cardnumber` (`cardnumber`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `deleteditems`
--

DROP TABLE IF EXISTS `deleteditems`;
CREATE TABLE `deleteditems` (
  `itemnumber` int(11) NOT NULL default '0',
  `biblionumber` int(11) NOT NULL default '0',
  `multivolumepart` varchar(30) default NULL,
  `biblioitemnumber` int(11) NOT NULL default '0',
  `barcode` varchar(9) NOT NULL default '',
  `dateaccessioned` date default NULL,
  `booksellerid` varchar(10) default NULL,
  `homebranch` varchar(4) default NULL,
  `price` decimal(28,6) default NULL,
  `replacementprice` decimal(28,6) default NULL,
  `replacementpricedate` date default NULL,
  `datelastborrowed` date default NULL,
  `datelastseen` date default NULL,
  `multivolume` tinyint(1) default NULL,
  `stack` tinyint(1) default NULL,
  `notforloan` tinyint(1) default NULL,
  `itemlost` tinyint(1) default NULL,
  `wthdrawn` tinyint(1) default NULL,
  `bulk` varchar(30) default NULL,
  `issues` smallint(6) default NULL,
  `renewals` smallint(6) default NULL,
  `reserves` smallint(6) default NULL,
  `restricted` tinyint(1) default NULL,
  `binding` decimal(28,6) default NULL,
  `itemnotes` text,
  `holdingbranch` varchar(4) default NULL,
  `interim` tinyint(1) default NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `marc` blob,
  `paidfor` text,
  `location` varchar(80) default NULL,
  `itemcallnumber` varchar(250) default NULL,
  `itemoverdue` tinyint(3) unsigned default NULL,
  `onloan` date NOT NULL default '0000-00-00',
  `lccallnumber` double NOT NULL default '0',
  `lccutter` double NOT NULL default '0',
  `lcdot` double NOT NULL default '0',
  `lcdate` double NOT NULL default '0',
  `cutterdot` double NOT NULL default '0',
  PRIMARY KEY  (`itemnumber`),
  UNIQUE KEY `barcode` (`barcode`),
  KEY `itembarcodeidx` (`barcode`),
  KEY `itembinoidx` (`biblioitemnumber`),
  KEY `itembibnoidx` (`biblionumber`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `educational_institutions`
--

DROP TABLE IF EXISTS `educational_institutions`;
CREATE TABLE `educational_institutions` (
  `id_institution` smallint(6) NOT NULL auto_increment,
  `institution_name` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`id_institution`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `ethnicity`
--

DROP TABLE IF EXISTS `ethnicity`;
CREATE TABLE `ethnicity` (
  `code` varchar(10) NOT NULL default '',
  `name` varchar(255) default NULL,
  PRIMARY KEY  (`code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `issues`
--

DROP TABLE IF EXISTS `issues`;
CREATE TABLE `issues` (
  `issid` int(11) NOT NULL auto_increment,
  `borrowernumber` int(11) NOT NULL default '0',
  `itemnumber` int(11) NOT NULL default '0',
  `date_due` date default NULL,
  `branchcode` char(4) default NULL,
  `issuingbranch` char(18) default NULL,
  `returndate` date default NULL,
  `lastreneweddate` date default NULL,
  `return` char(4) default NULL,
  `renewals` tinyint(4) default NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `issue_date` date default NULL,
  PRIMARY KEY  (`issid`),
  KEY `issuesborridx` (`borrowernumber`),
  KEY `issuesitemidx` (`itemnumber`),
  KEY `bordate` (`borrowernumber`,`timestamp`),
  KEY `duedate` (`date_due`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `issuingrules`
--

DROP TABLE IF EXISTS `issuingrules`;
CREATE TABLE `issuingrules` (
  `categorycode` varchar(2) NOT NULL default '',
  `itemtype` varchar(4) NOT NULL default '',
  `restrictedtype` tinyint(1) default NULL,
  `rentaldiscount` decimal(28,6) default NULL,
  `reservecharge` decimal(28,6) default NULL,
  `fine` decimal(28,6) default NULL,
  `firstremind` int(11) default NULL,
  `chargeperiod` int(11) default NULL,
  `accountsent` int(11) default NULL,
  `chargename` varchar(100) default NULL,
  `maxissueqty` int(4) default NULL,
  `issuelength` int(4) default NULL,
  `branchcode` varchar(4) NOT NULL default '',
  PRIMARY KEY  (`branchcode`,`categorycode`,`itemtype`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `items`
--

DROP TABLE IF EXISTS `items`;
CREATE TABLE `items` (
  `itemnumber` int(11) NOT NULL default '0',
  `biblionumber` int(11) NOT NULL default '0',
  `multivolumepart` varchar(30) default NULL,
  `biblioitemnumber` int(11) NOT NULL default '0',
  `barcode` varchar(20) default NULL,
  `dateaccessioned` date default NULL,
  `booksellerid` varchar(10) default NULL,
  `homebranch` varchar(4) default NULL,
  `price` decimal(8,2) default NULL,
  `replacementprice` decimal(8,2) default NULL,
  `replacementpricedate` date default NULL,
  `datelastborrowed` date default NULL,
  `datelastseen` date default NULL,
  `multivolume` tinyint(1) default NULL,
  `stack` varchar(15) default NULL,
  `notforloan` tinyint(1) default NULL,
  `itemlost` tinyint(1) default NULL,
  `wthdrawn` tinyint(1) default NULL,
  `itemcallnumber` varchar(30) default NULL,
  `issues` smallint(6) default NULL,
  `renewals` smallint(6) default NULL,
  `reserves` smallint(6) default NULL,
  `restricted` tinyint(1) default NULL,
  `binding` decimal(28,6) default NULL,
  `itemnotes` text,
  `holdingbranch` varchar(4) default NULL,
  `paidfor` text,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `location` varchar(80) default NULL,
  `itemoverdue` tinyint(1) unsigned default NULL,
  `onloan` date default NULL,
  `Cutterextra` varchar(45) default '',
  PRIMARY KEY  (`itemnumber`),
  UNIQUE KEY `itembarcodeidx` USING BTREE (`barcode`),
  KEY `itembinoidx` (`biblioitemnumber`),
  KEY `itembibnoidx` (`biblionumber`),
  KEY `itemcallnumber` (`itemcallnumber`),
  KEY `LC` (`Cutterextra`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `itemsprices`
--

DROP TABLE IF EXISTS `itemsprices`;
CREATE TABLE `itemsprices` (
  `itemnumber` int(11) default NULL,
  `price1` decimal(28,6) default NULL,
  `price2` decimal(28,6) default NULL,
  KEY `itemnumber` (`itemnumber`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `itemtypes`
--

DROP TABLE IF EXISTS `itemtypes`;
CREATE TABLE `itemtypes` (
  `itemtype` varchar(4) NOT NULL default '',
  `description` text,
  `renewalsallowed` smallint(6) default NULL,
  `rentalcharge` double(16,4) default NULL,
  `notforloan` smallint(6) default NULL,
  UNIQUE KEY `itemtype` (`itemtype`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `marc_breeding`
--

DROP TABLE IF EXISTS `marc_breeding`;
CREATE TABLE `marc_breeding` (
  `id` bigint(20) NOT NULL auto_increment,
  `file` varchar(80) NOT NULL default '',
  `isbn` varchar(10) NOT NULL default '',
  `title` varchar(128) default NULL,
  `author` varchar(80) default NULL,
  `marc` text NOT NULL,
  `encoding` varchar(40) NOT NULL default '''''',
  `z3950random` varchar(40) default NULL,
  `classification` varchar(45) default '',
  `subclass` varchar(45) default '',
  PRIMARY KEY  (`id`),
  KEY `title` (`title`),
  KEY `isbn` (`isbn`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `marc_subfield_structure`
--

DROP TABLE IF EXISTS `marc_subfield_structure`;
CREATE TABLE `marc_subfield_structure` (
  `tagfield` varchar(3) NOT NULL default '',
  `tagsubfield` char(1) NOT NULL default '',
  `liblibrarian` varchar(255) NOT NULL default '',
  `libopac` varchar(255) NOT NULL default '',
  `repeatable` tinyint(4) NOT NULL default '0',
  `mandatory` tinyint(4) NOT NULL default '0',
  `kohafield` varchar(40) default NULL,
  `tab` tinyint(1) default NULL,
  `authorised_value` varchar(10) default NULL,
  `authtypecode` varchar(10) default NULL,
  `value_builder` varchar(80) default NULL,
  `isurl` tinyint(1) default NULL,
  `hidden` tinyint(1) default NULL,
  `frameworkcode` varchar(4) NOT NULL default '',
  `seealso` text,
  `link` varchar(80) default NULL,
  PRIMARY KEY  (`frameworkcode`,`tagfield`,`tagsubfield`),
  KEY `kohafield_2` (`kohafield`),
  KEY `tab` (`frameworkcode`,`tab`),
  KEY `kohafield` (`frameworkcode`,`kohafield`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `marc_tag_structure`
--

DROP TABLE IF EXISTS `marc_tag_structure`;
CREATE TABLE `marc_tag_structure` (
  `tagfield` char(3) NOT NULL default '',
  `liblibrarian` char(255) NOT NULL default '',
  `libopac` char(255) NOT NULL default '',
  `repeatable` tinyint(4) NOT NULL default '0',
  `mandatory` tinyint(4) NOT NULL default '0',
  `authorised_value` char(10) default NULL,
  `frameworkcode` char(4) NOT NULL default '',
  PRIMARY KEY  (`frameworkcode`,`tagfield`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `marcrecorddone`
--

DROP TABLE IF EXISTS `marcrecorddone`;
CREATE TABLE `marcrecorddone` (
  `isbn` char(40) default NULL,
  `issn` char(40) default NULL,
  `lccn` char(40) default NULL,
  `controlnumber` char(40) default NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `notdistinctspchk`
--

DROP TABLE IF EXISTS `notdistinctspchk`;
CREATE TABLE `notdistinctspchk` (
  `display` varchar(40) NOT NULL default '',
  `suggestion` varchar(45) NOT NULL default '',
  `resultcount` varchar(45) NOT NULL default '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `opac_electronic`
--

DROP TABLE IF EXISTS `opac_electronic`;
CREATE TABLE `opac_electronic` (
  `idelectronic` int(4) NOT NULL auto_increment,
  `title` varchar(250) NOT NULL default '',
  `edata` text,
  `lang` varchar(4) NOT NULL default '',
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `image` varchar(250) default NULL,
  `href` varchar(250) default NULL,
  `section` varchar(45) NOT NULL default '',
  PRIMARY KEY  (`idelectronic`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `opac_news`
--

DROP TABLE IF EXISTS `opac_news`;
CREATE TABLE `opac_news` (
  `idnew` int(10) unsigned NOT NULL auto_increment,
  `title` varchar(250) NOT NULL default '',
  `new` text NOT NULL,
  `lang` varchar(4) NOT NULL default '',
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`idnew`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `phrase_log`
--

DROP TABLE IF EXISTS `phrase_log`;
CREATE TABLE `phrase_log` (
  `phr_phrase` varchar(100) NOT NULL default '',
  `phr_resultcount` int(11) NOT NULL default '0',
  `phr_ip` varchar(30) NOT NULL default '',
  `user` varchar(45) default NULL,
  `date` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `actual` text NOT NULL,
  KEY `phr_ip` (`phr_ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `printers`
--

DROP TABLE IF EXISTS `printers`;
CREATE TABLE `printers` (
  `printername` char(40) NOT NULL default '''''',
  `printqueue` char(20) default NULL,
  `printtype` char(20) default NULL,
  PRIMARY KEY  (`printername`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `ratings`
--

DROP TABLE IF EXISTS `ratings`;
CREATE TABLE `ratings` (
  `biblioitemnumber` int(11) NOT NULL default '0',
  `biblionumber` int(11) default NULL,
  `rating` varchar(100) default NULL,
  `modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`biblioitemnumber`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `repeatable_holidays`
--

DROP TABLE IF EXISTS `repeatable_holidays`;
CREATE TABLE `repeatable_holidays` (
  `id` int(11) NOT NULL auto_increment,
  `branchcode` varchar(4) NOT NULL default '',
  `weekday` smallint(6) default NULL,
  `day` smallint(6) default NULL,
  `month` smallint(6) default NULL,
  `title` varchar(50) NOT NULL default '',
  `description` text NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `reserveconstraints`
--

DROP TABLE IF EXISTS `reserveconstraints`;
CREATE TABLE `reserveconstraints` (
  `borrowernumber` int(11) NOT NULL default '0',
  `reservedate` date NOT NULL default '0000-00-00',
  `biblionumber` int(11) NOT NULL default '0',
  `biblioitemnumber` int(11) default NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  KEY `borrowernumber` (`borrowernumber`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `reserveissue`
--

DROP TABLE IF EXISTS `reserveissue`;
CREATE TABLE `reserveissue` (
  `resid` int(10) unsigned NOT NULL auto_increment,
  `borrowernumber` int(10) unsigned NOT NULL default '0',
  `itemnumber` int(10) unsigned NOT NULL default '0',
  `restime` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `rettime` datetime default NULL,
  `duetime` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`resid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `reserves`
--

DROP TABLE IF EXISTS `reserves`;
CREATE TABLE `reserves` (
  `borrowernumber` int(11) NOT NULL default '0',
  `reservedate` date NOT NULL default '0000-00-00',
  `biblionumber` int(11) NOT NULL default '0',
  `constrainttype` char(1) default NULL,
  `branchcode` varchar(4) default NULL,
  `notificationdate` date default NULL,
  `reminderdate` date default NULL,
  `cancellationdate` date default NULL,
  `reservenotes` text,
  `priority` smallint(6) default NULL,
  `found` char(1) default NULL,
  `timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `itemnumber` int(11) default NULL,
  `reservefrom` date NOT NULL default '0000-00-00',
  `reserveto` date NOT NULL default '0000-00-00',
  `registeredby` varchar(45) NOT NULL default '',
  `reserveid` int(10) unsigned NOT NULL auto_increment,
  PRIMARY KEY  (`reserveid`),
  KEY `borrowernumber` (`borrowernumber`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `serial`
--

DROP TABLE IF EXISTS `serial`;
CREATE TABLE `serial` (
  `serialid` int(11) NOT NULL auto_increment,
  `biblionumber` varchar(100) NOT NULL default '',
  `subscriptionid` varchar(100) NOT NULL default '',
  `serialseq` varchar(100) NOT NULL default '',
  `status` tinyint(4) NOT NULL default '0',
  `planneddate` date NOT NULL default '0000-00-00',
  PRIMARY KEY  (`serialid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `sessionqueries`
--

DROP TABLE IF EXISTS `sessionqueries`;
CREATE TABLE `sessionqueries` (
  `sessionID` varchar(255) NOT NULL default '',
  `userid` varchar(100) NOT NULL default '',
  `ip` varchar(18) NOT NULL default '',
  `url` text NOT NULL,
  KEY `sessionID` (`sessionID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `sessions`
--

DROP TABLE IF EXISTS `sessions`;
CREATE TABLE `sessions` (
  `sessionID` varchar(255) NOT NULL default '',
  `userid` varchar(255) default NULL,
  `ip` varchar(16) default NULL,
  `lasttime` int(11) default NULL,
  PRIMARY KEY  (`sessionID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `shelf_requests`
--

DROP TABLE IF EXISTS `shelf_requests`;
CREATE TABLE `shelf_requests` (
  `idrequest` int(11) NOT NULL auto_increment,
  `shelfnumber` int(11) NOT NULL default '0',
  `request_name` varchar(50) NOT NULL default '',
  `request_type` varchar(50) NOT NULL default '',
  `status` varchar(50) NOT NULL default '',
  `request_date` date NOT NULL default '0000-00-00',
  `coments` varchar(250) NOT NULL default '',
  PRIMARY KEY  (`idrequest`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `shelfcontents`
--

DROP TABLE IF EXISTS `shelfcontents`;
CREATE TABLE `shelfcontents` (
  `shelfnumber` int(11) NOT NULL default '0',
  `itemnumber` int(11) NOT NULL default '0',
  `flags` int(11) default NULL,
  `biblionumber` varchar(20) NOT NULL default '',
  KEY `shelfnumber` (`shelfnumber`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `special_holidays`
--

DROP TABLE IF EXISTS `special_holidays`;
CREATE TABLE `special_holidays` (
  `id` int(11) NOT NULL auto_increment,
  `branchcode` varchar(4) NOT NULL default '',
  `day` smallint(6) NOT NULL default '0',
  `month` smallint(6) NOT NULL default '0',
  `year` smallint(6) NOT NULL default '0',
  `isexception` smallint(1) NOT NULL default '1',
  `title` varchar(50) NOT NULL default '',
  `description` text NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `spellcheck`
--

DROP TABLE IF EXISTS `spellcheck`;
CREATE TABLE `spellcheck` (
  `display` varchar(40) character set utf8 NOT NULL default '',
  `suggestion` varchar(45) character set utf8 NOT NULL default '',
  `resultcount` varchar(45) character set utf8 NOT NULL default '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin5;

--
-- Table structure for table `statistics`
--

DROP TABLE IF EXISTS `statistics`;
CREATE TABLE `statistics` (
  `datetime` datetime NOT NULL default '0000-00-00 00:00:00',
  `branch` varchar(4) default NULL,
  `proccode` varchar(4) default NULL,
  `value` double(16,4) default NULL,
  `type` varchar(16) default NULL,
  `other` text,
  `usercode` varchar(10) default NULL,
  `itemnumber` int(11) default NULL,
  `itemtype` varchar(4) default NULL,
  `borrowernumber` int(11) default NULL,
  KEY `timeidx` (`datetime`),
  KEY `itemnumber` (`itemnumber`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `stopwords`
--

DROP TABLE IF EXISTS `stopwords`;
CREATE TABLE `stopwords` (
  `word` varchar(255) default NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `subscription`
--

DROP TABLE IF EXISTS `subscription`;
CREATE TABLE `subscription` (
  `biblionumber` int(11) NOT NULL default '0',
  `subscriptionid` int(11) NOT NULL auto_increment,
  `librarian` varchar(100) default '',
  `startdate` date default '0000-00-00',
  `aqbooksellerid` int(11) default '0',
  `cost` int(11) default '0',
  `aqbudgetid` int(11) default '0',
  `weeklength` tinyint(4) default '0',
  `monthlength` tinyint(4) default '0',
  `numberlength` tinyint(4) default '0',
  `periodicity` tinyint(4) default '0',
  `dow` varchar(100) default '',
  `numberingmethod` varchar(100) default '',
  `notes` text,
  `status` varchar(100) NOT NULL default '',
  `add1` int(11) default '0',
  `every1` int(11) default '0',
  `whenmorethan1` int(11) default '0',
  `setto1` int(11) default NULL,
  `lastvalue1` int(11) default NULL,
  `add2` int(11) default '0',
  `every2` int(11) default '0',
  `whenmorethan2` int(11) default '0',
  `setto2` int(11) default NULL,
  `lastvalue2` int(11) default NULL,
  `add3` int(11) default '0',
  `every3` int(11) default '0',
  `innerloop1` int(11) default '0',
  `innerloop2` int(11) default '0',
  `innerloop3` int(11) default '0',
  `whenmorethan3` int(11) default '0',
  `setto3` int(11) default NULL,
  `lastvalue3` int(11) default NULL,
  PRIMARY KEY  (`subscriptionid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `subscriptionhistory`
--

DROP TABLE IF EXISTS `subscriptionhistory`;
CREATE TABLE `subscriptionhistory` (
  `biblionumber` int(11) NOT NULL default '0',
  `subscriptionid` int(11) NOT NULL default '0',
  `histstartdate` date NOT NULL default '0000-00-00',
  `enddate` date default '0000-00-00',
  `missinglist` longtext NOT NULL,
  `recievedlist` longtext NOT NULL,
  `opacnote` varchar(150) NOT NULL default '',
  `librariannote` varchar(150) NOT NULL default '',
  PRIMARY KEY  (`subscriptionid`),
  KEY `biblionumber` (`biblionumber`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `suggestions`
--

DROP TABLE IF EXISTS `suggestions`;
CREATE TABLE `suggestions` (
  `suggestionid` int(8) NOT NULL auto_increment,
  `suggestedby` int(11) NOT NULL default '0',
  `managedby` int(11) default NULL,
  `STATUS` varchar(10) NOT NULL default '',
  `note` text,
  `author` varchar(80) default NULL,
  `title` varchar(80) default NULL,
  `copyrightdate` smallint(6) default NULL,
  `publishercode` varchar(255) default NULL,
  `date` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `volumedesc` varchar(255) default NULL,
  `publicationyear` smallint(6) default '0',
  `place` varchar(255) default NULL,
  `isbn` varchar(10) default NULL,
  `mailoverseeing` smallint(1) default '0',
  `biblionumber` int(11) default NULL,
  PRIMARY KEY  (`suggestionid`),
  KEY `suggestedby` (`suggestedby`),
  KEY `managedby` (`managedby`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `systempreferences`
--

DROP TABLE IF EXISTS `systempreferences`;
CREATE TABLE `systempreferences` (
  `variable` varchar(50) NOT NULL default '',
  `value` text,
  `options` text,
  `explanation` varchar(80) default NULL,
  `type` varchar(20) default NULL,
  PRIMARY KEY  (`variable`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `uploadedmarc`
--

DROP TABLE IF EXISTS `uploadedmarc`;
CREATE TABLE `uploadedmarc` (
  `id` int(11) NOT NULL auto_increment,
  `marc` longblob,
  `hidden` smallint(6) default NULL,
  `name` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `userflags`
--

DROP TABLE IF EXISTS `userflags`;
CREATE TABLE `userflags` (
  `bit` int(11) NOT NULL default '0',
  `flag` char(30) default NULL,
  `flagdesc` char(255) default NULL,
  `defaulton` int(11) default NULL,
  KEY `bit` (`bit`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `usercode` varchar(10) default NULL,
  `username` text,
  `password` text,
  `level` smallint(6) default NULL,
  UNIQUE KEY `usercode` (`usercode`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `websites`
--

DROP TABLE IF EXISTS `websites`;
CREATE TABLE `websites` (
  `websitenumber` int(11) NOT NULL auto_increment,
  `biblionumber` int(11) NOT NULL default '0',
  `title` text,
  `description` text,
  `url` varchar(255) default NULL,
  PRIMARY KEY  (`websitenumber`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `z3950queue`
--

DROP TABLE IF EXISTS `z3950queue`;
CREATE TABLE `z3950queue` (
  `id` int(11) NOT NULL auto_increment,
  `term` text,
  `type` varchar(10) default NULL,
  `startdate` int(11) default NULL,
  `enddate` int(11) default NULL,
  `done` smallint(6) default NULL,
  `results` longblob,
  `numrecords` int(11) default NULL,
  `servers` text,
  `identifier` varchar(30) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `z3950results`
--

DROP TABLE IF EXISTS `z3950results`;
CREATE TABLE `z3950results` (
  `id` int(11) NOT NULL auto_increment,
  `queryid` int(11) default NULL,
  `server` varchar(255) default NULL,
  `startdate` int(11) default NULL,
  `enddate` int(11) default NULL,
  `results` longblob,
  `numrecords` int(11) default NULL,
  `numdownloaded` int(11) default NULL,
  `highestseen` int(11) default NULL,
  `active` smallint(6) default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `query_server` (`queryid`,`server`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `z3950servers`
--

DROP TABLE IF EXISTS `z3950servers`;
CREATE TABLE `z3950servers` (
  `host` varchar(255) default NULL,
  `port` int(11) default NULL,
  `db` varchar(255) default NULL,
  `userid` varchar(255) default NULL,
  `password` varchar(255) default NULL,
  `name` text,
  `id` int(11) NOT NULL auto_increment,
  `checked` smallint(6) default NULL,
  `rank` int(11) default NULL,
  `syntax` varchar(80) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

