/*   Programik do gry w kropki; X2grx -- funkcje pozwalajace
 *     korzystac z X Windows i z biblioteki GRX w ten sam sposob.
 *
 *  Copyright (C) 2003,2004,2005,2006,2007 Bartek Dyda <kropki@yahoo.co.uk>.
 * 
 *  This file is part of Kropki.
 *
 *  Kropki is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  as published by the Free Software Foundation.
 *
 *  Kropki is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License, version 2, for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Kropki; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#include "X2grx.h"
#include <string.h>
#ifdef XWIN_BEZ_GRX
#include <stdio.h>
#include <stdlib.h>

Display *display; 
int screen;       
Window win;       
XEvent event;     
GC gc;            
XGCValues gs;     
Pixmap p, zapam;
int zapx, zapy, zapszer,zapwys;
Colormap c;
int szerokosc, wysokosc;
XFontStruct* czcionka;

TKolor WHITE, BLACK;

int GrSetMode(int tryb, int x, int y, int kolor)
{
  szerokosc=x;  wysokosc=y;
  if ((display = XOpenDisplay(NULL)) == NULL) {
    perror("Nie udalo sie polaczyc z serwerem X.");
    exit(1);
  }

  screen = DefaultScreen(display);

  // utworz okno
  win = XCreateSimpleWindow(display, RootWindow(display, screen),
          0, 0, x, y, 1, WhitePixel(display, screen),
          BlackPixel(display, screen));
  XMapWindow(display, win);

  c = DefaultColormap(display, DefaultScreen(display));
  WHITE= WhitePixel(display, DefaultScreen(display));
  BLACK= BlackPixel(display, DefaultScreen(display));

  /*
  XParseColor(display, c, "red", &red);
  XParseColor(display, c, "green", &green);
  XParseColor(display, c, "blue", &blue);
  XParseColor(display, c, "yellow", &yellow);
  XAllocColor(display, c, &red);
  XAllocColor(display, c, &blue);
  XAllocColor(display, c, &green);
  XAllocColor(display, c, &yellow);
 
  kolor1.red = 52*4*256;
 kolor1.green = 27*4*256;
 kolor1.blue = 19*4*256;        // ceglasty
  kolor2.red = 13*4*256;
 kolor2.green = 42*4*256;
 kolor2.blue = 50*4*256;      // blekitny
 XAllocColor(display, c, &kolor1);
  XAllocColor(display, c, &kolor2);
  */

  // Set up which event types the window will handle
  XSelectInput(display, win, KeyPressMask | ExposureMask | ButtonPressMask);
  gc = XCreateGC(display, win, 0, &gs); // 0 -> use defaults
  p = XCreatePixmap(display, win, x, y, DefaultDepth(display, DefaultScreen(display)));
  zapam = XCreatePixmap(display, win, x, y, DefaultDepth(display, DefaultScreen(display)));
  //c = DefaultColormap(display, DefaultScreen(display));
 
  czcionka=XLoadQueryFont(display,"*fixed*-normal--10-*iso8859-2");
  if (czcionka==NULL)
    czcionka=XLoadQueryFont(display,"*--10-*iso8859-2");
  if (czcionka==NULL)
    czcionka=XLoadQueryFont(display,"*12*iso8859-2");
  if (czcionka==NULL)
    czcionka=XLoadQueryFont(display,"*iso8859-2");
  if (czcionka==NULL)
    czcionka=XLoadQueryFont(display,"*fixed*-normal--10-*");
  if (czcionka==NULL)
    czcionka=XLoadQueryFont(display,"*");
  if (czcionka==NULL) {
    printf("Blad: nie ma zadnej czcionki do zaladowania.\n");
    abort();
  }
 
  XSetFont(display,gc,czcionka->fid);
   
  XFlush(display);

}

void GrClose()
{
  XCloseDisplay(display);
}

void GrLine(int x1, int y1, int x2, int y2, TKolor kolor)
{
    XSetForeground(display, gc, kolor);
  XDrawLine(display, p, gc, x1,y1,x2,y2);
  XDrawLine(display, win, gc, x1,y1,x2,y2);
}

void GrHLine(int x1, int x2, int y, TKolor kolor)
{ GrLine(x1,y,x2,y,kolor); }

void GrVLine(int x, int y1, int y2, TKolor kolor)
{ GrLine(x,y1,x,y2,kolor); }

void outtextxy(int x, int y, const char *tekst, TKolor kolor, 
	       TKolor kolortla, int align)
{
  XSetForeground(display, gc, kolor);
  XSetBackground(display, gc, kolortla);
  int szer = XTextWidth(czcionka, tekst, strlen(tekst));
  int wys=czcionka->max_bounds.ascent + czcionka->max_bounds.descent;
  switch (align & 0xf0)
    {
    case 0x00:  break;  // LEFT
    case 0x10:  x-=(szer/2-1);  break;    // CENTER
    case 0x20:  x-=szer;  break;    // RIGHT
    }
  y+= czcionka->max_bounds.ascent;
  switch (align & 0xf)
    {
    case 0x0:  break;  // TOP
    case 0x1:  y-=(wys-1)/2;  break;    // CENTER
    case 0x2:  y-=wys;  break;    // BOTTOM
    }
  XDrawString(display,p,gc,x,y,tekst,strlen(tekst));
  XDrawString(display,win,gc,x,y,tekst,strlen(tekst));
}

void GrFlush()  //int odtworz=0)
{
  //  if (odtworz)
  //  XCopyArea(display, p, win, gc, 0, 0, szerokosc, wysokosc, 0, 0);
  XFlush(display);
}

void GrRePaint()
{ 
  XCopyArea(display, p, win, gc, 0, 0, szerokosc, wysokosc, 0, 0); 
  XFlush(display);
}

void GrZapamietajObszar(int x, int y, int szer, int wys)
{
  zapx=x;   zapy=y;   zapszer=szer;   zapwys=wys;
  XCopyArea(display, p, zapam, gc, x, y, szer, wys, 0, 0);
}

void GrOdtworzObszar()
{
  XCopyArea(display, zapam, p, gc, 0, 0, zapszer, zapwys, zapx, zapy);
  XCopyArea(display, zapam, win, gc, 0, 0, zapszer, zapwys, zapx, zapy);
}


void GrBox(int x1, int y1, int x2, int y2, TKolor kolor)
{
 XSetForeground(display, gc, kolor);
 XDrawRectangle(display,p,gc,x1,y1,x2-x1,y2-y1);
 XDrawRectangle(display,win,gc,x1,y1,x2-x1,y2-y1);
}

void GrFilledBox(int x1, int y1, int x2, int y2, TKolor kolor)
{
 XSetForeground(display, gc, kolor);
 XFillRectangle(display,p,gc,x1,y1,x2-x1,y2-y1);
 XFillRectangle(display,win,gc,x1,y1,x2-x1,y2-y1);
}

void GrFilledTrojkat(int x1, int y1, int x2, int y2, int x3, int y3, TKolor kolor)
// tej funkcji nie ma w grx
{
  XSetForeground(display, gc, kolor);
  XPoint wsp[3];
  wsp[0].x=x1;  wsp[0].y=y1;
  wsp[1].x=x2;  wsp[1].y=y2;
  wsp[2].x=x3;  wsp[2].y=y3;
  XFillPolygon(display,p,gc, wsp, 3, Convex, CoordModeOrigin);
  XFillPolygon(display,win,gc, wsp, 3, Convex, CoordModeOrigin);
}

void GrPlot(int x, int y, TKolor kolor)
{
  XSetForeground(display, gc, kolor);
  XDrawPoint(display,p,gc,x,y);
  XDrawPoint(display,win,gc,x,y);
}

void GrClearScreen(TKolor kolor)
{
  GrFilledBox(0,0,szerokosc-1,wysokosc-1,kolor);
}

int GrMaxX() { return szerokosc-1; }
int GrMaxY() { return wysokosc-1; }
int GrSizeX() { return szerokosc; }
int GrSizeY() { return wysokosc; }

int GrKeyRead()
{
  XEvent e;
  KeySym ks;
  e.type = 0;
  while(e.type != KeyPress) {// && e.type!=ButtonPress) {
  if(e.type == Expose)
    XCopyArea(display, p, win, gc, 0, 0, szerokosc, wysokosc, 0, 0);
  XNextEvent(display, &e);
  }
  return ks = XKeycodeToKeysym(display, e.xkey.keycode, 0);
}

TKolor GrAllocColor(int r, int g, int b)
{
 XColor kolor;
 kolor.red   = r << 8;
 kolor.green = g << 8;
 kolor.blue  = b << 8;
 XAllocColor(display, c, &kolor);
 return kolor.pixel;
}

void GrXor()
{
  XGCValues nowe;
  nowe.function = GXxor;
  XChangeGC(display, gc, GCFunction, &nowe);
}

void GrCopy()
{
  XGCValues nowe;
  nowe.function = GXcopy;
  XChangeGC(display, gc, GCFunction, &nowe);
}

void GrSetWindowTitle(char* tytul)
{
 XmbSetWMProperties(display, win, tytul, "", 0, 1, 0, 0, 0);
}

int TKlawisz::operator==(const TKlawisz k)
{ return k.key==key && k.state==state; }

int TKlawisz::operator!=(const TKlawisz k)
{ return k.key!=key || k.state!=state; }

int TKlawisz::operator>=(const TKlawisz k)
{ return Konwersja(*this)>=Konwersja(k); }

int TKlawisz::operator<=(const TKlawisz k)
{ return Konwersja(*this)<=Konwersja(k); }

int TKlawisz::operator>(const TKlawisz k)
{ return Konwersja(*this)>Konwersja(k); }

int TKlawisz::operator<(const TKlawisz k)
{ return Konwersja(*this)<Konwersja(k); }


TKlawisz& TKlawisz::operator=(int arg)
{ key=(arg & 0xffff);  state=(arg >> 16); }

TKlawisz::TKlawisz(int arg)
{ *this = arg; }

int Konwersja(TKlawisz k)
{ return (k.state << 16) | k.key; } 

void GrMouseGetEvent(int flags,GrMouseEvent* gme)
{
  XEvent e;
  e.type = 0;
  gme->flags=0;
  for (;;)
  {
  XNextEvent(display, &e);
  if (e.type == Expose)
    XCopyArea(display, p, win, gc, 0, 0, szerokosc, wysokosc, 0, 0);
  else if (e.type==ButtonPress)
    {
      gme->kbstat=e.xbutton.state;
      gme->flags=(1<<e.xbutton.button);
      gme->x=e.xbutton.x;
      gme->y=e.xbutton.y;
    }
  else if (e.type==KeyPress)
    {
      gme->kbstat=e.xkey.state;
      gme->flags=GR_M_KEYPRESS;
      {
	char buffer[10];
	int bufsize=sizeof(buffer)/sizeof(buffer[0]);
	KeySym keysym;
	XComposeStatus compose;
	int count = XLookupString(&e.xkey, buffer, bufsize,
				  &keysym, &compose);
	if (((keysym >= XK_KP_Space)
	     && (keysym <= XK_KP_9))
	    || ((keysym >= XK_space)
		&& (keysym <= XK_asciitilde))) {
	  gme->key = buffer[0];
	}
	else gme->key = keysym;
      }
    }
  if (gme->flags & flags) return;
  }
}

void GrMouseGetEventT(int flags,GrMouseEvent* gme, int)
  // trzeci argument to czas -- nieuzywany
{
  XEvent e;
  e.type = 0;
  gme->flags=0;
  for (;;)
  {
  if (!XCheckMaskEvent(display, 0xffffffff, &e))
    {
      gme->kbstat=0;  // jak wziac prawdziwy stan?
      gme->flags=0;
      gme->key=0;
      return;
    }  
  if (e.type == Expose)
    XCopyArea(display, p, win, gc, 0, 0, szerokosc, wysokosc, 0, 0);
  else if (e.type==ButtonPress)
    {
      gme->kbstat=e.xbutton.state;
      gme->flags=(1<<e.xbutton.button);
      gme->x=e.xbutton.x;
      gme->y=e.xbutton.y;
    }
  else if (e.type==KeyPress)
    {
      gme->kbstat=e.xkey.state;
      gme->flags=GR_M_KEYPRESS;

      {
	char buffer[10];
	int bufsize=sizeof(buffer)/sizeof(buffer[0]);
	KeySym keysym;
	XComposeStatus compose;
	int count = XLookupString(&e.xkey, buffer, bufsize,
				  &keysym, &compose);
	if (((keysym >= XK_KP_Space)
	     && (keysym <= XK_KP_9))
	    || ((keysym >= XK_space)
		&& (keysym <= XK_asciitilde))) {
	  gme->key = buffer[0];
	}
	else gme->key = keysym;
      }

    }
  if (gme->flags & flags) return;
  }
}


#else

GrFont *akt_font = &mojfont;
GrColor *zapam;
int zapx, zapy, zapszer,zapwys;

void outtextxy(int x, int y, const char *tekst, int kolor, int kolortla, int align)
{
 GrTextOption  g;
 g.txo_font = akt_font;  //&mojfont;   //GrFont_PC8x8;
 g.txo_fgcolor.v = kolor;
 g.txo_bgcolor.v = kolortla;
 g.txo_chrtype = GR_BYTE_TEXT;
 g.txo_direct  = GR_TEXT_RIGHT;
 g.txo_xalign  = (align >> 4);
 g.txo_yalign  = (align & 0xf);
 char *nap = new char[strlen(tekst)+1];
 strcpy(nap,tekst);
 GrDrawString(nap, strlen(tekst), x,y, &g);
 delete[] nap;
}

void GrZapamietajObszar(int x, int y, int szer, int wys)
{
  zapx=x; zapy=y; zapszer=szer; zapwys=wys;
  zapam = new GrColor[wys*szer];
  GrColor *akt_zapam = zapam;
  for (int j=0; j<wys; j++) {
    memcpy(akt_zapam, GrGetScanline(x,x+szer-1,y+j), sizeof(GrColor)*szer);
    akt_zapam += szer;
  }
}

void GrOdtworzObszar()
{
  GrColor *akt_zapam = zapam;
  for (int j=0; j<zapwys; j++) {
    GrPutScanline(zapx,zapx+zapszer-1,zapy+j, akt_zapam, GrWRITE);
    akt_zapam += zapszer;
  }
  delete[] zapam;
}

void GrFilledTrojkat(int x1, int y1, int x2, int y2, int x3, int y3, TKolor kolor)
{
  int wsp[4][2];
  wsp[0][0]=x1;  wsp[0][1]=y1;
  wsp[1][0]=x2;  wsp[1][1]=y2;
  wsp[2][0]=x3;  wsp[2][1]=y3;
  wsp[3][0]=x1;  wsp[3][1]=y1;
  GrFilledPolygon(4, wsp, kolor);
}

void GrClose()
{
  GrMouseEraseCursor();
  GrMouseUnInit();
}

#endif

