/*  Programik do gry w kropki. 
 *  slownik: plik ulatwiajacy tworzenie roznych wersji jezykowych Kropek,
 *   uzywany takze do obslugi pliku konfiguracyjnego.
 *
 *  Copyright (C) 2005 Bartek Dyda <kropki@yahoo.co.uk>.
 * 
 *  This file is part of Kropki.
 *
 *  Kropki is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  as published by the Free Software Foundation.
 *
 *  Kropki is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License, version 2, for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Kropki; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "slownik.h"

TSlowa::TSlowa()
{
  bufor=NULL;
  strcpy(nieznane_slowo,"???");
}

TSlowa::~TSlowa()
{
  if (bufor) delete[] bufor;
}

void TSlowa::SieveDown(int l, int p)
{
  int j=2*l+1;
  TSlowaRekord x=slowa[l];
  while (j<=p) {
    if (j<p)
      if (strcmp(slowa[j].klucz, slowa[j+1].klucz)<0) j++;
    if (strcmp(x.klucz, slowa[j].klucz)<0) {
      slowa[l]=slowa[j];
      l=j;  j=2*l+1;
    }
    else break;
  }
  slowa[l]=x;
}

int TSlowa::Wczytaj(const char *nazwa_pliku)
// zwraca 0, gdy blad
{
  if (bufor) { delete[] bufor; bufor=NULL; }
  FILE *f=fopen(nazwa_pliku, "rb");
  if (f==NULL) return 0;
  int ignoruj=0;   // komentarz
  int juz_slowo=0; // czy wczytujemy slowo (1), czy klucz (0)
  int teraz_poczatek=1;  // czy zapamietac ogon_buf
  ile_slow=0;
  {
    fseek(f,0,SEEK_END);
    long int dlug=ftell(f);
    fseek(f,0,SEEK_SET);
    if (dlug>1000000) dlug=1000000;
    bufor = new char[dlug+1];
  }
  char *ogon_buf = slowa[0].klucz = bufor;
  while (!feof(f)) {
    if (ogon_buf-bufor>=1000000-1)
      break;   // przepelnienie bufora!
    char z;
    fread(&z,1,1,f);
    if (z=='#') ignoruj=1;  // komentarz
    else if (z=='\n' || z=='\r') {
      ignoruj=0;  teraz_poczatek=1;
      if (juz_slowo) {
	juz_slowo=0;
	*ogon_buf++=0;
	ile_slow++;
	if (ile_slow==sizeof(slowa)/sizeof(slowa[0])) 
	  return -1;  // przepelnienie
	slowa[ile_slow].klucz=ogon_buf;
      }
      else  // byl jakis (niepoprawny) lancuch bez ,,='' ani ,,#''
	ogon_buf = slowa[ile_slow].klucz;     // anuluj go
    }
    else if (!ignoruj) { // normalny znak
      if (z!='=' || juz_slowo) {
	if (teraz_poczatek) {
	  teraz_poczatek=0;
	  if (!juz_slowo) slowa[ile_slow].klucz=ogon_buf;
	}
	if (z=='\\') { // czy inny znak ?
	  char buf[3];
	  fread(buf,1,1,f);
	  if (buf[0]!='\\') {  // inny znak!
	    fread(&buf[1],1,2,f);  // wczytaj kolejne 2 cyfry osemkowe znaku
	    int kod = int(buf[0]-'0')*64 + int(buf[1]-'0')*8 + buf[2]-'0';
	    if (kod>=0 && kod<0x100)
	      *ogon_buf++ = kod;
	  }
	  else *ogon_buf++ = z; // po prostu backslash
	}
	else 
	  *ogon_buf++ = z; // zwykly znak
      }
      else {
	juz_slowo=1;  teraz_poczatek=0;
	*ogon_buf++=0;
	slowa[ile_slow].slowo=ogon_buf;
      }
    }
  }
  fclose(f);
  if (juz_slowo) {
    *ogon_buf++=0;
    ile_slow++;
  }
  // posortuj
  for (int i=ile_slow/2-1; i>=0; i--)
    SieveDown(i,ile_slow-1);
  for (int i=ile_slow-1; i>0; i--) {
    TSlowaRekord pom=slowa[i];
    slowa[i]=slowa[0];
    slowa[0]=pom;
    SieveDown(0,i-1);
  }
  return 1;
}

const char *TSlowa::operator[](const char *klucz) const
{
  int l=0, p=ile_slow;  // szukane slowo jest w przedziale [l,p)
  while (l<p) {
    int s=(l+p)/2;
    int wynik = strcmp(klucz, slowa[s].klucz);
    wynik = (wynik>0) - (wynik<0);
    switch (wynik) {
    case -1: p=s; break;
    case 0: return slowa[s].slowo;
    case 1: l=s+1; break;
    }
  }
  // nie ma slowa!
  FILE *f=fopen("krblad.txt","a+t");
  if (f!=NULL) {
    fprintf(f,"Nieznane slowo: \"%s\".",klucz);
    fclose(f);
  }
  return nieznane_slowo;
}


