/*   Programik do gry w kropki; X2grx -- funkcje pozwalajace
 *     korzystac z X Windows i z biblioteki GRX w ten sam sposob.
 *
 *  Copyright (C) 2003,2004,2005,2006,2007,2009 Bartek Dyda <kropki@yahoo.co.uk>.
 * 
 *  This file is part of Kropki.
 *
 *  Kropki is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License, version 2,
 *  as published by the Free Software Foundation.
 *
 *  Kropki is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License, version 2, for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Kropki; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#include "X2grx.h"
#include <string.h>

int codepage=2;
int X2GrxSetCodepage(int page)
{
  codepage = page;
}

#ifdef XWIN_BEZ_GRX
#include <stdio.h>
#include <stdlib.h>

Display *display; 
int screen;       
Window win;       
XEvent event;     
GC gc;            
XGCValues gs;     
Pixmap p, zapam;
int zapx, zapy, zapszer,zapwys;
Colormap c;
int szerokosc, wysokosc;
XFontStruct* czcionka;
//TKolor WHITE, BLACK;

int GrSetMode(int tryb, int x, int y, int kolor)
{
  szerokosc=x;  wysokosc=y;
  if ((display = XOpenDisplay(NULL)) == NULL) {
    perror("Nie udalo sie polaczyc z serwerem X.");
    exit(1);
  }

  screen = DefaultScreen(display);

  // utworz okno
  win = XCreateSimpleWindow(display, RootWindow(display, screen),
          0, 0, x, y, 1, WhitePixel(display, screen),
          BlackPixel(display, screen));
  XMapWindow(display, win);

  c = DefaultColormap(display, DefaultScreen(display));
  //  WHITE= WhitePixel(display, DefaultScreen(display));
  //  BLACK= BlackPixel(display, DefaultScreen(display));

  /*
  XParseColor(display, c, "red", &red);
  XParseColor(display, c, "green", &green);
  XParseColor(display, c, "blue", &blue);
  XParseColor(display, c, "yellow", &yellow);
  XAllocColor(display, c, &red);
  XAllocColor(display, c, &blue);
  XAllocColor(display, c, &green);
  XAllocColor(display, c, &yellow);
 
  kolor1.red = 52*4*256;
 kolor1.green = 27*4*256;
 kolor1.blue = 19*4*256;        // ceglasty
  kolor2.red = 13*4*256;
 kolor2.green = 42*4*256;
 kolor2.blue = 50*4*256;      // blekitny
 XAllocColor(display, c, &kolor1);
  XAllocColor(display, c, &kolor2);
  */

  // Set up which event types the window will handle
  XSelectInput(display, win, KeyPressMask | ExposureMask | ButtonPressMask);
  gc = XCreateGC(display, win, 0, &gs); // 0 -> use defaults
  p = XCreatePixmap(display, win, x, y, DefaultDepth(display, DefaultScreen(display)));
  zapam = XCreatePixmap(display, win, x, y, DefaultDepth(display, DefaultScreen(display)));
  //c = DefaultColormap(display, DefaultScreen(display));
  char font_str[50];
  sprintf(font_str, "*fixed*-normal--10-*iso8859-%d", codepage);
  czcionka=XLoadQueryFont(display, font_str);
  if (czcionka==NULL) {
    sprintf(font_str, "*--10-*iso8859-%d", codepage);
    czcionka=XLoadQueryFont(display, font_str);
  }
  if (czcionka==NULL) {
    sprintf(font_str, "*12*iso8859-%d", codepage);
    czcionka=XLoadQueryFont(display, font_str);
  }
  if (czcionka==NULL) {
    sprintf(font_str, "*iso8859-%d", codepage);
    czcionka=XLoadQueryFont(display, font_str);
  }
  if (czcionka==NULL)
    czcionka=XLoadQueryFont(display,"*fixed*-normal--10-*");
  if (czcionka==NULL)
    czcionka=XLoadQueryFont(display,"*");
  if (czcionka==NULL) {
    printf("Blad: nie ma zadnej czcionki do zaladowania.\n");
    abort();
  }
 
  XSetFont(display,gc,czcionka->fid);
   
  XFlush(display);

}

void GrClose()
{
  XCloseDisplay(display);
}

void GrLine(int x1, int y1, int x2, int y2, TKolor kolor)
{
    XSetForeground(display, gc, kolor);
  XDrawLine(display, p, gc, x1,y1,x2,y2);
  XDrawLine(display, win, gc, x1,y1,x2,y2);
}

void GrHLine(int x1, int x2, int y, TKolor kolor)
{ GrLine(x1,y,x2,y,kolor); }

void GrVLine(int x, int y1, int y2, TKolor kolor)
{ GrLine(x,y1,x,y2,kolor); }

void outtextxy(int x, int y, const char *tekst, TKolor kolor, 
	       TKolor kolortla, int align)
{
  XSetForeground(display, gc, kolor);
  XSetBackground(display, gc, kolortla);
  int szer = XTextWidth(czcionka, tekst, strlen(tekst));
  int wys=czcionka->max_bounds.ascent + czcionka->max_bounds.descent;
  switch (align & 0xf0)
    {
    case 0x00:  break;  // LEFT
    case 0x10:  x-=(szer/2-1);  break;    // CENTER
    case 0x20:  x-=szer;  break;    // RIGHT
    }
  y+= czcionka->max_bounds.ascent;
  switch (align & 0xf)
    {
    case 0x0:  break;  // TOP
    case 0x1:  y-=(wys-1)/2;  break;    // CENTER
    case 0x2:  y-=wys;  break;    // BOTTOM
    }
  XDrawString(display,p,gc,x,y,tekst,strlen(tekst));
  XDrawString(display,win,gc,x,y,tekst,strlen(tekst));
}

void GrFlush()  //int odtworz=0)
{
  //  if (odtworz)
  //  XCopyArea(display, p, win, gc, 0, 0, szerokosc, wysokosc, 0, 0);
  XFlush(display);
}

void GrRePaint()
{ 
  XCopyArea(display, p, win, gc, 0, 0, szerokosc, wysokosc, 0, 0); 
  XFlush(display);
}

void GrZapamietajObszar(int x, int y, int szer, int wys)
{
  zapx=x;   zapy=y;   zapszer=szer;   zapwys=wys;
  XCopyArea(display, p, zapam, gc, x, y, szer, wys, 0, 0);
}

void GrOdtworzObszar()
{
  XCopyArea(display, zapam, p, gc, 0, 0, zapszer, zapwys, zapx, zapy);
  XCopyArea(display, zapam, win, gc, 0, 0, zapszer, zapwys, zapx, zapy);
}


void GrBox(int x1, int y1, int x2, int y2, TKolor kolor)
{
 XSetForeground(display, gc, kolor);
 XDrawRectangle(display,p,gc,x1,y1,x2-x1,y2-y1);
 XDrawRectangle(display,win,gc,x1,y1,x2-x1,y2-y1);
}

void GrFilledBox(int x1, int y1, int x2, int y2, TKolor kolor)
{
 XSetForeground(display, gc, kolor);
 XFillRectangle(display,p,gc,x1,y1,x2-x1,y2-y1);
 XFillRectangle(display,win,gc,x1,y1,x2-x1,y2-y1);
}

void GrFilledTrojkat(int x1, int y1, int x2, int y2, int x3, int y3, TKolor kolor)
// tej funkcji nie ma w grx
{
  XSetForeground(display, gc, kolor);
  XPoint wsp[3];
  wsp[0].x=x1;  wsp[0].y=y1;
  wsp[1].x=x2;  wsp[1].y=y2;
  wsp[2].x=x3;  wsp[2].y=y3;
  XFillPolygon(display,p,gc, wsp, 3, Convex, CoordModeOrigin);
  XFillPolygon(display,win,gc, wsp, 3, Convex, CoordModeOrigin);
}

void GrPlot(int x, int y, TKolor kolor)
{
  XSetForeground(display, gc, kolor);
  XDrawPoint(display,p,gc,x,y);
  XDrawPoint(display,win,gc,x,y);
}

void GrClearScreen(TKolor kolor)
{
  GrFilledBox(0,0,szerokosc-1,wysokosc-1,kolor);
}

int GrMaxX() { return szerokosc-1; }
int GrMaxY() { return wysokosc-1; }
int GrSizeX() { return szerokosc; }
int GrSizeY() { return wysokosc; }

int GrKeyRead()
{
  XEvent e;
  KeySym ks;
  e.type = 0;
  while(e.type != KeyPress) {// && e.type!=ButtonPress) {
  if(e.type == Expose)
    XCopyArea(display, p, win, gc, 0, 0, szerokosc, wysokosc, 0, 0);
  XNextEvent(display, &e);
  }
  return ks = XKeycodeToKeysym(display, e.xkey.keycode, 0);
}

TKolor GrAllocColor(int r, int g, int b)
{
 XColor kolor;
 kolor.red   = r << 8;
 kolor.green = g << 8;
 kolor.blue  = b << 8;
 XAllocColor(display, c, &kolor);
 return kolor.pixel;
}

void GrXor()
{
  XGCValues nowe;
  nowe.function = GXxor;
  XChangeGC(display, gc, GCFunction, &nowe);
}

void GrCopy()
{
  XGCValues nowe;
  nowe.function = GXcopy;
  XChangeGC(display, gc, GCFunction, &nowe);
}

void GrSetWindowTitle(char* tytul)
{
 XmbSetWMProperties(display, win, tytul, "", 0, 1, 0, 0, 0);
}

int TKlawisz::operator==(const TKlawisz k)
{ return k.key==key && k.state==state; }

int TKlawisz::operator!=(const TKlawisz k)
{ return k.key!=key || k.state!=state; }

int TKlawisz::operator>=(const TKlawisz k)
{ return Konwersja(*this)>=Konwersja(k); }

int TKlawisz::operator<=(const TKlawisz k)
{ return Konwersja(*this)<=Konwersja(k); }

int TKlawisz::operator>(const TKlawisz k)
{ return Konwersja(*this)>Konwersja(k); }

int TKlawisz::operator<(const TKlawisz k)
{ return Konwersja(*this)<Konwersja(k); }


TKlawisz& TKlawisz::operator=(int arg)
{ key=(arg & 0xffff);  state=(arg >> 16); }

TKlawisz::TKlawisz(int arg)
{ *this = arg; }

int Konwersja(TKlawisz k)
{ return (k.state << 16) | k.key; } 

void GrMouseGetEvent(int flags,GrMouseEvent* gme)
{
  XEvent e;
  e.type = 0;
  gme->flags=0;
  for (;;)
  {
  XNextEvent(display, &e);
  if (e.type == Expose)
    XCopyArea(display, p, win, gc, 0, 0, szerokosc, wysokosc, 0, 0);
  else if (e.type==ButtonPress)
    {
      gme->kbstat=e.xbutton.state;
      gme->flags=(1<<e.xbutton.button);
      gme->x=e.xbutton.x;
      gme->y=e.xbutton.y;
    }
  else if (e.type==KeyPress)
    {
      gme->kbstat=e.xkey.state;
      gme->flags=GR_M_KEYPRESS;
      {
	char buffer[10];
	int bufsize=sizeof(buffer)/sizeof(buffer[0]);
	KeySym keysym;
	XComposeStatus compose;
	int count = XLookupString(&e.xkey, buffer, bufsize,
				  &keysym, &compose);
	if (((keysym >= XK_KP_Space)
	     && (keysym <= XK_KP_9))
	    || ((keysym >= XK_space)
		&& (keysym <= XK_asciitilde))) {
	  gme->key = buffer[0];
	}
	else gme->key = keysym;
      }
    }
  if (gme->flags & flags) return;
  }
}

void GrMouseGetEventT(int flags,GrMouseEvent* gme, int)
  // trzeci argument to czas -- nieuzywany
{
  XEvent e;
  e.type = 0;
  gme->flags=0;
  for (;;)
  {
  if (!XCheckMaskEvent(display, 0xffffffff, &e))
    {
      gme->kbstat=0;  // jak wziac prawdziwy stan?
      gme->flags=0;
      gme->key=0;
      return;
    }  
  if (e.type == Expose)
    XCopyArea(display, p, win, gc, 0, 0, szerokosc, wysokosc, 0, 0);
  else if (e.type==ButtonPress)
    {
      gme->kbstat=e.xbutton.state;
      gme->flags=(1<<e.xbutton.button);
      gme->x=e.xbutton.x;
      gme->y=e.xbutton.y;
    }
  else if (e.type==KeyPress)
    {
      gme->kbstat=e.xkey.state;
      gme->flags=GR_M_KEYPRESS;

      {
	char buffer[10];
	int bufsize=sizeof(buffer)/sizeof(buffer[0]);
	KeySym keysym;
	XComposeStatus compose;
	int count = XLookupString(&e.xkey, buffer, bufsize,
				  &keysym, &compose);
	if (((keysym >= XK_KP_Space)
	     && (keysym <= XK_KP_9))
	    || ((keysym >= XK_space)
		&& (keysym <= XK_asciitilde))) {
	  gme->key = buffer[0];
	}
	else gme->key = keysym;
      }

    }
  if (gme->flags & flags) return;
  }
}


#else

GrFont *akt_font = &mojfont;
GrFont *akt_font_russian = &mojfont_rus;
GrColor *zapam;
int zapx, zapy, zapszer,zapwys;

/*
char iso88595_to_koi8r[256] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 
16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 
32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 
48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 
64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 
80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 
96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 
112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 
32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 
32, 179, 32, 32, 32, 32, 'I', 32, 32, 32, 32, 32, 32, 32, 32, 32, 
225, 226, 247, 231, 228, 229, 246, 250, 233, 234, 235, 236, 237, 238, 239, 240, 
242, 243, 244, 245, 230, 232, 227, 254, 251, 253, 255, 249, 248, 252, 224, 241, 
193, 194, 215, 199, 196, 197, 214, 218, 201, 202, 203, 204, 205, 206, 207, 208, 
210, 211, 212, 213, 198, 200, 195, 222, 219, 221, 223, 217, 216, 220, 192, 209, 
32, 163, 32, 32, 32, 32, 'i', 32, 32, 32, 32, 32, 32, 32, 32, 32};
*/

short int iso88595_to_utf16[256] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 
16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 
32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 
48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 
64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 
80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 
96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 
112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
 /*65279,*/ 128, 129, 130, 131, 132, 133, 134, 
135, 136, 137, 138, 139, 140, 141, 142, 
143, 144, 145, 146, 147, 148, 149, 150, 
151, 152, 153, 154, 155, 156, 157, 158, 
159, 160, 1025, 1026, 1027, 1028, 1029, 1030, // (Ukrainian I),
1031, 1032, 1033, 1034, 1035, 1036, 173, 1038, 
1039, 1040, 1041, 1042, 1043, 1044, 1045, 1046, 
1047, 1048, 1049, 1050, 1051, 1052, 1053, 1054, 
1055, 1056, 1057, 1058, 1059, 1060, 1061, 1062, 
1063, 1064, 1065, 1066, 1067, 1068, 1069, 1070, 
1071, 1072, 1073, 1074, 1075, 1076, 1077, 1078, 
1079, 1080, 1081, 1082, 1083, 1084, 1085, 1086, 
1087, 1088, 1089, 1090, 1091, 1092, 1093, 1094, 
1095, 1096, 1097, 1098, 1099, 1100, 1101, 1102, 
1103, 8470, 1105, 1106, 1107, 1108, 1109, 1110, // (Ukrainian i),
1111, 1112, 1113, 1114, 1115, 1116, 167, 1118};


void outtextxy(int x, int y, const char *tekst, int kolor, int kolortla, int align)
{
 GrTextOption  g;
 g.txo_font = akt_font;  //&mojfont;   //GrFont_PC8x8;
 g.txo_fgcolor.v = kolor;
 g.txo_bgcolor.v = kolortla;
 g.txo_chrtype = GR_BYTE_TEXT;
 g.txo_direct  = GR_TEXT_RIGHT;
 g.txo_xalign  = (align >> 4);
 g.txo_yalign  = (align & 0xf);
 if (codepage==5) {
   g.txo_font = akt_font_russian;   //  univ07.fnt
   short int *nap = new short int[strlen(tekst)+1];
   for (int i=0; i<strlen(tekst); i++)
     nap[i] = iso88595_to_utf16[(unsigned char) tekst[i]];
   g.txo_chrtype = GR_WORD_TEXT;
   GrDrawString(nap, strlen(tekst), x,y, &g);
   delete[] nap;
 }
 else { 
   char *nap = new char[strlen(tekst)+1];
   strcpy(nap,tekst);
   /*
   if (codepage==5) {
     for (int i=0; i<strlen(tekst); i++)
       nap[i] = iso88595_to_koi8r[(unsigned char) tekst[i]];
       } */
   GrDrawString(nap, strlen(tekst), x,y, &g);
   delete[] nap;
 }
}

void GrZapamietajObszar(int x, int y, int szer, int wys)
{
  zapx=x; zapy=y; zapszer=szer; zapwys=wys;
  zapam = new GrColor[wys*szer];
  GrColor *akt_zapam = zapam;
  for (int j=0; j<wys; j++) {
    memcpy(akt_zapam, GrGetScanline(x,x+szer-1,y+j), sizeof(GrColor)*szer);
    akt_zapam += szer;
  }
}

void GrOdtworzObszar()
{
  GrColor *akt_zapam = zapam;
  for (int j=0; j<zapwys; j++) {
    GrPutScanline(zapx,zapx+zapszer-1,zapy+j, akt_zapam, GrWRITE);
    akt_zapam += zapszer;
  }
  delete[] zapam;
}

void GrFilledTrojkat(int x1, int y1, int x2, int y2, int x3, int y3, TKolor kolor)
{
  int wsp[4][2];
  wsp[0][0]=x1;  wsp[0][1]=y1;
  wsp[1][0]=x2;  wsp[1][1]=y2;
  wsp[2][0]=x3;  wsp[2][1]=y3;
  wsp[3][0]=x1;  wsp[3][1]=y1;
  GrFilledPolygon(4, wsp, kolor);
}

void GrClose()
{
  GrMouseEraseCursor();
  GrMouseUnInit();
}

char p16d[] = {
    0,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,
    1,2,1,0,0,0,0,0,0,0,0,1,2,2,1,0,
    1,2,2,1,0,0,0,0,0,0,1,2,0,0,2,1,
    1,2,2,2,1,0,0,0,0,0,1,2,0,0,2,1,
    1,2,2,2,2,1,0,0,0,0,0,1,2,2,1,0,
    1,2,2,2,2,2,1,0,0,0,0,0,1,1,0,0,
    1,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0,
    1,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,
    1,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,
    1,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,
    1,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,
    1,2,2,2,2,1,1,1,1,1,1,0,0,0,0,0,
    1,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,
    1,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,
    1,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};
GrCursor *cur;

void GrZrobKursor()
{
  GrColor bgc = GrAllocColor(0,0,128);
  GrColor fgc = GrAllocColor(255,255,0);
  GrColor msc[3];
 
  msc[0] = 2;
  msc[1] = GrWhite();
  msc[2] = GrAllocColor(255,0,0);
  cur = GrBuildCursor(p16d,16,16,16,1,1,msc);

  GrMouseSetCursor(cur);
}

#endif

