#include <string.h>
#include "basic.h"
#include "robaki.h"
#include "pla_skl.h"
#include "sstop3.h"

int gracz_umiejetnosci;

void TMostki12::Inicjuj()
{
 if (mwlky!=wlky)
   {
   mwlky=wlky;
   for (int i=0; i<12; i++)
     dind[i] = dx[i]*(W_P) + dy[i];
   // mostek 0 -- lewy gorny gorny
   puste1[0]= -wlky-4 -1;   puste2[0]= -1;
   nie_nasza1a[0]=-wlky-4;  nie_nasza2a[0]=-2*wlky-8-1;
   nie_nasza1b[0]=-2;       nie_nasza2b[0]=  wlky+4 -1;
   // mostek 1 -- prawy gorny gorny
   puste1[1]= wlky+4 -1;    puste2[1]= -1;
   nie_nasza1a[1]= W_P;  nie_nasza2a[1]= 2*wlky+8-1;
   nie_nasza1b[1]=-2;       nie_nasza2b[1]= -wlky-4 -1;
   // mostek 2 -- prawy prawy gorny
   puste1[2]= wlky+4 -1;    puste2[2]= W_P;
   nie_nasza1a[2]=2*wlky+8; nie_nasza2a[2]=  wlky+4+1;
   nie_nasza1b[2]=-1;       nie_nasza2b[2]=  wlky+4 -2;
   // mostek 3 -- prawy prawy dolny
   puste1[3]= wlky+4 +1;    puste2[3]= W_P;
   nie_nasza1a[3]=2*wlky+8; nie_nasza2a[3]=  wlky+4-1;
   nie_nasza1b[3]= 1;       nie_nasza2b[3]=  wlky+4 +2;
   // mostek 4 -- prawy dolny dolny
   puste1[4]= 1;            puste2[4]= wlky+4 +1;
   nie_nasza1a[4]= W_P;  nie_nasza2a[4]= 2*wlky+8+1;
   nie_nasza1b[4]= 2;       nie_nasza2b[4]= -wlky-4 +1;
   // mostek 5 -- lewy dolny dolny
   puste1[5]= 1;            puste2[5]= -wlky-4 +1;
   nie_nasza1a[5]= -wlky-4; nie_nasza2a[5]=-2*wlky-8+1;
   nie_nasza1b[5]= 2;       nie_nasza2b[5]=  wlky+4 +1;
   // mostek 6 -- lewy lewy dolny
   puste1[6]= -wlky-4;      puste2[6]= -wlky-4 +1;
   nie_nasza1a[6]=-2*wlky-8;nie_nasza2a[6]= -wlky-4-1;
   nie_nasza1b[6]= 1;       nie_nasza2b[6]= -wlky-4 +2;
   // mostek 7 -- lewy lewy dolny
   puste1[7]= -wlky-4;      puste2[7]= -wlky-4 -1;
   nie_nasza1a[7]=-2*wlky-8;nie_nasza2a[7]= -wlky-4+1;
   nie_nasza1b[7]= -1;      nie_nasza2b[7]= -wlky-4 -2;
   // mostki 8-11 sa uzywane przez TRobaki::OcenRuch() (!)
   for (int i=0; i<8; i++)
     puste3[i]=dind[i];  // sztuczka: puste3 niewazne dla mostkow 0-7
   // mostek 8 -- gorny gorny
   puste1[8]=-wlky-5;    puste2[8]=-1;    puste1[8]=wlky+3;
   // mostek 9 -- prawy prawy
   puste1[9]=wlky+3;     puste2[9]=W_P;    puste1[9]=wlky+5;
   // mostek 10 -- dolny dolny
   puste1[10]=-wlky-3;    puste2[10]=1;    puste1[10]=wlky+5;
   // mostek 11 -- lewy lewy
   puste1[11]=-wlky-5;    puste2[11]=-wlky-4;    puste1[11]=-wlky-3;
   }
}

void ZnajdzMostki12(krint *mostki, unsigned char *rozgr2, unsigned char *rozgr3,
         TDwaUC marg_min, TDwaUC marg_max, int ktory_gracz)
// Znajduje mostki w podanym obszarze i zaznacza je w tablicy mostki
// w bitach 0-11 jak na rysunku. NIE ZMIENIA tablicy mostki poza tym obszarem!
//                0 8 1               +----->
//              7       2             |    os x
//              b   .   9             |
//              6       3             | os y
//                5 a 4               v
//   (w srodku nasza kropka, z ktorej ,,wyskakujemy'' mostkiem 0-9,a,b).
//
// we: mostki         -- _wyzerowana_ lub juz odpowiednio ustawiona tablica
//     rozgr2, rozgr3 -- jak zwykle
//     marg_min, _max -- obszar, w ktorym nalezy znalezc mostki,
//     ktory_gracz    -- czyich mostkow szukamy.
// Funkcja jest ,,lokalna'' w tym sensie, ze wartosc mostki[x][y]
// zalezy _tylko_ od pozycji w kwadracie [x-2,x+2] x [y-2,y+2] -- mozna
// ja wywolac dla obszaru, ktory sie zmienil z marginesem wielkosci 2.
// Uwaga: trzeba wywolac most12.Inicjuj(), jesli zmienila sie wielkosc planszy
{
 STOPER_START_ZM12;
 for (int i=marg_min.x; i<=marg_max.x; i++)
  {
  unsigned int ind = WezIndeksTab(i, marg_min.y);
  for (int j=marg_min.y; j<=marg_max.y; j++)
   {
   mostki[ind]=0;
   if (rozgr2[ind]==ktory_gracz)
     {  // jest (srodkowa) kropka, trzeba sprawdzic, czy sa mostki
     krint maska=1;
     for (int nrm=0; nrm<8; nrm++)
       {
       if (rozgr2[ind + most12.dind[nrm]] == ktory_gracz &&    // druga nasza kropka
           rozgr3[ind + most12.puste1[nrm]] == 0 &&         //  wolne pola miedzy
           rozgr3[ind + most12.puste2[nrm]] == 0 &&         //  naszymi kropkami
           (rozgr3[ind + most12.nie_nasza1a[nrm]] != ktory_gracz ||       // mostek
            rozgr3[ind + most12.nie_nasza2a[nrm]] != ktory_gracz)  &&     // nie
           (rozgr3[ind + most12.nie_nasza1b[nrm]] != ktory_gracz ||       // jest
            rozgr3[ind + most12.nie_nasza2b[nrm]] != ktory_gracz) )       // trywialny
         {  // jest nietrywialny mostek!
         mostki[ind] |= maska;
         }
       maska <<= 1;
       }
     // teraz sprawdz ososno, czy sa poziome i pionowe mostki
     // mostek 8 -- gorny gorny
     if (rozgr2[ind-2] == ktory_gracz &&   // druga nasza kropka
         !(mostki[ind] & 0x3)   &&         // nie ma mostku LGG ani PGG
         rozgr3[ind-1       ] != ktory_gracz &&    // mostek
         rozgr3[ind-wlky-4-1] != ktory_gracz &&    // nie jest
         rozgr3[ind+wlky+4-1] != ktory_gracz)      // trywialny
       {
       // sprawdz, czy sa min. 2 wolne pola miedzy naszymi kropkami
       int ilewolnych = (rozgr3[ind-1]==0) +
                        (i>2 && rozgr3[ind-wlky-4-1] ==0) +
                        (i<=wlkx && rozgr3[ind+wlky+4-1] ==0);
       if (ilewolnych>=2)
         mostki[ind] |= 0x100;
       }
     // mostek 9 -- prawy prawy
     if (rozgr2[ind+2*wlky+8] == ktory_gracz &&   // druga nasza kropka
         !(mostki[ind] & 0xc)   &&        // nie ma mostku PPG ani PPD
         rozgr3[ind+W_P  ] != ktory_gracz &&    // mostek
         rozgr3[ind+wlky+4-1] != ktory_gracz &&    // nie jest
         rozgr3[ind+wlky+4+1] != ktory_gracz)      // trywialny
       {
       // sprawdz, czy sa min. 2 wolne pola miedzy naszymi kropkami
       int ilewolnych = (rozgr3[ind+W_P]==0) +
                        (j>2 && rozgr3[ind+wlky+4-1] ==0) +
                        (j<=wlky && rozgr3[ind+wlky+4+1] ==0);
       if (ilewolnych>=2)
         mostki[ind] |= 0x200;
       }
     // mostek 10 -- dolny dolny
     if (rozgr2[ind+2] == ktory_gracz &&   // druga nasza kropka
         !(mostki[ind] & 0x30)  &&         // nie ma mostku LDD ani PDD
         rozgr3[ind+1       ] != ktory_gracz &&    // mostek
         rozgr3[ind-wlky-4+1] != ktory_gracz &&    // nie jest
         rozgr3[ind+wlky+4+1] != ktory_gracz)      // trywialny
       {
       // sprawdz, czy sa min. 2 wolne pola miedzy naszymi kropkami
       int ilewolnych = (rozgr3[ind+1]==0) +
                        (i>2 && rozgr3[ind-wlky-4+1] ==0) +
                        (i<=wlkx && rozgr3[ind+wlky+4+1] ==0);
       if (ilewolnych>=2)
         mostki[ind] |= 0x400;
       }
     // mostek 11 -- lewy lewy
     if (rozgr2[ind-2*wlky-8] == ktory_gracz &&   // druga nasza kropka
         !(mostki[ind] & 0xc0)  &&        // nie ma mostku LLG ani LLD
         rozgr3[ind-wlky-4  ] != ktory_gracz &&    // mostek
         rozgr3[ind-wlky-4-1] != ktory_gracz &&    // nie jest
         rozgr3[ind-wlky-4+1] != ktory_gracz)      // trywialny
       {
       // sprawdz, czy sa min. 2 wolne pola miedzy naszymi kropkami
       int ilewolnych = (rozgr3[ind-wlky-4]==0) +
                        (j>2 && rozgr3[ind-wlky-4-1] ==0) +
                        (j<=wlky && rozgr3[ind-wlky-4+1] ==0);
       if (ilewolnych>=2)
         mostki[ind] |= 0x800;
       }
     }
   ind++;
   }
  }
 STOPER_STOP_ZM12;
}


void CzyscZakazaneWProstokacie(unsigned char *zakazane, krint *dod_pola,
			       TDwaUC marg3_min, TDwaUC marg3_max)
// wybiorczo czysci zakazane na brzegu prostokata
// i calkowicie wewnatrz, wewnatrz czysci tez dod_pola
// prostokat powinien miec wymiary min. 2x2 (4 kropki)
{
 {  // lewa banda razem z naroznikami
 unsigned int indeks_ij=WezIndeksTab(marg3_min.x,marg3_min.y);
 zakazane[indeks_ij++] &= ~(ZAKAZ_PD);   // wyzeruj zakaz PD, jesli jest
 for (int j=marg3_min.y+1; j<marg3_max.y; j++)
   zakazane[indeks_ij++] &= ~(ZAKAZ_PD | ZAKAZ_PG | ZAKAZ_P);
 zakazane[indeks_ij++] &= ~(ZAKAZ_PG);
 }
 {  // prawa banda razem z naroznikami
 unsigned int indeks_ij=WezIndeksTab(marg3_max.x,marg3_min.y);
 zakazane[indeks_ij++] &= ~(ZAKAZ_LD);
 for (int j=marg3_min.y+1; j<marg3_max.y; j++)
   zakazane[indeks_ij++] &= ~(ZAKAZ_LD | ZAKAZ_LG | ZAKAZ_L);
 zakazane[indeks_ij++] &= ~(ZAKAZ_LG);
 }
 {  // gorna banda bez naroznikow
 unsigned int indeks_ij=WezIndeksTab(marg3_min.x+1,marg3_min.y);
 for (int i=marg3_min.x+1; i<marg3_max.x; i++)
   {
   zakazane[indeks_ij] &= ~(ZAKAZ_LD | ZAKAZ_PD | ZAKAZ_D);   indeks_ij+=W_P;
   }
 }
 {  // dolna banda bez naroznikow
 unsigned int indeks_ij=WezIndeksTab(marg3_min.x+1,marg3_max.y);
 for (int i=marg3_min.x+1; i<marg3_max.x; i++)
   {
   zakazane[indeks_ij] &= ~(ZAKAZ_LG | ZAKAZ_PG | ZAKAZ_G);   indeks_ij+=W_P;
   }
 }
 // wnetrze
 for (int i=marg3_min.x+1; i<marg3_max.x; i++)
  {
  unsigned int indeks_ij=WezIndeksTab(i,marg3_min.y+1);
  for (int j=marg3_min.y+1; j<marg3_max.y; j++)
    {
    dod_pola[indeks_ij]=0;  zakazane[indeks_ij++]=0;
    }
  }
}


void UstawZakazane12_B(unsigned char *zakazane,
		       const unsigned char* rozg, const krint *skl_tab,
		       int indeks_ij, int ktory_gracz)
// sprawdza szablon typu B z lewa kropka w [indeks_ij]
{
  // mozliwe szablony typu B
  unsigned int ind_p= indeks_ij+W_P;
  unsigned int ind_g= indeks_ij-1;
  int przec=3-ktory_gracz;
  if (rozg[ind_p]==0)
    {
      if (rozg[ind_g]==0)
	{   // ,,czysty'' szablon typu B -- oba pola puste
	  zakazane[ind_g] |= ZAKAZ_PD;
	  zakazane[ind_p] |= ZAKAZ_LG;
	}
      else if (rozg[ind_g]==przec) {
	// szablony kolo bandy
	if (gracz_umiejetnosci & 0x200)
	  if ((upl_x[indeks_ij]==3 && rozg[indeks_ij-2]==ktory_gracz &&
	       rozg[ind_p-2]!=0 && rozg[indeks_ij-wlky-5]==0) ||
	      (upl_y[indeks_ij]==4 && rozg[indeks_ij-wlky-5]==ktory_gracz && 
	       rozg[indeks_ij-wlky-4]!=0 && rozg[indeks_ij-2]==0)) {
	    // sprawdz, czy jest zagrozenie na polu [ind_p] zwiazane z kropka [ind_g]
	    int s=skl_tab[ind_g], ind_pp = ind_p+W_P;
	    if (skl_tab[ind_pp-1]!=s && skl_tab[ind_pp]!=s && skl_tab[ind_pp+1]!=s &&
		skl_tab[ind_p+1]!=s && skl_tab[indeks_ij+1]!=s) {
	      zakazane[ind_g] |= ZAKAZ_PD;
	      zakazane[ind_p] |= ZAKAZ_LG;
	    }
	    return;
	  }
	// zwykle szablony
	if (upl_marg[ind_p]>=3)
	{
	  // mozliwe szablony typu BL:
	  //    x .
	  //    , w ?
	  //      ?
	  unsigned int ind_pp= ind_p+W_P;
	  unsigned int ind_pd= ind_p+1;
	  // jesli jedno z pol jest wolne, a drugie nasze...
	  if ((rozg[ind_pp] | rozg[ind_pd]) == ktory_gracz)
	    {
	      // sprawdz, czy nie ma zagrozenia na polu [ind_p]
	      krint jakie_s[3];
	      jakie_s[0] = skl_tab[ind_g];
	      jakie_s[1] = 0;       // zero nie moze oznaczac
	      jakie_s[2] = 0;       // skladowej przeciwnika
	      // pole (ppg)
	      unsigned int ind_ppg = ind_pp-1;
	      if (rozg[ind_ppg]==przec)
		if (skl_tab[ind_ppg] == jakie_s[0])
		  return;
		else
		  jakie_s[1]=skl_tab[ind_ppg];  
	      // pole (ppd)
	      unsigned int ind_ppd = ind_pp+1;
	      if (rozg[ind_ppd]==przec)
		if (skl_tab[ind_ppd] == jakie_s[0] || skl_tab[ind_ppd] == jakie_s[1])
		  return;
		else
		  jakie_s[2]=skl_tab[ind_ppd];
	      // pole (d)
	      unsigned int ind_d = indeks_ij+1;
	      if (rozg[ind_d]!=przec ||
		  (skl_tab[ind_d] != jakie_s[0] &&
		   skl_tab[ind_d] != jakie_s[1] &&
		   skl_tab[ind_d] != jakie_s[2]))
		{ // szablon typu BL !
		  zakazane[ind_g] |= ZAKAZ_PD;
		  zakazane[ind_p] |= ZAKAZ_LG;
		}
	    }
	}
      }
    }
  else if (rozg[ind_p]==przec && rozg[ind_g]==0) {
    // szablony kolo bandy
    if (gracz_umiejetnosci & 0x200)
      if ((upl_x[indeks_ij]==wlkx-1 && rozg[ind_p+1]==ktory_gracz &&
	   rozg[indeks_ij+1]!=0 && rozg[ind_p+W_P]==0) ||
	  (upl_y[indeks_ij]==wlky && rozg[ind_p+2*wlky+8]==ktory_gracz && 
	   rozg[ind_p+2*wlky+7]!=0 && rozg[ind_p+1]==0)) {
	// sprawdz, czy jest zagrozenie na polu [ind_g] zwiazane z kropka [ind_p]
	int s=skl_tab[ind_p], ind_l=indeks_ij-wlky-4;
	if (skl_tab[ind_p-2]!=s && skl_tab[indeks_ij-2]!=s && skl_tab[ind_l-2]!=s &&
	    skl_tab[ind_l-1]!=s && skl_tab[ind_l]!=s) {
	  zakazane[ind_g] |= ZAKAZ_PD;
	  zakazane[ind_p] |= ZAKAZ_LG;
	}
	return;
      }
    // zwykle szablony
    if (upl_marg[ind_g]>=3)
    {
      // mozliwe szablony typu BP:
      //      ?
      //    ? w .
      //      , x
      unsigned int ind_gg= indeks_ij-2;
      unsigned int ind_lg= indeks_ij-wlky-5;
      // jesli jedno z pol jest wolne, a drugie nasze...
      if ((rozg[ind_gg] | rozg[ind_lg]) == ktory_gracz)
	{
	  // sprawdz, czy nie ma zagrozenia na polu [ind_g]
	  krint jakie_s[3];
	  jakie_s[0] = skl_tab[ind_p];
	  jakie_s[1] = 0;       // zero nie moze oznaczac
	  jakie_s[2] = 0;       // skladowej przeciwnika
	  // pole (pgg)
	  unsigned int ind_pgg = ind_p-2;
	  if (rozg[ind_pgg]==przec)
	    if (skl_tab[ind_pgg] == jakie_s[0])
	      return;
	    else
	      jakie_s[1]=skl_tab[ind_pgg];  
	  // pole (lgg)
	  unsigned int ind_lgg = ind_lg-1;
	  if (rozg[ind_lgg]==przec)
	    if (skl_tab[ind_lgg] == jakie_s[0] || skl_tab[ind_lgg] == jakie_s[1])
	      return;
	    else
	      jakie_s[2]=skl_tab[ind_lgg];
	  // pole (l)
	  unsigned int ind_l = ind_lg+1;
	  if (rozg[ind_l]!=przec ||
	      (skl_tab[ind_l] != jakie_s[0] &&
	       skl_tab[ind_l] != jakie_s[1] &&
	       skl_tab[ind_l] != jakie_s[2]))
	    { // szablon typu BP !
	      zakazane[ind_g] |= ZAKAZ_PD;
	      zakazane[ind_p] |= ZAKAZ_LG;
	    }
	}
    }
  }
}


void UstawZakazane12_A(unsigned char *zakazane,
		       const unsigned char* rozg, const krint *skl_tab,
		       int indeks_ij, int ktory_gracz)
// sprawdza szablon typu A z lewa kropka w [indeks_ij]
{
  // mozliwe szablony typu A
  unsigned int ind_p= indeks_ij+W_P;
  unsigned int ind_d= indeks_ij+1;     
  int przec=3-ktory_gracz;
  if (rozg[ind_p]==0)
    {
      if (rozg[ind_d]==0)
	{   // ,,czysty'' szablon typu A -- oba pola puste
	  zakazane[ind_d] |= ZAKAZ_PG;
	  zakazane[ind_p] |= ZAKAZ_LD;
	}
      else if (rozg[ind_d]==przec) {
	// szablony kolo bandy
	if (gracz_umiejetnosci & 0x200)
	  if ((upl_x[indeks_ij]==3 && rozg[indeks_ij+2]==ktory_gracz &&
	       rozg[ind_p+1]!=0 && rozg[indeks_ij-wlky-4]==0) ||
	      (upl_y[indeks_ij]==wlky-1 && rozg[indeks_ij-wlky-3]==ktory_gracz && 
	       rozg[indeks_ij-wlky-4]!=0 && rozg[indeks_ij+2]==0)) {
	    // sprawdz, czy jest zagrozenie na polu [ind_p] zwiazane z kropka [ind_d]
	    int s=skl_tab[ind_d], ind_pp = ind_p+W_P;
	    if (skl_tab[ind_pp-1]!=s && skl_tab[ind_pp]!=s && skl_tab[ind_pp+1]!=s &&
		skl_tab[ind_p-1]!=s && skl_tab[indeks_ij-1]!=s) {
	      zakazane[ind_d] |= ZAKAZ_PG;
	      zakazane[ind_p] |= ZAKAZ_LD;
	    }
	    return;
	  }
	// zwykle szablony
	if (upl_marg[ind_p]>=3)
	{
	  // mozliwe szablony typu AL:
	  //      ?
	  //    , w ?
	  //    x .
	  unsigned int ind_pp= ind_p+W_P;
	  unsigned int ind_pg= ind_p-1;
	  // jesli jedno z pol jest wolne, a drugie nasze...
	  if ((rozg[ind_pp] | rozg[ind_pg]) == ktory_gracz)
	    {
	      // sprawdz, czy nie ma zagrozenia na polu [ind_p]
	      krint jakie_s[3];
	      jakie_s[0] = skl_tab[ind_d];
	      jakie_s[1] = 0;       // zero nie moze oznaczac
	      jakie_s[2] = 0;       // skladowej przeciwnika
	      // pole (ppg)
	      unsigned int ind_ppg = ind_pp-1;
	      if (rozg[ind_ppg]==przec)
		if (skl_tab[ind_ppg] == jakie_s[0])
		  return;
		else
		  jakie_s[1]=skl_tab[ind_ppg];
	      // pole (ppd)
	      unsigned int ind_ppd = ind_pp+1;
	      if (rozg[ind_ppd]==przec)
		if (skl_tab[ind_ppd] == jakie_s[0] || skl_tab[ind_ppd] == jakie_s[1])
		  return;
		else
		  jakie_s[2]=skl_tab[ind_ppd];
	      // pole (g)
	      unsigned int ind_g = indeks_ij-1;
	      if (rozg[ind_g]!=przec ||
		  (skl_tab[ind_g] != jakie_s[0] &&
		   skl_tab[ind_g] != jakie_s[1] &&
		   skl_tab[ind_g] != jakie_s[2]))
		{ // szablon typu AL !
		  zakazane[ind_d] |= ZAKAZ_PG;
		  zakazane[ind_p] |= ZAKAZ_LD;
		}
	    }
	}
      }
    }
  else if (rozg[ind_p]==przec && rozg[ind_d]==0) {
    // szablony kolo bandy
    if (gracz_umiejetnosci & 0x200)
      if ((upl_x[indeks_ij]==wlkx-1 && rozg[ind_p-1]==ktory_gracz &&
	   rozg[indeks_ij-1]!=0 && rozg[ind_p+W_P]==0) ||
	  (upl_y[indeks_ij]==3 && rozg[ind_p+W_P]==ktory_gracz && 
	   rozg[indeks_ij+wlky+5]!=0 && rozg[ind_p-1]==0)) {
	// sprawdz, czy jest zagrozenie na polu [ind_d] zwiazane z kropka [ind_p]
	int s=skl_tab[ind_p], ind_l = indeks_ij-wlky-4;
	if (skl_tab[ind_p+2]!=s && skl_tab[indeks_ij+2]!=s && skl_tab[ind_l]!=s &&
	    skl_tab[ind_l+1]!=s && skl_tab[ind_l+2]!=s) {
	  zakazane[ind_d] |= ZAKAZ_PG;
	  zakazane[ind_p] |= ZAKAZ_LD;
	}
	return;
      }
    // zwykle szablony
    if (upl_marg[ind_d]>=3)
    {
      // mozliwe szablony typu AP:
      //      , x
      //    ? w .
      //      ?
      unsigned int ind_dd= indeks_ij+2;
      unsigned int ind_ld= indeks_ij-wlky-3;
      // jesli jedno z pol jest wolne, a drugie nasze...
      if ((rozg[ind_dd] | rozg[ind_ld]) == ktory_gracz)
	{
	  // sprawdz, czy nie ma zagrozenia na polu [ind_d]
	  krint jakie_s[3];
	  jakie_s[0] = skl_tab[ind_p];
	  jakie_s[1] = 0;       // zero nie moze oznaczac
	  jakie_s[2] = 0;       // skladowej przeciwnika
	  // pole (pdd)
	  unsigned int ind_pdd = ind_p+2;
	  if (rozg[ind_pdd]==przec)
	    if (skl_tab[ind_pdd] == jakie_s[0])
	      return;
	    else
	      jakie_s[1]=skl_tab[ind_pdd]; 
	  // pole (ldd)
	  unsigned int ind_ldd = ind_ld+1;
	  if (rozg[ind_ldd]==przec)
	    if (skl_tab[ind_ldd] == jakie_s[0] || skl_tab[ind_ldd] == jakie_s[1])
	      return;
	    else
	      jakie_s[2]=skl_tab[ind_ldd];
	  // pole (l)
	  unsigned int ind_l = ind_ld-1;
	  if (rozg[ind_l]!=przec ||
	      (skl_tab[ind_l] != jakie_s[0] &&
	       skl_tab[ind_l] != jakie_s[1] &&
	       skl_tab[ind_l] != jakie_s[2]))
	    { // szablon typu AP !
	      zakazane[ind_d] |= ZAKAZ_PG;
	      zakazane[ind_p] |= ZAKAZ_LD;
	    }
	}
    }
  }
}

void UstawZakazane12_odl_pion(unsigned char *zakazane, const unsigned char* rozg,
			      int indeks, int ktory_gracz)
// sprawdza szablon
// ,.
// oo
// ..
{
  if (rozg[indeks+W_P]==ktory_gracz && rozg[indeks+W_PDD]==ktory_gracz &&
      rozg[indeks+W_D]==0           && rozg[indeks+W_PD ]==0) {
    zakazane[indeks+W_D ] |= ZAKAZ_P;
    zakazane[indeks+W_PD] |= ZAKAZ_L;
  }
}

void UstawZakazane12_odl_poziom(unsigned char *zakazane, const unsigned char* rozg,
				int indeks, int ktory_gracz)
// sprawdza szablon
// ,o.
// .o.
{
  if (rozg[indeks+W_D]==ktory_gracz && rozg[indeks+W_PPD]==ktory_gracz &&
      rozg[indeks+W_P]==0           && rozg[indeks+W_PD ]==0) {
    zakazane[indeks+W_P ] |= ZAKAZ_D;
    zakazane[indeks+W_PD] |= ZAKAZ_G;
  }
}



void UstawZakazane12(unsigned char *zakazane,
		     unsigned char* rozg, krint *skl_tab,
		     int ktory_gracz,
		     TDwaUC marg3_min, TDwaUC marg3_max)
// we: rozg -- plansza z rozgrywka (wewnatrz stopow kropki wlasciciela stopu)
//             nie niszczy tej tablicy!!!
//     skl_tab  -- tablica ze skladowymi, jak po wywolaniu ZnajdzSkladowe(),
//                 choc niekoniecznie tak. Istotne sa tylko skladowe
//                 przeciwnika, sposob ich numeracji jest bez znaczenia, z tym
//                 ze 0 nie moze oznaczac jednej ze skladowych (przeciwnika).
//     marg3_min, _max -- jaka czesc planszy nalezy obejsc
//                 NIE ZERUJE TABLICY zakazane NIGDZIE!
//                 Dlatego nalezy wyczyscic zakazane[] przed wolaniem tej
//                 funkcji, albo przy uzyciu CzyscZakazaneWProstokacie(), albo
//                 przy uzyciu CzyscTablice().
// Funkcja jest ,,lokalna'' w tym sensie, ze wartosc zakazane[x][y]
// zalezy _tylko_ od pozycji w kwadracie [x-2,x+2] x [y-2,y+2] -- mozna
// ja wywolac dla obszaru, ktory sie zmienil z marginesem wielkosci 2.
//
// szablony:
//    A: , w      B: w .
//       w .         , w
// w  oznacza puste pole
// .          nasza kropke,
// ,          nasza kropke, od ktorej zaczynamy rozpoznawanie szablonu
// Dodatkowo rozpatrujemy warianty szablonow A i B, w ktorym jedno z pustych
//  pol jest zastapione kropka przeciwnika (wariant L, jesli jest to lewe pole,
//  lub wariant P, jesli jest to prawe pole).
// Dodatkowo mamy szablony ,,odlegle'':
//   pionowy:           poziomy:
//     ,.                 ,w.
//     ww                 ,w.
//     ..
// Okreslenia ,,w gore'' i ,,w dol'' odnosza sie do wsp. ekranowych
//   (zwrot osi pionowej w dol).
{
 STOPER_START_UZAK;
 for (int i=marg3_min.x; i<=marg3_max.x; i++)
  {
  unsigned int indeks_ij=WezIndeksTab(i,marg3_min.y);
  for (int j=marg3_min.y; j<=marg3_max.y; j++)
    {
      if (rozg[indeks_ij]==ktory_gracz)
	{
	  if (rozg[indeks_ij+wlky+3]==ktory_gracz)
	    UstawZakazane12_B(zakazane, rozg, skl_tab, indeks_ij, ktory_gracz);
	  if (rozg[indeks_ij+wlky+5]==ktory_gracz)
	    UstawZakazane12_A(zakazane, rozg, skl_tab, indeks_ij, ktory_gracz);
	  else {
	    if (rozg[indeks_ij+W_DD]==ktory_gracz)
	      UstawZakazane12_odl_pion(zakazane, rozg, indeks_ij, ktory_gracz);
	    if (rozg[indeks_ij+W_PP]==ktory_gracz)
	      UstawZakazane12_odl_poziom(zakazane, rozg, indeks_ij, ktory_gracz);
	  }
	}
      indeks_ij++;
    }
  }
 STOPER_STOP_UZAK;
}


TMostki12 most12;

int TRobaki::waga_kropki;   // parametr poziomu 12

void TRobaki::Przydziel()
{
  nast_kropka_robaka = nast_kropka_robaka_tab = skladowe.PrzydzielSkladowa();
  robaki        = robaki_tab         = skladowe.PrzydzielSkladowa();
  //  lista_naszych = lista_naszych_tab  = skladowe.PrzydzielSkladowa();
  polaczenia    = polaczenia_tab     = skladowe.PrzydzielSkladowa();
  polaczenia_odl= polaczenia_odl_tab = skladowe.PrzydzielSkladowa();
  straty        = straty_tab         = skladowe.PrzydzielSkladowa();       // na to wystarczy
  dolne_kropki  = dolne_kropki_tab   = &straty_tab[ (wlkx4wlky4/2) & ~1];  // polowa tablicy
  na_pewno_bezp = na_pewno_bezp_tab  = plansze.PrzydzielPlansze();
}

void TRobaki::Zwolnij()
{
  skladowe.ZwolnijSkladowa(robaki_tab);
  skladowe.ZwolnijSkladowa(nast_kropka_robaka_tab);
  //  skladowe.ZwolnijSkladowa(lista_naszych_tab);
  skladowe.ZwolnijSkladowa(polaczenia_tab);
  skladowe.ZwolnijSkladowa(polaczenia_odl_tab);
  skladowe.ZwolnijSkladowa(straty_tab);
  plansze.ZwolnijPlansze(na_pewno_bezp_tab);
}

void TRobaki::UstawCzyje(int kto, int niska_ocena_duzych_brz)
{
  czyje = kto;
  maska_sstopu = kto==1 ? 4:8;
  if (niska_ocena_duzych_brz) maska_sstopu|=0x40;   // pola punktowane
}


void TRobaki::DodajRobaka(const unsigned char *rozgrywka, const unsigned char *rozgr2, 
			  const unsigned char *rozgr3, const unsigned char *plansz_p,
			  krint *stos, int indeks)
{
  unsigned int na_stosie=1;
  stos[0]=indeks;    
  robaki[indeks] = ++ost_nr_robaka;
  int doly=upl_y[indeks],  dol=indeks;
  int wart=0, bezp=0;
  int poprz_ind;
  int maska_ss_przec = (czyje==1)? 8:4;
  if ((plansz_p[indeks] & maska_ss_przec)==0) {
    do {
      unsigned int ind = stos[--na_stosie];
      nast_kropka_robaka[ind] = poprz_ind;
      poprz_ind=ind;
      bezp |= (upl_marg[ind]==2);
      if (upl_y[ind]>doly) { doly=upl_y[ind];  dol=ind; }
      // dodaj straty
      if (rozgrywka[ind]==czyje)
	wart+=TRobaki::waga_kropki;    // kropka
      else if ((plansz_p[ind] & maska_sstopu) == maska_sstopu)
	wart++;     // staly stop
      // odwiedz sasiadow
      for (int b=0; b<4; b++) {
	unsigned int nowy_ind = ind+up.dind[b];
	if (rozgr3[nowy_ind]==czyje && 
	    (plansz_p[nowy_ind] & maska_ss_przec)==0 &&   // daruj sobie sporne pola/kropki
	    robaki[nowy_ind]==0)
	  robaki[ stos[na_stosie++]=nowy_ind ] = ost_nr_robaka;
      }
    }
    while (na_stosie);
  }
  else { // kropka [indeks] JEST wewn. brzuszka (przeciwnika)
    do {
      unsigned int ind = stos[--na_stosie];
      nast_kropka_robaka[ind] = poprz_ind;
      poprz_ind=ind;
      // bezp |= (upl_marg[ind]==2);  // tutaj niepotrzebne, na pewno nie jest bezpieczne
      if (upl_y[ind]>doly) { doly=upl_y[ind];  dol=ind; }
      // dodaj straty
      // if (rozgrywka[ind]==czyje) -- niepotrzebne, musi byc prawda
      wart+=TRobaki::waga_kropki;
      // odwiedz sasiadow
      for (int b=0; b<4; b++) {
	unsigned int nowy_ind = ind+up.dind[b];
	if ((rozgrywka[nowy_ind]==czyje
	     || (plansz_p[nowy_ind] & czyje))       // wewnatrz naszego stopu
	     // || (plansz_p[nowy_ind] & 0xc)==0xc)   // sporne wolne pole
	     // tu bylyby klopoty ze spornymi polami:
	     //  ich dodawanie byloby zle w sytuacji, gdy sa sporne kropki,
	     //  czyli przecinajace sie potencjalne stopy (mozliwe na glebokosci 0)
	     // Dlatego ignorujemy wolne pola, co powiekszy liczbe robakow i polaczen,
	     // ale powinno byc ok.
	    && robaki[nowy_ind]==0)
	  robaki[ stos[na_stosie++]=nowy_ind ] = ost_nr_robaka;
      }
    }
    while (na_stosie);
  }
  nast_kropka_robaka[indeks] = poprz_ind;
  straty[ost_nr_robaka] = wart;
  na_pewno_bezp[ost_nr_robaka] = bezp;
  dolne_kropki[ost_nr_robaka] = dol;
}

void TRobaki::DodajOdlPol_pion(unsigned char *rozgrywka, unsigned int indeks)
// pozycja typu
// ,.
// oo
// ..
{
  if (robaki[indeks] && robaki[indeks+W_DD] && robaki[indeks+W_DD]!=robaki[indeks] &&
      rozgrywka[indeks+W_D]==0 && rozgrywka[indeks+W_PD]==0 && 
      robaki[indeks+W_P] && robaki[indeks+W_PDD]) {
    polaczenia_odl[ile_polaczen_odl3++] = indeks;
    polaczenia_odl[ile_polaczen_odl3++] = indeks+W_DD;
    polaczenia_odl[ile_polaczen_odl3++] = indeks+W_D;
    // drugim wolnym polem jest zawsze [indeks+W_PD]
  }
}

void TRobaki::DodajOdlPol_poziom(unsigned char *rozgrywka, unsigned int indeks)
// pozycja typu
// ,o.
// .o.
{
  if (robaki[indeks] && robaki[indeks+W_PP] && robaki[indeks+W_PP]!=robaki[indeks] &&
      rozgrywka[indeks+W_P]==0 && rozgrywka[indeks+W_PD]==0 &&
      robaki[indeks+W_D] && robaki[indeks+W_PPD]) {
    polaczenia_odl[ile_polaczen_odl3++] = indeks;
    polaczenia_odl[ile_polaczen_odl3++] = indeks+W_PP;
    polaczenia_odl[ile_polaczen_odl3++] = indeks+W_P;
    // drugim wolnym polem jest zawsze [indeks+W_PD]
  }
}

void TRobaki::Inicjuj(unsigned char *rozgrywka, unsigned char *rozgr2, 
		      unsigned char *rozgr3, unsigned char *plansz_p)
{
  krint *stos = skladowe.PrzydzielSkladowa();
  ost_nr_robaka = 0;
  nast_kropka_robaka = nast_kropka_robaka_tab;
  robaki = robaki_tab;    polaczenia = polaczenia_tab;   straty = straty_tab;
  polaczenia_odl = polaczenia_odl_tab;
  dolne_kropki  = dolne_kropki_tab;    na_pewno_bezp = na_pewno_bezp_tab;
  CzyscTablice(robaki);    CzyscTablice(nast_kropka_robaka);
  straty[0]=0;  dolne_kropki[0]=0;  na_pewno_bezp[0]=0;   // to moze ulatwiac niektore rzeczy
  for (int indeks=up.lg; indeks<=up.pd; indeks++)
    if (rozgr2[indeks]==czyje && robaki[indeks]==0)
      DodajRobaka(rozgrywka, rozgr2, rozgr3, plansz_p, stos, indeks);
  skladowe.ZwolnijSkladowa(stos);
  // ustaw polaczenia
  ile_polaczen2=0;
  ile_polaczen_odl3=0;
  for (int indeks=up.lg; indeks<=up.pd; indeks++)
    if (rozgr2[indeks]==czyje) {
      if (upl_marg[indeks]==3 && !na_pewno_bezp[robaki[indeks]]) {
	polaczenia[ile_polaczen2++] = indeks;
	polaczenia[ile_polaczen2++] = 0;          // czyli potencjalne polaczenie z banda
      }
      if (robaki[indeks+wlky+3] && robaki[indeks+wlky+3]!=robaki[indeks]) {
	polaczenia[ile_polaczen2++] = indeks;
	polaczenia[ile_polaczen2++] = indeks+wlky+3;
      }
      if (robaki[indeks+wlky+5] && robaki[indeks+wlky+5]!=robaki[indeks]) {
	polaczenia[ile_polaczen2++] = indeks;
	polaczenia[ile_polaczen2++] = indeks+wlky+5;
      }
      // ustaw odlegle polaczenia
      DodajOdlPol_pion(rozgrywka, indeks);
      DodajOdlPol_poziom(rozgrywka, indeks);
    }
  /*
  // sprawdz, czy wszystko ok
  for (int i=1; i<=ost_nr_robaka; i++)
    if (dolne_kropki[i]) {
      unsigned int indpocz = dolne_kropki[i], p = dolne_kropki[i];
      do {
	int pom = nast_kropka_robaka[p];
	if (pom==0 || robaki[pom]!=i || upl_y[pom]>upl_y[indpocz])
	  printf("blad_u");
	p=pom;
      } while (p!=indpocz);
    }
  */
}

void TRobaki::DodajPolaczenia(unsigned char *rozgrywka, unsigned int indeks)
{
  if (upl_marg[indeks]==3 && !na_pewno_bezp[robaki[indeks]]) {
    polaczenia[ile_polaczen2++] = indeks;
    polaczenia[ile_polaczen2++] = 0;          // czyli potencjalne polaczenie z banda
  }
  if (robaki[indeks+wlky+3] && robaki[indeks+wlky+3]!=robaki[indeks]) {
    polaczenia[ile_polaczen2++] = indeks;
    polaczenia[ile_polaczen2++] = indeks+wlky+3;
  }
  if (robaki[indeks+wlky+5] && robaki[indeks+wlky+5]!=robaki[indeks]) {
    polaczenia[ile_polaczen2++] = indeks;
    polaczenia[ile_polaczen2++] = indeks+wlky+5;
  }
  if (robaki[indeks-wlky-3] && robaki[indeks-wlky-3]!=robaki[indeks]) {
    polaczenia[ile_polaczen2++] = indeks;
    polaczenia[ile_polaczen2++] = indeks-wlky-3;
  }
  if (robaki[indeks-wlky-5] && robaki[indeks-wlky-5]!=robaki[indeks]) {
    polaczenia[ile_polaczen2++] = indeks;
    polaczenia[ile_polaczen2++] = indeks-wlky-5;
  }
  // teraz odlegle
  DodajOdlPol_pion(rozgrywka, indeks);
  DodajOdlPol_pion(rozgrywka, indeks+W_L);
  DodajOdlPol_pion(rozgrywka, indeks+W_GG);
  DodajOdlPol_pion(rozgrywka, indeks+W_LGG);
  DodajOdlPol_poziom(rozgrywka, indeks);
  DodajOdlPol_poziom(rozgrywka, indeks+W_G);
  DodajOdlPol_poziom(rozgrywka, indeks+W_LL);
  DodajOdlPol_poziom(rozgrywka, indeks+W_LLG);
}

void TRobaki::SkopiujPotrzebne(krint *poprz)
{
  int ile_bylo2 = ile_polaczen2;
  ile_polaczen2=0;
  for (int i=0; i<ile_bylo2; i+=2) {
    krint k1 = *poprz++;
    krint k2 = *poprz++;
    if (robaki[k1])
      if (k2) {  // polaczenie nie z banda
	if (robaki[k2] && robaki[k1]!=robaki[k2]) {
	  polaczenia[ile_polaczen2++] = k1;
	  polaczenia[ile_polaczen2++] = k2;
	}
      }
      else if (!na_pewno_bezp[robaki[k1]]) {
	// polaczenie z banda!
	polaczenia[ile_polaczen2++] = k1;
	polaczenia[ile_polaczen2++] = 0;  // =k2;
      }
  }
}

void TRobaki::SkopiujPotrzebneOdl(unsigned char *rozgrywka, krint *poprz_odl)
{
  int ile_bylo3 = ile_polaczen_odl3;  
  ile_polaczen_odl3=0;
  for (int i=0; i<ile_bylo3; i+=3) {
    krint k1 = *poprz_odl++;
    krint k2 = *poprz_odl++;
    krint k3 = *poprz_odl++;
    if (robaki[k1] && robaki[k2] && robaki[k1]!=robaki[k2] &&
	rozgrywka[k3]==0 && rozgrywka[k1+W_PD]==0) {
      polaczenia_odl[ile_polaczen_odl3++] = k1;
      polaczenia_odl[ile_polaczen_odl3++] = k2;
      polaczenia_odl[ile_polaczen_odl3++] = k3;
    }
  }
}

void TRobaki::DodajKropke(TRobaki &poprz, unsigned char *rozgrywka, unsigned char *rozgr2,
			  unsigned char *rozgr3, unsigned char *plansz_p, unsigned int indeks,
			  int byl_stop, int byl_sstop)
{
  STOPER_START_ROBD;
  zap_indeks = indeks;
  ost_nr_robaka = poprz.ost_nr_robaka;
  ile_polaczen2 = poprz.ile_polaczen2;
  ile_polaczen_odl3 = poprz.ile_polaczen_odl3;
  //  ile_naszych   = poprz.ile_naszych;
  if (rozgrywka[indeks]==czyje) {
    //lista_naszych = poprz.lista_naszych;
    //lista_naszych[ile_naszych++] = indeks;
    if (!byl_sstop) {
      if (poprz.robaki[indeks]) {   // mozliwe, gdy wstawilismy kropke do wlasnego brzuszka
	nast_kropka_robaka = poprz.nast_kropka_robaka;
	robaki=poprz.robaki;                straty=poprz.straty;
	dolne_kropki=poprz.dolne_kropki;    na_pewno_bezp=poprz.na_pewno_bezp;
	//lista_naszych = poprz.lista_naszych;
	polaczenia=poprz.polaczenia;
	polaczenia_odl=poprz.polaczenia_odl;
	sposob_odtw=2;  // = niczego nie trzeba odtwarzac	
	goto Koniec_rob;            // wtedy [indeks] moze byc juz czescia robaka
      }
      int nr_robaka = ost_nr_robaka+1;
      poprz.straty[nr_robaka]=0;
      // zobacz, ilu mamy sasiadow i zapamietaj indeks najwiekszego w ind_robaka
      int ile_robakow_sasiaduje=0;
      for (int b=0; b<4; b++) {
	unsigned int nind = indeks+up.dind[b];
	if (poprz.robaki[nind])
	  if (ile_robakow_sasiaduje==0) {
	    ile_robakow_sasiaduje=1;
	    nr_robaka = poprz.robaki[nind];
	    ind_robaka= nind;
	  }
	else
	  if (poprz.straty[nr_robaka] < poprz.straty[poprz.robaki[nind]]) {
	    ile_robakow_sasiaduje=2;
	    nr_robaka = poprz.robaki[nind];
	    ind_robaka= nind;
	  }
	  else if (nr_robaka!=poprz.robaki[nind])
	    ile_robakow_sasiaduje=2;
      }
      // a teraz dodaj kropke
      sposob_odtw = ile_robakow_sasiaduje;
      switch (ile_robakow_sasiaduje) {
      case 0:    // postawiona kropka jest izolowana - tworzy nowego robaka
	nast_kropka_robaka = poprz.nast_kropka_robaka;
	robaki=poprz.robaki;                straty=poprz.straty;
	dolne_kropki=poprz.dolne_kropki;    na_pewno_bezp=poprz.na_pewno_bezp;
	// dodaj kropke
	robaki[indeks]=nr_robaka;
	na_pewno_bezp[nr_robaka] = (upl_marg[indeks]==2);
	straty[nr_robaka] = TRobaki::waga_kropki;
	nast_kropka_robaka[indeks] = indeks;
	dolne_kropki[nr_robaka]=indeks;
	ost_nr_robaka++;
	// znajdz nowe polaczenia
	polaczenia=poprz.polaczenia;
	polaczenia_odl=poprz.polaczenia_odl;
	DodajPolaczenia(rozgrywka, indeks);
	break;
      case 1:    // dopisujemy kropke do istniejacego robaka
	nast_kropka_robaka = poprz.nast_kropka_robaka;
	robaki=poprz.robaki;                straty=poprz.straty;
	dolne_kropki=poprz.dolne_kropki;    na_pewno_bezp=poprz.na_pewno_bezp;
	// dodaj kropke
	robaki[indeks]=nr_robaka;
	zap_wart_npbezp = na_pewno_bezp[nr_robaka];
	na_pewno_bezp[nr_robaka] |= (upl_marg[indeks]==2);
	straty[nr_robaka] += TRobaki::waga_kropki;
	nast_kropka_robaka[indeks] = nast_kropka_robaka[ind_robaka];
	nast_kropka_robaka[ind_robaka] = indeks;
	zap_dolna = dolne_kropki[nr_robaka];
	if (ind_robaka==indeks-1 &&   // to powinno przyspieszyc...
	    upl_y[zap_dolna] < upl_y[indeks])
	  dolne_kropki[nr_robaka]=indeks;
	// znajdz nowe polaczenia
	polaczenia=poprz.polaczenia;
	polaczenia_odl=poprz.polaczenia_odl;
	DodajPolaczenia(rozgrywka, indeks);
	break;
      case 2:   // kropka laczy dwa istniejace robaki (lub nawet wiecej niz dwa)
	nast_kropka_robaka = nast_kropka_robaka_tab;
	robaki=robaki_tab;               straty=straty_tab;
	dolne_kropki=dolne_kropki_tab;   na_pewno_bezp=na_pewno_bezp_tab;
	KopiujTablice(robaki, poprz.robaki);    
	KopiujTablice(nast_kropka_robaka, poprz.nast_kropka_robaka);
	memcpy(straty       , poprz.straty       , sizeof(straty[0])*(ost_nr_robaka+1));
	memcpy(dolne_kropki , poprz.dolne_kropki , sizeof(dolne_kropki[0])*(ost_nr_robaka+1));
	memcpy(na_pewno_bezp, poprz.na_pewno_bezp, sizeof(na_pewno_bezp[0])*(ost_nr_robaka+1));
	// dodaj postawiona kropke do najwiekszego robaka
	robaki[indeks]=nr_robaka;
	na_pewno_bezp[nr_robaka] |= (upl_marg[indeks]==2);
	straty[nr_robaka] += TRobaki::waga_kropki;
	nast_kropka_robaka[indeks] = nast_kropka_robaka[ind_robaka];
	nast_kropka_robaka[ind_robaka] = indeks;
	if (ind_robaka==indeks-1 &&   // to powinno przyspieszyc...
	    upl_y[dolne_kropki[nr_robaka]] < upl_y[indeks])
	  dolne_kropki[nr_robaka]=indeks;
	// polacz robaki
	for (int b=0; b<4; b++) {
	  unsigned int nind = indeks+up.dind[b];
	  if (robaki[nind] && robaki[nind]!=nr_robaka) {
	    // dolacz robaka (nind) do [nr_robaka]
	    int drugi_robak = robaki[nind];
	    {
	      int p=nind;
	      do {
		robaki[p]=nr_robaka;
		p=nast_kropka_robaka[p];
	      } while (p!=nind);
	    }
	    {
	      int zap=nast_kropka_robaka[indeks];
	      nast_kropka_robaka[indeks] = nast_kropka_robaka[nind];
	      nast_kropka_robaka[nind] = zap;
	    }
	    straty[nr_robaka]+=straty[drugi_robak];
	    straty[drugi_robak]=0;
	    if (upl_y[dolne_kropki[nr_robaka]] < upl_y[dolne_kropki[drugi_robak]])
	      dolne_kropki[nr_robaka] = dolne_kropki[drugi_robak];
	    dolne_kropki[drugi_robak]=0;
	    na_pewno_bezp[nr_robaka] |= na_pewno_bezp[drugi_robak];
	    na_pewno_bezp[drugi_robak]=0;
	  }
	}
	polaczenia = polaczenia_tab;
	polaczenia_odl=polaczenia_odl_tab;
	SkopiujPotrzebne(poprz.polaczenia);
	SkopiujPotrzebneOdl(rozgrywka, poprz.polaczenia_odl);
	DodajPolaczenia(rozgrywka, indeks);
	break;
      }
    }
    else {  // byl stop -- cos zamknelismy!
      nast_kropka_robaka = nast_kropka_robaka_tab;
      robaki=robaki_tab;               straty=straty_tab;
      dolne_kropki=dolne_kropki_tab;   na_pewno_bezp=na_pewno_bezp_tab;
      krint *stos = skladowe.PrzydzielSkladowa();
      if (zasady_gry==0) {
	// w zasadzie nie gdy zasady_gry==0, tylko gdy stop (wszystkie stopy, gdy jest wiecej)
	// sasiaduje z postawiona kropka (czyli nie sytuacja: stawiamy kropke, a zamykamy
	// cos w zupelnie innym miejscu)
	KopiujTablice(robaki, poprz.robaki);    
	KopiujTablice(nast_kropka_robaka, poprz.nast_kropka_robaka);
	memcpy(straty       , poprz.straty       , sizeof(straty[0])*(ost_nr_robaka+1));
	memcpy(dolne_kropki , poprz.dolne_kropki , sizeof(dolne_kropki[0])*(ost_nr_robaka+1));
	memcpy(na_pewno_bezp, poprz.na_pewno_bezp, sizeof(na_pewno_bezp[0])*(ost_nr_robaka+1));
	unsigned int na_stosie=1;
	stos[0]=indeks;    
	robaki[indeks] = ++ost_nr_robaka;
	int doly=upl_y[indeks],  dol=indeks;
	int wart=0, bezp=0;
	int poprz_ind;
	do {
	  unsigned int ind = stos[--na_stosie];
	  nast_kropka_robaka[ind] = poprz_ind;
	  poprz_ind=ind;
	  bezp |= (upl_marg[ind]==2);
	  if (upl_y[ind]>doly) { doly=upl_y[ind];  dol=ind; }
	  // dodaj straty
	  if (rozgrywka[ind]==czyje)
	    wart+=TRobaki::waga_kropki;    // kropka
	  else if ((plansz_p[ind] & maska_sstopu) == maska_sstopu)
	    wart++;     // staly stop
	  // odwiedz sasiadow
	  for (int b=0; b<4; b++) {
	    unsigned int nowy_ind = ind+up.dind[b];
	    if (rozgr3[nowy_ind]==czyje && robaki[nowy_ind]!=ost_nr_robaka) {
	      // skasuj poprzedniego robaka
	      if (robaki[nowy_ind]) {
		straty[robaki[nowy_ind]] = dolne_kropki[robaki[nowy_ind]] =0;
		na_pewno_bezp[robaki[nowy_ind]] =0;
	      }
	      robaki[ stos[na_stosie++]=nowy_ind ] = ost_nr_robaka;
	    }
	  }
	}
	while (na_stosie);
	nast_kropka_robaka[indeks] = poprz_ind;
	straty[ost_nr_robaka] = wart;
	na_pewno_bezp[ost_nr_robaka] = bezp;
	dolne_kropki[ost_nr_robaka] = dol;
      }
      else {   // zasady_gry>0, a scislej stop niekoniecznie w sasiedztwie kropki [indeks]
	ost_nr_robaka=0;
	CzyscTablice(robaki);  CzyscTablice(nast_kropka_robaka);
	for (int i=1; i<=poprz.ost_nr_robaka; i++)
	  if (poprz.dolne_kropki[i] && robaki[poprz.dolne_kropki[i]]==0)
	    DodajRobaka(rozgrywka, rozgr2, rozgr3, plansz_p, stos, poprz.dolne_kropki[i]);
	if (robaki[indeks]==0)
	  DodajRobaka(rozgrywka, rozgr2, rozgr3, plansz_p, stos, indeks);
      }
      skladowe.ZwolnijSkladowa(stos);
      // ustaw polaczenia
      polaczenia = polaczenia_tab;
      polaczenia_odl = polaczenia_odl_tab;
      SkopiujPotrzebne(poprz.polaczenia);
      SkopiujPotrzebneOdl(rozgrywka, poprz.polaczenia_odl);
      DodajPolaczenia(rozgrywka, indeks);
      sposob_odtw=2;  // = niczego nie trzeba odtwarzac
    }
  }
  else if (byl_stop) {  // przeciwnik cos zamknal!
    nast_kropka_robaka = nast_kropka_robaka_tab;
    robaki=robaki_tab;               straty=straty_tab;
    dolne_kropki=dolne_kropki_tab;   na_pewno_bezp=na_pewno_bezp_tab;
    polaczenia = polaczenia_tab;
    polaczenia_odl = polaczenia_odl_tab;
    if (zasady_gry==0) {
      // to mogloby tez byc dla zasad_gry>=1, o ile przeciwnik nie przerwal nam brzuszka,
      // co mogloby spowodowac rozerwanie robaka (!), a nie jego calkowite zamkniecie!
      // To by duzo przyspieszalo!
      KopiujTablice(robaki, poprz.robaki);    
      KopiujTablice(nast_kropka_robaka, poprz.nast_kropka_robaka);
      memcpy(straty       , poprz.straty       , sizeof(straty[0])*(ost_nr_robaka+1));
      memcpy(dolne_kropki , poprz.dolne_kropki , sizeof(dolne_kropki[0])*(ost_nr_robaka+1));
      memcpy(na_pewno_bezp, poprz.na_pewno_bezp, sizeof(na_pewno_bezp[0])*(ost_nr_robaka+1));
      //lista_naszych = lista_naszych_tab;
      //ile_naszych=0;
      //for (int i=0; i<poprz.ile_naszych; i++)
      //  if (rozgr2[poprz.lista_naszych[i]]==czyje)
      //    lista_naszych[ile_naszych++] = poprz.lista_naszych[i];
      // usun zamkniete robaki
      int maska_stopu_przec = 3-czyje;
      for (int i=1; i<=ost_nr_robaka; i++)
	if (dolne_kropki[i] && (plansz_p[dolne_kropki[i]] & maska_stopu_przec)) {
	  unsigned int indpocz = dolne_kropki[i], p = dolne_kropki[i];
	  do {
	    int pom = nast_kropka_robaka[p];
	    robaki[p]=0;  nast_kropka_robaka[p]=0;
	    p=pom;
	  } while (p!=indpocz);
	  dolne_kropki[i]=0;
	  straty[i]=0;
	  na_pewno_bezp[i]=0;
	}
      // ustaw polaczenia
      SkopiujPotrzebne(poprz.polaczenia);
      SkopiujPotrzebneOdl(rozgrywka, poprz.polaczenia_odl);
    }
    else {  // zasady_gry>0
      // ustaw robaki od zera -- niektore mogly ulec rozerwaniu
      krint *stos = skladowe.PrzydzielSkladowa();
      ost_nr_robaka = 0;
      CzyscTablice(robaki);    CzyscTablice(nast_kropka_robaka);
      for (int ind=up.lg; ind<=up.pd; ind++)
	if (rozgr2[ind]==czyje && robaki[ind]==0)
	  DodajRobaka(rozgrywka, rozgr2, rozgr3, plansz_p, stos, ind);
      skladowe.ZwolnijSkladowa(stos);
      // ustaw polaczenia od zera (rozerwanie moglo sprawic, ze pojawily sie polaczenia
      //  miedzy nowymi robakami -- kiedys te polaczenia nalezaly do jednego duzego robaka)
      ile_polaczen2=0;
      ile_polaczen_odl3=0;
      for (int indeks=up.lg; indeks<=up.pd; indeks++)
	if (rozgr2[indeks]==czyje) {
	  if (upl_marg[indeks]==3 && !na_pewno_bezp[robaki[indeks]]) {
	    polaczenia[ile_polaczen2++] = indeks;
	    polaczenia[ile_polaczen2++] = 0;          // czyli potencjalne polaczenie z banda
	  }
	  if (robaki[indeks+wlky+3] && robaki[indeks+wlky+3]!=robaki[indeks]) {
	    polaczenia[ile_polaczen2++] = indeks;
	    polaczenia[ile_polaczen2++] = indeks+wlky+3;
	  }
	  if (robaki[indeks+wlky+5] && robaki[indeks+wlky+5]!=robaki[indeks]) {
	    polaczenia[ile_polaczen2++] = indeks;
	    polaczenia[ile_polaczen2++] = indeks+wlky+5;
	  }
	  // ustaw odlegle polaczenia
	  DodajOdlPol_pion(rozgrywka, indeks);
	  DodajOdlPol_poziom(rozgrywka, indeks);
	}
    }
    sposob_odtw=2;  // = niczego nie trzeba odtwarzac
  }
  else {  // przecwinik niczego nie zamyka...
    nast_kropka_robaka = poprz.nast_kropka_robaka;
    robaki=poprz.robaki;                straty=poprz.straty;
    dolne_kropki=poprz.dolne_kropki;    na_pewno_bezp=poprz.na_pewno_bezp;
    //lista_naszych = poprz.lista_naszych;
    polaczenia=poprz.polaczenia;
    polaczenia_odl=polaczenia_odl_tab;
    SkopiujPotrzebneOdl(rozgrywka, poprz.polaczenia_odl);  // niektore odlegle mogly sie zdezakt.
    sposob_odtw=2;  // = niczego nie trzeba odtwarzac
  }
 Koniec_rob:;
  
  /*
  // test:
  for (int i=0; i<ile_polaczen_odl3; i+=3) {
    krint k1=polaczenia_odl[i], k2=polaczenia_odl[i+1], k3=polaczenia_odl[i+2];
    if (rozgrywka[k1]!=czyje || rozgrywka[k2]!=czyje || rozgrywka[k3]
	|| rozgrywka[k1+W_PD]) {
      printf("blad_d1");
      sprintf(pargry.nz1, "krd%dg%d.z",int(bseed1), int(bseed2));
      gra.ObsluzZdarzenie(ZD_ZAPIS);
    }
    } */
  /*
  // sprawdz, czy wszystko ok
  for (int i=1; i<=ost_nr_robaka; i++)
    if (dolne_kropki[i]) {
      unsigned int indpocz = dolne_kropki[i], p = dolne_kropki[i];
      int dlug=0;
      do {
	int pom = nast_kropka_robaka[p];
	dlug++;
	if (pom==0 || robaki[pom]!=i || dlug>=wlkx4wlky4 || upl_y[pom]>upl_y[indpocz])
	  printf("blad_d1");
	p=pom;
      } while (p!=indpocz);
    }     
  for (int i=0; i<wlkx4wlky4; i++)
    if (rozgr2[i]==czyje && robaki[i]==0)
      printf("blad_d2");
  */
  STOPER_STOP_ROBD;
}

void TRobaki::UaktualnijGleb()
// zapamietaj, ze domyslnie nie nalezy niczego odtwarzac (byc moze nie dodalismy kropki)
{  sposob_odtw=2; }

void TRobaki::UstawPolaczonyZ_sklad(krint *polaczony_z) const
// ustawia tablice polaczony_z tak, aby
//   polaczony_z[robaki[ind1]] == polaczony_z[robaki[ind2]]   <=> 
//           <=>  [ind1] i [ind2] naleza do tej samej skladowej
{
  for (int i=1; i<=ost_nr_robaka; i++)
    polaczony_z[i]=i;
  // badaj polaczenia
  for (int p=0; p<ile_polaczen2; p+=2) {
    krint k1=polaczenia[p], k2=polaczenia[p+1];
    if (k2) {
      int nr1=robaki[k1], nr2=robaki[k2];
      while (polaczony_z[nr1]!=nr1) nr1=polaczony_z[nr1];
      while (polaczony_z[nr2]!=nr2) nr2=polaczony_z[nr2];
      // polacz (nr1) z (nr2)
      if (nr1>nr2)
	polaczony_z[nr1]=nr2;
      else
	polaczony_z[nr2]=nr1;
    }
  }
  // zrob ,,kanoniczne'' polaczenia
  for (int i=ost_nr_robaka; i>1; i--)
    if (polaczony_z[i]!=i) {
      int nr=polaczony_z[i];
      while (nr!=polaczony_z[nr]) nr=polaczony_z[nr];
      polaczony_z[i]=nr;
    }
}

void TRobaki::ZnajdzSkladowe(krint *skl_tab, int nrpoczskl, unsigned char *rozgr2) const
// dziala jak ZnajdzSkladowe
// znajduje skladowe dla JEDNEGO gracza; skl_tab powinna byc wstepnie wyczyszczona (moze miec
//  tez ustawione skladowe 2. gracza)
{
  STOPER_START_ROBS;
  krint *polaczony_z;
  polaczony_z   = skladowe.PrzydzielSkladowa();
  UstawPolaczonyZ_sklad(polaczony_z);
  // teraz mozna ustawiac skl_tab
  for (int i=1; i<=ost_nr_robaka; i++)
    if (dolne_kropki[i]) {
      unsigned int ind0 = dolne_kropki[i];
      unsigned int ind = ind0;
      int nrskl = nrpoczskl + polaczony_z[i];
      do {
	// dla z.gry==0 wystarczalo: skl_tab[ind] = nrskl;
	// skl_tab[ind] = rozgr2[ind]==czyje ? nrskl : 0;
	if (rozgr2[ind]==czyje)
	  skl_tab[ind] = nrskl;
	ind = nast_kropka_robaka[ind];
      } while (ind!=ind0);
    }
  skladowe.ZwolnijSkladowa(polaczony_z);
  STOPER_STOP_ROBS;
}

TRobaki& TRobaki::operator=(const TRobaki& arg)
// Funkcja zaklada, ze this!=&arg
// ustawia wszystkie wskazniki w (this) na odp. wskazniki (arg)
{
  nast_kropka_robaka = arg.nast_kropka_robaka;
  robaki        = arg.robaki;             straty        = arg.straty;
  dolne_kropki  = arg.dolne_kropki;       na_pewno_bezp = arg.na_pewno_bezp;
  //lista_naszych = arg.lista_naszych;
  polaczenia    = arg.polaczenia;
  polaczenia_odl= arg.polaczenia_odl;

  ost_nr_robaka = arg.ost_nr_robaka;
  ile_polaczen2 = arg.ile_polaczen2;
  ile_polaczen_odl3 = arg.ile_polaczen_odl3;
  //  ile_naszych   = arg.ile_naszych;
  sposob_odtw   = 2;   // niczego nie odtwarzaj!
  // nie kopiuj  czyje ani maska_sstopu;
}

void TRobaki::UsunKropke()
{
  switch (sposob_odtw) {
  case 0:
    // dla testu zeruj tez na_pewno_bezp...dolne_kropki:
    //      na_pewno_bezp[ost_nr_robaka]=straty[ost_nr_robaka]=dolne_kropki[ost_nr_robaka]=0;
    robaki[zap_indeks]=0;
    nast_kropka_robaka[zap_indeks] = 0;
    break;
  case 1:
    nast_kropka_robaka[ind_robaka] = nast_kropka_robaka[zap_indeks];
    nast_kropka_robaka[zap_indeks] = 0;
    na_pewno_bezp[robaki[zap_indeks]]= zap_wart_npbezp;
    straty[robaki[zap_indeks]] -= TRobaki::waga_kropki;
    if (dolne_kropki[robaki[zap_indeks]]==zap_indeks)
      dolne_kropki[robaki[zap_indeks]] = zap_dolna;
    robaki[zap_indeks]=0;
    break;
  case 2:   // nic nie trzeba odtwarzac...
    break;
  }
}

void TRobaki::OdtworzKropke()
// odtwarza kropke usunieta funkcja UsunKropke().
{
  switch (sposob_odtw) {
  case 0:
    robaki[zap_indeks]=ost_nr_robaka;
    nast_kropka_robaka[zap_indeks] = zap_indeks;
    break;
  case 1:
    nast_kropka_robaka[zap_indeks] = nast_kropka_robaka[ind_robaka];
    nast_kropka_robaka[ind_robaka] = zap_indeks;
    robaki[zap_indeks] = robaki[ind_robaka];
    na_pewno_bezp[robaki[zap_indeks]] |= (upl_marg[zap_indeks]==2);
    straty[robaki[zap_indeks]] += TRobaki::waga_kropki;
    if (upl_y[zap_indeks]>upl_y[zap_dolna])
      dolne_kropki[robaki[zap_indeks]] = zap_indeks;
    break;
  case 2:   // nic nie trzeba odtwarzac...
    break;
  }
}

int TRobaki::ZakazanePomiedzy(unsigned char *zakazane, unsigned int k1, unsigned int k2)
// zwraca 0, gdy nie jest zakazane, lub cos !=0 w przeciwnym razie
// k1,k2 powinny sie stykac po przekatnej
{
  if (k1<k2)
    if (k2==k1+wlky+3)
      return (zakazane[k2+1] & ZAKAZ_LG);
    else
      return (zakazane[k2-1] & ZAKAZ_LD);
  else
    if (k1==k2+wlky+3)
      return (zakazane[k1+1] & ZAKAZ_LG);
    else
      return (zakazane[k1-1] & ZAKAZ_LD);
}

int TRobaki::ZnajdzRobakiMatki(unsigned char *plansz_p, unsigned char *zakazane, 
			       unsigned char *bezpieczne,
			       TDwaUC marg3_min, TDwaUC marg3_max,
			       krint *goradol, krint *stratyskl,
			       krint *polaczony_z, krint *dolne_m)
// zwraca liczbe ustawionych skladowych w ,,goradol'' i ,,stratyskl''
{
  STOPER_START_ROBM;
  krint *straty_m, *bezp_m;   // _m jest skrotem od matki
  straty_m      = skladowe.PrzydzielSkladowa();
  bezp_m        = skladowe.PrzydzielSkladowa();
  for (int i=1; i<=ost_nr_robaka; i++) {
    bezp_m[i] = na_pewno_bezp[i] ? 2:0;
    polaczony_z[i]=i;
  }
  memcpy(dolne_m, dolne_kropki, sizeof(dolne_m[0])*(ost_nr_robaka+1));
  if (zasady_gry==2)
    for (int i=1; i<=ost_nr_robaka; i++)
      if (plansz_p[dolne_m[i]] & 0x30)   // moze zostac zamknieta
	dolne_m[i]=0;   // ignoruj tego robaka!
  memcpy(straty_m, straty, sizeof(straty_m[0])*(ost_nr_robaka+1));
  // badaj polaczenia
  for (int p=0; p<ile_polaczen2; p+=2) {
    krint k1=polaczenia[p], k2=polaczenia[p+1];
    if (plansz_p[k1] & 0x30) continue;   // moze zostac zamknieta, ignoruj
    if (k2) {
      if (plansz_p[k2] & 0x30) continue;   // moze zostac zamknieta, ignoruj
      if (ZakazanePomiedzy(zakazane,k1,k2)) {
	int nr1=robaki[k1], nr2=robaki[k2];
	while (polaczony_z[nr1]!=nr1) nr1=polaczony_z[nr1];
	while (polaczony_z[nr2]!=nr2) nr2=polaczony_z[nr2];
	// polacz (nr1) z (nr2)
	if (nr1>nr2)
	  polaczony_z[nr1]=nr2;
	else
	  polaczony_z[nr2]=nr1;
      }
    }
    else  // kolo bandy
      bezp_m[robaki[k1]] += bezpieczne[k1];
  }
  // badaj odlegle polaczenia
  for (int p=0; p<ile_polaczen_odl3; p+=3) {
    krint k1=polaczenia_odl[p], k2=polaczenia_odl[p+1];
    if (plansz_p[k1] & 0x30 || plansz_p[k2] & 0x30) continue;   // moze zostac zamknieta, ignoruj
    int nr1=robaki[k1], nr2=robaki[k2];
    while (polaczony_z[nr1]!=nr1) nr1=polaczony_z[nr1];
    while (polaczony_z[nr2]!=nr2) nr2=polaczony_z[nr2];
    // polacz (nr1) z (nr2)
    if (nr1>nr2)
      polaczony_z[nr1]=nr2;
    else
      polaczony_z[nr2]=nr1;
  }
  // zrob ,,kanoniczne'' polaczenia; pododawaj straty_m, bezp_m i dolne_m
  for (int i=ost_nr_robaka; i>1; i--)
    if (polaczony_z[i]!=i) {
      int nr=polaczony_z[i];
      while (nr!=polaczony_z[nr]) nr=polaczony_z[nr];
      polaczony_z[i]=nr;
      bezp_m[nr] += bezp_m[i];
      straty_m[nr] += straty_m[i];
      if (upl_y[dolne_m[i]] > upl_y[dolne_m[nr]])
	dolne_m[nr] = dolne_m[i];
    }
  // teraz mozna ustawiac ,,goradol'' i ,,stratyskl''
  int ileskl=0;
  for (int i=1; i<=ost_nr_robaka; i++)
    if (dolne_m[i] && polaczony_z[i]==i && bezp_m[i]<2) {    
      // kiedys bylo powyzej dolne_kropki[i] zamiast dolne_m[i]
      // (teraz przy zasadach gry==2 trzeba dolne_m)
      *goradol++   = dolne_m[i];
      *stratyskl++ = straty_m[i];
      ileskl++;
    }
  skladowe.ZwolnijSkladowa(straty_m);
  skladowe.ZwolnijSkladowa(bezp_m);
  STOPER_STOP_ROBM;
  return ileskl;
}



int TRobaki::ZnajdzRobakiMatki(unsigned char *plansz_p, unsigned char *zakazane, 
			       unsigned char *bezpieczne,
			       TDwaUC marg3_min, TDwaUC marg3_max,
			       krint *goradol, krint *stratyskl)
{
  krint *polaczony_z, *dolne_m;
  polaczony_z   = skladowe.PrzydzielSkladowa();
  dolne_m       = skladowe.PrzydzielSkladowa();
  int wynik = ZnajdzRobakiMatki(plansz_p, zakazane, bezpieczne,
				marg3_min, marg3_max,
				goradol, stratyskl, polaczony_z, dolne_m);
  skladowe.ZwolnijSkladowa(polaczony_z);
  skladowe.ZwolnijSkladowa(dolne_m);
  return wynik;
}

void TRobaki::UstawZakazane(unsigned char *zakazane, const unsigned char *rozgr3, 
			    const krint *skl_tab) const
{
  STOPER_START_UZAK;
  for (int p=0; p<ile_polaczen2; p+=2) {
    krint k1=polaczenia[p], k2=polaczenia[p+1];
    if (k2) {
      if (k1<k2)
	if (k2==k1+wlky+3)
	  UstawZakazane12_B(zakazane, rozgr3, skl_tab, k1, czyje);
	else
	  UstawZakazane12_A(zakazane, rozgr3, skl_tab, k1, czyje);
      else
	if (k1==k2+wlky+3)
	  UstawZakazane12_B(zakazane, rozgr3, skl_tab, k2, czyje);
	else
	  UstawZakazane12_A(zakazane, rozgr3, skl_tab, k2, czyje);
    }
  }
  // odlegle polaczenia
  for (int p=0; p<ile_polaczen_odl3; p+=3) {
    krint k1=polaczenia_odl[p], k3=polaczenia_odl[p+2];
    if (k3==k1+W_P) {
      // poziome odlegle
      zakazane[k3     ] |= ZAKAZ_D;
      zakazane[k1+W_PD] |= ZAKAZ_G;
    }
    else {
      // pionowe odlegle
      zakazane[k3     ] |= ZAKAZ_P;
      zakazane[k1+W_PD] |= ZAKAZ_L;
    }
  }
  STOPER_STOP_UZAK;
}


int TRobaki::OcenRuch(unsigned char *rozgr3, krint *polaczony_z, unsigned int indeks, 
		      int nasze, int &poziom_bezp) const
// ocenia ruch [indeks], ocena jest z przedzialu ok. 0-90
// polaczony_z -- ustawione przez funkcje TRobaki::UstawPolaczonyZ_sklad()
// ,,nasze'' -- czy w [indeks] stawiamy kropke TRobaki::czyje, uzywane do sprawdzenia, czy
//              trzeba zwracac poziom_bezp (0,1,2,3) stawianej kropki (TYLKO gdy ,,nasze'').
// Uwaga: trzeba wywolac most12.Inicjuj(), jesli zmienila sie wielkosc planszy!!
{
  int ocena=0;
  // policz bezposrednich sasiadow
  int ile_rob=0, ile_sklad=0;
  int rob[8], sklad[20];    // z zapasem
  int dind[20] = {-wlky-5, -wlky-4, -wlky-3, -1,1, wlky+3, W_P, wlky+5};
  for (int i=0; i<8; i++) {
    unsigned int ind = indeks+dind[i];
    if (robaki[ind]) {
      if (ile_rob==0) {
	rob[ile_rob++]=robaki[ind];
	sklad[ile_sklad++]=polaczony_z[robaki[ind]];
      }
      else {
	for (int j=0; j<ile_rob; j++)
	  if (rob[j]==robaki[ind])
	    goto Nic_nie_rob;
	rob[ile_rob++]=robaki[ind];
	// skladowe
	sklad[ile_sklad]=polaczony_z[robaki[ind]];
	for (int j=0; j<ile_sklad; j++)
	  if (sklad[j]==polaczony_z[ile_sklad])
	    goto Nic_nie_rob;
	ile_sklad++;
      Nic_nie_rob:;
      }
    }
  }
  // i dalsi sasiedzi -- juz tylko skladowe
  int ile_dalszych_skl=0;
  for (int i=0; i<12; i++) {
    unsigned int ind=indeks+most12.dind[i];
    if (robaki[ind]) {
      int suma=ile_sklad+ile_dalszych_skl;
      sklad[suma]=polaczony_z[robaki[ind]];
      // sprawdz, czy tej skladowej juz nie bylo
      for (int j=0; j<suma; j++)
	if (sklad[j]==sklad[suma])
	  goto Juz_byla_skl;
      // zobacz, ile jest pustych sasiadow
      {
      int ile_pomiedzy = (rozgr3[indeks+most12.puste1[i]]==0) +
	(rozgr3[indeks+most12.puste2[i]]==0) +
	(rozgr3[indeks+most12.puste3[i]]==0);
      if (ile_pomiedzy>=2)
	ile_dalszych_skl++;       // zapamietaj nowa skladowa
      }
    Juz_byla_skl:;
    }
  }
  if (nasze) {
    // sprawdz desen -- czesciowo! to jest w PoleBezs12()
    if (ile_rob==1) {
      int przec=3-czyje;
      if ((rozgr3[indeks-1]==czyje && rozgr3[indeks-wlky-4]==czyje
	   && rozgr3[indeks-wlky-5]==czyje &&                                // LG
	  rozgr3[indeks+1]!=przec && rozgr3[indeks+W_P]!=przec) ||
	  (rozgr3[indeks-1]==czyje && rozgr3[indeks+W_P]==czyje
	   && rozgr3[indeks+wlky+3]==czyje &&                                // PG
	  rozgr3[indeks+1]!=przec && rozgr3[indeks-wlky-4]!=przec) ||
	  (rozgr3[indeks+1]==czyje && rozgr3[indeks+W_P]==czyje
	   && rozgr3[indeks+wlky+5]==czyje &&                                // PD
	  rozgr3[indeks-1]!=przec && rozgr3[indeks-wlky-4]!=przec) ||
	  (rozgr3[indeks+1]==czyje && rozgr3[indeks-wlky-4]==czyje
	   && rozgr3[indeks-wlky-3]==czyje &&                                // LD
	   rozgr3[indeks-1]!=przec && rozgr3[indeks+W_P]!=przec)) {
	poziom_bezp=0;
	return 0;
      }
      } 
    if (upl_marg[indeks]==2 || 
	na_pewno_bezp[robaki[indeks-1]] ||           // powinno byc
	na_pewno_bezp[robaki[indeks+1]] ||           // na_pewno_bezp[0]=0
	na_pewno_bezp[robaki[indeks-wlky-4]] ||
	na_pewno_bezp[robaki[indeks+W_P]])
      poziom_bezp=4;
    else
      poziom_bezp= (upl_marg[indeks]==3) + (ile_rob!=0) + (ile_dalszych_skl!=0);
    ocena+=poziom_bezp;
    }
  // przelicz ile_rob, ile_sklad, ile_dalszych_sklad na ocene
  // bonus za robaki
  const int ocena_ile_rob[5]={0,6,10,10,10};
  ocena += ocena_ile_rob[ile_rob];
  // bonus za skladowe
  const int ocena_ile_sklad[]={0,6,40,56,72, 72,72,72,72,72, 72,72};   // z zapasem
  ocena += ocena_ile_sklad[ile_sklad+ile_dalszych_skl];
  ocena += ile_dalszych_skl;   // bonus za mostek
  return ocena;
}


/*
long int TRobaki::WezPoprawkeNaSklPop(unsigned char *rozgr3, long int *oceny)
{
  long int pop=0;
  for (int i=1; i<=ost_nr_robaka; i++)
    if (dolne_kropki[i] && polaczony_z[i]==i && bezp_m[i]<2) {
      // czy zamknieta?
      if (rozgr3[dolne_m[i]]!=czyje) pop += *oceny;
      oceny++;
    }
  return pop;
} */

/*
void TRobaki::PorownajZeSklnr(krint *sklnr, krint *stratynr, krint *goradol,
			      int ilesklnr)
{
  unsigned char *przetest=plansze.PrzydzielPlansze();
  CzyscTablice(przetest);
  for (int i=1; i<=ost_nr_robaka; i++)
    if (dolne_kropki[i] && polaczony_z[i]==i) {
      int nrs = sklnr[dolne_kropki[i]];
      assert(bezp_m[i]>=2 || (nrs<30000 && stratynr[nrs-1] == straty_m[i]));
      if (nrs==50000 || goradol[(nrs-1)]==0)
	assert(bezp_m[i]>=2);
      else {
	assert(bezp_m[i]<2);
	assert(upl_y[dolne_m[i]] == upl_y[goradol[nrs-1]]);
      }
      przetest[nrs]=1;
    }
  for (int i=1; i<=ilesklnr; i++)
    assert(przetest[i]);
  plansze.ZwolnijPlansze(przetest);
} */

/**********************************************************************/


