/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 * Kropki -- some classes for manipulating sgf                       *
 *                                                                   *
 * This file is based on sgftree.h, which is part                    *
 * of GNU Go, a Go program. Contact gnugo@gnu.org, or see            *
 * http://www.gnu.org/software/gnugo/ for more information.          *
 *                                                                   *
 * Copyright 1999, 2000, 2001, 2002, 2003 and 2004                   *
 * by the Free Software Foundation.                                  *
 * Copyright 2008 by Bartek Dyda <kropki@yahoo.co.uk>                *
 *                                                                   *
 * This program is free software; you can redistribute it and/or     *
 * modify it under the terms of the GNU General Public License as    *
 * published by the Free Software Foundation - version 2             *
 *                                                                   *
 * This program is distributed in the hope that it will be useful,   *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of    *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *
 * GNU General Public License in file COPYING for more details.      *
 *                                                                   *
 * You should have received a copy of the GNU General Public         *
 * License along with this program; if not, write to the Free        *
 * Software Foundation, Inc., 59 Temple Place - Suite 330,           *
 * Boston, MA 02111, USA.                                            *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef _SGFTREE_H_
#define _SGFTREE_H_

#include <stdio.h>

#include "sgf_properties.h"


#define EMPTY 0
#define WHITE 1
#define BLACK 2


void *xalloc(unsigned int);

/*
 * A property of an SGF node.  An SGF node is described by a linked
 * list of these.
 */

class SGFProperty {
 public:
  SGFProperty *next;
  short name;
  char *value;
 public:
  ~SGFProperty();
  int get_moveX(int boardsize);
  int get_moveY(int boardsize);
  int get_moveXY(int *i, int *j, int boardsize);

};

    
class SGFNode {
 public:
  SGFProperty *props;
  struct SGFNode *parent;
  struct SGFNode *child;
  struct SGFNode *next;
 private:
  SGFProperty *
    do_sgf_make_property(short sgf_name,  const char *value, SGFProperty *last);
 public:
  SGFNode(void);
  ~SGFNode(void);

  SGFProperty *sgfMkProperty(const char *name, const  char *value, SGFProperty *last);
  int sgfHasProperty(const char *name);
  void sgf_write_header_reduced(int overwrite);
  
  void sgfAddProperty(const char *name, const char *value);
  void sgfAddPropertyInt(const char *name, long val);
  void sgfAddPropertyInt(const char *name, long val, long val2);
  void sgfAddPropertyFloat(const char *name, float val);
  int sgfGetIntProperty(const char *name, int *value);
  int sgfGetFloatProperty(const char *name, float *value);
  int sgfGetCharProperty(const char *name, char **value);
  void sgfOverwriteProperty(const char *name, const char *text);
  void sgfOverwritePropertyFloat(const char *name, float val);
  void sgfOverwritePropertyInt(const char *name, int val);

  SGFNode *sgfPrev();
  SGFNode *sgfRoot();

  //zamiast: SGFNode *sgfCreateHeaderNode(int boardsize, float komi);
  SGFNode *
    sgfAddHeaderProperties(int boardsizex, int boardsizey);

  SGFNode *sgfAddStone(int color, int movex, int movey);
  SGFNode *sgfAddPlay(int who, int movex, int movey);
  SGFNode *sgfAddPlay(int who, char *move);
  SGFNode *sgfAddPlayLast(int who, int movex, int movey);
  
  void sgfWriteResult(float score, int overwrite);
  void sgf_write_header(int overwrite, int seed, float komi,
			int level, int rules);

  SGFNode *sgfLabel(const char *label, int i, int j);
  SGFNode *sgfLabelInt(int num, int i, int j);
  SGFNode *sgfCircle(int i, int j);
  SGFNode *sgfSquare(int i, int j);
  SGFNode *sgfTriangle(int i, int j);
  SGFNode *sgfMark(int i, int j);
  SGFNode *sgfAddComment(const char *comment);
  SGFNode *sgfBoardText(int i, int j, const char *text);
  SGFNode *sgfBoardChar(int i, int j, char c);
  SGFNode *sgfBoardNumber(int i, int j, int number);
  SGFNode *sgfStartVariant();
  SGFNode *sgfStartVariantFirst();
  SGFNode *sgfAddChild();

  // functions for undoing moves etc.
  int sgfMovesBefore();

  // debugging functions
  int show_sgf_properties();
  int show_sgf_tree();

  int is_markup_node();
  int is_move_node();
  int is_pass_node(int boardsize);
  int find_move();
};



class SGFParser {
  char *sgferr;                // chyba niepotrzebne!
#ifdef TEST_SGFPARSER
  int sgferrarg;
#endif
  int sgferrpos;
  int lookahead;
  FILE *sgffile;
public:
  SGFParser() { sgferr = NULL; };
  // parsing primitives
  void parse_error(const char *msg, int arg);
  void nexttoken(void);
  void match(int expected);
  int sgf_getch() { return (getc(sgffile)); };
  // the parser proper
  void propident(char *buffer, int size);
  void propvalue(char *buffer, int size);
  SGFProperty * property(SGFNode *n, SGFProperty *last);
  void node(SGFNode *n);
  SGFNode *sequence(SGFNode *n);
  void gametree(SGFNode **p, SGFNode *parent, int mode);
  SGFNode *readsgffile(const char *filename);
};


/* low level functions */


void *xrealloc(void *pt, unsigned int size);
void sgfFreeProperty(SGFProperty *prop);




/* Read SGF tree from file. */
SGFNode *readsgffile(const char *filename);
/* Specific solution for fuseki */
SGFNode *readsgffilefuseki(const char *filename, int moves_per_game);

/* Write SGF tree to a file. */
int writesgf(SGFNode *root, const char *filename);



/* ---------------------------------------------------------------- */
/* ---                          SGFTree                         --- */
/* ---------------------------------------------------------------- */


class SGFTree {
 public:    // chwilowo, dla ulatwienia...
  SGFNode *root;
  SGFNode *lastnode;
  SGFNode *saved_node;     // used by SaveNode and RestoreNode
 public:
  SGFTree();
  void sgftree_clear();
  int sgftree_readfile(const char *infilename);

  int sgftreeBack();
  int sgftreeForward();
  
  void sgftreeAddPlay(int color, int movex, int movey);
  void sgftreeAddPlay(int color, char *move);
  void sgftreeAddPlayLast(int color, int movex, int movey);
  void sgftreeAddStone(int color, int movex, int movey);
  void sgftreeWriteResult(float score, int overwrite);
  SGFNode *sgftreeNodeCheck();
	 
  void sgftreeCircle(int i, int j);
  void sgftreeSquare(int i, int j);
  void sgftreeTriangle(int i, int j);
  void sgftreeMark(int i, int j);
  void sgftreeAddComment(const char *comment);
  void sgftreeBoardText(int i, int j, const char *text);
  void sgftreeBoardChar(int i, int j, char c);
  void sgftreeBoardNumber(int i, int j, int number);
  void sgftreeStartVariant();
  void sgftreeStartVariantFirst();
  void sgftreeCreateHeaderNode(int boardsizex, int boardsizey, int rules);
  void sgftreeSetLastNode(SGFNode *lastnode);

  void sgfPlayBack(int n);
  void sgftreeSaveNode();
  void sgftreeRestoreNode();

};


#endif

