/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Copyright 2010.  Los Alamos National Security, LLC. This material was    !
! produced under U.S. Government contract DE-AC52-06NA25396 for Los Alamos !
! National Laboratory (LANL), which is operated by Los Alamos National     !
! Security, LLC for the U.S. Department of Energy. The U.S. Government has !
! rights to use, reproduce, and distribute this software.  NEITHER THE     !
! GOVERNMENT NOR LOS ALAMOS NATIONAL SECURITY, LLC MAKES ANY WARRANTY,     !
! EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE USE OF THIS         !
! SOFTWARE.  If software is modified to produce derivative works, such     !
! modified software should be clearly marked, so as not to confuse it      !
! with the version available from LANL.                                    !
!                                                                          !
! Additionally, this program is free software; you can redistribute it     !
! and/or modify it under the terms of the GNU General Public License as    !
! published by the Free Software Foundation; version 2.0 of the License.   !
! Accordingly, this program is distributed in the hope that it will be     !
! useful, but WITHOUT ANY WARRANTY; without even the implied warranty of   !
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General !
! Public License for more details.                                         !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/

#include "Matrix.h"

void M_Init(Matrix &A, int M, int N) {
  #ifdef CUDA
  A.M=M;
  A.N=N;

  if (M<=96)
    A.DM=M/16*16+16;
  else if (M<=192)
    A.DM=M/32*32+32;
  else
    A.DM=M/64*64+64;

  if (N<=96)
    A.DN=N/16*16+16;
  else if (N<=192)
    A.DN=N/32*32+32;
  else
    A.DN=N/64*64+64;

  cublasAlloc(A.DM*A.DN, sizeof(REAL), (void **)&A.Device);
  cudaMemset(A.Device, '\0', A.DM*A.DN*sizeof(REAL));
  A.Local=(REAL *)Allocate("Matrix", NULL, A.M*A.N*sizeof(REAL));
  memset(A.Local, '\0', A.M*A.N*sizeof(REAL));
  #endif
  #ifdef BLAS
  A.M=M;
  A.N=N;

  A.Local=(REAL *)Allocate("Matrix", NULL, A.M*A.N*sizeof(REAL));
  memset(A.Local, '\0', A.M*A.N*sizeof(REAL));
  #endif
}
