/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Copyright 2010.  Los Alamos National Security, LLC. This material was    !
! produced under U.S. Government contract DE-AC52-06NA25396 for Los Alamos !
! National Laboratory (LANL), which is operated by Los Alamos National     !
! Security, LLC for the U.S. Department of Energy. The U.S. Government has !
! rights to use, reproduce, and distribute this software.  NEITHER THE     !
! GOVERNMENT NOR LOS ALAMOS NATIONAL SECURITY, LLC MAKES ANY WARRANTY,     !
! EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE USE OF THIS         !
! SOFTWARE.  If software is modified to produce derivative works, such     !
! modified software should be clearly marked, so as not to confuse it      !
! with the version available from LANL.                                    !
!                                                                          !
! Additionally, this program is free software; you can redistribute it     !
! and/or modify it under the terms of the GNU General Public License as    !
! published by the Free Software Foundation; version 2.0 of the License.   !
! Accordingly, this program is distributed in the hope that it will be     !
! useful, but WITHOUT ANY WARRANTY; without even the implied warranty of   !
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General !
! Public License for more details.                                         !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <time.h>
#include <math.h>
#ifdef CUDA
  #include "MatrixCuda.cu"
#endif
#ifdef BLAS
  #include "MatrixBLAS.cu"
#endif

typedef Matrix<float> Mat;


void AddColumnTest() {
  const int M=40, column=4;
  float k=10.0*rand()/RAND_MAX;
  Mat A(M, M), B(M, M), C(M, M);

  A.Randomize();
  B.Randomize();

  A.Push();

  
 
  float answer, error=0.0;
  for (int i=0; i<C.M; i++) {
    answer=k*A.Local[i+column*A.M]+B.Local[i+column*B.M];
    error+=pow(C.Local[i+column*C.M]-answer, 2.0);
  }
  error=sqrt(error/C.M);
  printf("AddColumn error: %g\n", error);
}


int main() {
  Initialize();

  AddColumnTest();

  ShutDown();
}
