!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Copyright 2010.  Los Alamos National Security, LLC. This material was    !
! produced under U.S. Government contract DE-AC52-06NA25396 for Los Alamos !
! National Laboratory (LANL), which is operated by Los Alamos National     !
! Security, LLC for the U.S. Department of Energy. The U.S. Government has !
! rights to use, reproduce, and distribute this software.  NEITHER THE     !
! GOVERNMENT NOR LOS ALAMOS NATIONAL SECURITY, LLC MAKES ANY WARRANTY,     !
! EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE USE OF THIS         !
! SOFTWARE.  If software is modified to produce derivative works, such     !
! modified software should be clearly marked, so as not to confuse it      !
! with the version available from LANL.                                    !
!                                                                          !
! Additionally, this program is free software; you can redistribute it     !
! and/or modify it under the terms of the GNU General Public License as    !
! published by the Free Software Foundation; version 2.0 of the License.   !
! Accordingly, this program is distributed in the hope that it will be     !
! useful, but WITHOUT ANY WARRANTY; without even the implied warranty of   !
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General !
! Public License for more details.                                         !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

SUBROUTINE FINDMOLECULES

  !
  ! Ed Sanville's subroutine for identifying which atoms
  ! belong to while molecules based on the TB neighbor list
  !

  USE CONSTANTS_MOD
  USE SETUPARRAY
  USE NEBLISTARRAY
  
  IMPLICIT NONE
  
  INTEGER :: STACKINDEX, ATOMINDEX1, MOLECULEINDEX=1
  INTEGER, ALLOCATABLE :: NEIGHBORINDEXSTACK(:), ATOMINDEXSTACK(:)

  ALLOCATE(ATOMINDEXSTACK(NATS+1))
  ALLOCATE(NEIGHBORINDEXSTACK(NATS+1))

  DO ATOMINDEX1 = 1, NATS
     MOLID(ATOMINDEX1) = 0
  END DO

  !
  ! WE NEED TO TRAVERSE THE NEIGHBOR TREE, SO WE'LL USE A STACK 
  ! OF INDICES INTO THE NEIGHBOR LISTS, AND SKIP OVER BRANCHES 
  ! WE'VE ALREADY DONE
  !

  STACKINDEX = 1
  ATOMINDEXSTACK(1) = 0
  
  DO

     !
     ! SET UP ATOMINDEXSTACK
     !

     IF (STACKINDEX .GT. 1) THEN

        ATOMINDEXSTACK(STACKINDEX) = &
             NEBTB(ATOMINDEXSTACK(STACKINDEX-1), &
             NEIGHBORINDEXSTACK(STACKINDEX), 1)

     END IF
     
     !
     ! DEAL WITH CURRENT ATOM
     !

     IF (ATOMINDEXSTACK(STACKINDEX) .GT. 0) THEN
        
        IF (MOLID(ATOMINDEXSTACK(STACKINDEX)) .EQ. 0) THEN
           
           MOLID(ATOMINDEXSTACK(STACKINDEX)) = MOLECULEINDEX

           STACKINDEX = STACKINDEX+1

           NEIGHBORINDEXSTACK(STACKINDEX) = 0
           
        END IF
     END IF
     
     !
     ! INCREMENT THE CURRENT ATOM
     !

     IF (STACKINDEX .GT. 1) THEN

        NEIGHBORINDEXSTACK(STACKINDEX) = NEIGHBORINDEXSTACK(STACKINDEX) + 1

     ELSE IF (STACKINDEX .EQ. 1) THEN 

        ATOMINDEXSTACK(STACKINDEX) = ATOMINDEXSTACK(STACKINDEX) + 1

     END IF
     
     !
     ! CHECK BOUNDS
     !

     IF (STACKINDEX .GT. 1) THEN 

        IF (NEIGHBORINDEXSTACK(STACKINDEX) > &
             TOTNEBTB(ATOMINDEXSTACK(STACKINDEX-1))) THEN
           
           STACKINDEX = STACKINDEX - 1
           
           IF (STACKINDEX .EQ. 1) THEN

              MOLECULEINDEX = MOLECULEINDEX + 1

           END IF
           
        END IF
        
     ELSE IF (STACKINDEX .EQ. 1) THEN
        
        IF (ATOMINDEXSTACK(STACKINDEX) > NATS) THEN

           EXIT

        END IF
        
     END IF
  END DO
  
  DEALLOCATE(ATOMINDEXSTACK, NEIGHBORINDEXSTACK)
  
  !
  ! MJC put in this bit to get the total number of molecules
  !

  NOMOL = MAXVAL(MOLID)

!  DO I = 1, NATS
!
!     PRINT*, I, MOLID(I)
!
!  ENDDO 
  
  RETURN
  
END SUBROUTINE FINDMOLECULES
