!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Copyright 2010.  Los Alamos National Security, LLC. This material was    !
! produced under U.S. Government contract DE-AC52-06NA25396 for Los Alamos !
! National Laboratory (LANL), which is operated by Los Alamos National     !
! Security, LLC for the U.S. Department of Energy. The U.S. Government has !
! rights to use, reproduce, and distribute this software.  NEITHER THE     !
! GOVERNMENT NOR LOS ALAMOS NATIONAL SECURITY, LLC MAKES ANY WARRANTY,     !
! EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE USE OF THIS         !
! SOFTWARE.  If software is modified to produce derivative works, such     !
! modified software should be clearly marked, so as not to confuse it      !
! with the version available from LANL.                                    !
!                                                                          !
! Additionally, this program is free software; you can redistribute it     !
! and/or modify it under the terms of the GNU General Public License as    !
! published by the Free Software Foundation; version 2.0 of the License.   !
! Accordingly, this program is distributed in the hope that it will be     !
! useful, but WITHOUT ANY WARRANTY; without even the implied warranty of   !
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General !
! Public License for more details.                                         !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

SUBROUTINE BLDSPINH

  USE CONSTANTS_MOD
  USE SETUPARRAY
  USE SPINARRAY
  USE MYPRECISION

  IMPLICIT NONE

  !
  ! Here we build the spin-dependent Hamiltonian
  !
  ! Only the onsite blocks are non-zero, and there are only
  ! three unique elements in the case of sp-valent atoms, so we'll
  ! store this H matrix as a vector - suspended, to be inplemented later
  !

  INTEGER :: I, J, K
  INTEGER :: MYINDEX, HINDEX
  REAL(LATTEPREC) :: DSPINS, DSPINP
  REAL(LATTEPREC) :: HSS, HSP, HPP

  ! We start with the spin-indepentent H matrix and 
  ! either add or subtract the spin dependent one for
  ! the up-side and down-spin channels, respectively.

  HUP = H
  HDOWN = H

  MYINDEX = 0
  HINDEX = 0

  DO I = 1, NATS

     DO K = 1, NOELEM

        IF (ATELE(I) .EQ. ELE(K)) THEN

           IF (BASIS(K) .EQ. "ss") THEN

              MYINDEX = MYINDEX + 1
              DSPINS = DELTASPIN(MYINDEX)

              HSS = WSS(K)*DSPINS
              
              HINDEX = HINDEX + 1

              HUP(HINDEX, HINDEX) = HUP(HINDEX, HINDEX) + HSS

              HDOWN(HINDEX, HINDEX) = HDOWN(HINDEX, HINDEX) - HSS

           ELSEIF (BASIS(K) .EQ. "sp") THEN

              DSPINS = DELTASPIN(MYINDEX+1)
              DSPINP = DELTASPIN(MYINDEX+2)

              MYINDEX = MYINDEX + 2

              ! ss

              HSS = (WSS(K)*DSPINS + WSP(K)*DSPINP)

              ! sp/ps

!              HSP = HALF*(WSS(K) + WSP(K))*DSPINS + &
!                   HALF*(WSP(K) + WPP(K))*DSPINP
              
              ! pp

              HPP = (WSP(K)*DSPINS + WPP(K)*DSPINP)
              
              HINDEX = HINDEX + 1

              HUP(HINDEX, HINDEX) = HUP(HINDEX, HINDEX) + HSS 

              HDOWN(HINDEX, HINDEX) = HDOWN(HINDEX, HINDEX) - HSS 

              DO J = 1, 3

                 HINDEX = HINDEX + 1

                 HUP(HINDEX, HINDEX) = HUP(HINDEX, HINDEX) + HPP 
                 
                 HDOWN(HINDEX, HINDEX) = HDOWN(HINDEX, HINDEX) - HPP

              ENDDO

           ENDIF

        ENDIF

     ENDDO
  ENDDO

  RETURN

END SUBROUTINE BLDSPINH

                 

              
