!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Copyright 2010.  Los Alamos National Security, LLC. This material was    !
! produced under U.S. Government contract DE-AC52-06NA25396 for Los Alamos !
! National Laboratory (LANL), which is operated by Los Alamos National     !
! Security, LLC for the U.S. Department of Energy. The U.S. Government has !
! rights to use, reproduce, and distribute this software.  NEITHER THE     !
! GOVERNMENT NOR LOS ALAMOS NATIONAL SECURITY, LLC MAKES ANY WARRANTY,     !
! EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE USE OF THIS         !
! SOFTWARE.  If software is modified to produce derivative works, such     !
! modified software should be clearly marked, so as not to confuse it      !
! with the version available from LANL.                                    !
!                                                                          !
! Additionally, this program is free software; you can redistribute it     !
! and/or modify it under the terms of the GNU General Public License as    !
! published by the Free Software Foundation; version 2.0 of the License.   !
! Accordingly, this program is distributed in the hope that it will be     !
! useful, but WITHOUT ANY WARRANTY; without even the implied warranty of   !
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General !
! Public License for more details.                                         !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

SUBROUTINE COULOMBEWALD

  USE CONSTANTS_MOD
  USE SETUPARRAY
  USE COULOMBARRAY
  USE VIRIALARRAY
  USE MYPRECISION

  IMPLICIT NONE

  INTEGER :: I, J, L, M, N
  INTEGER :: LMIN, LMAX, MMIN, MMAX, NMIN, NMAX
  REAL(LATTEPREC) :: PREFACTOR, K2, K(3), DOT
  REAL(LATTEPREC) :: COSSUM, SINSUM, COSSUM2, SINSUM2
  REAL(LATTEPREC) :: FLL, FLM, FLN
  REAL(LATTEPREC) :: FORCE
  REAL(LATTEPREC) :: MYSIN, MYCOS, PREVIR
!  REAL(LATTEPREC), EXTERNAL :: FASTCOSF, FASTSINF

  LMIN = 0

  LMAX = INT(KCUTOFF / SQRT(RECIPVECS(1,1)*RECIPVECS(1,1) + &
       RECIPVECS(1,2)*RECIPVECS(1,2) + RECIPVECS(1,3)*RECIPVECS(1,3)))

  MMAX = INT(KCUTOFF / SQRT(RECIPVECS(2,1)*RECIPVECS(2,1) + &
       RECIPVECS(2,2)*RECIPVECS(2,2) + RECIPVECS(2,3)*RECIPVECS(2,3)))
  
  NMAX = INT(KCUTOFF / SQRT(RECIPVECS(3,1)*RECIPVECS(3,1) + &
       RECIPVECS(3,2)*RECIPVECS(3,2) + RECIPVECS(3,3)*RECIPVECS(3,3)))

  DO L = LMIN, LMAX
     
     FLL = FLOAT(L)

     MMIN = -MMAX

     IF (L .EQ. 0) THEN
        MMIN = 0
     ENDIF

     DO M = MMIN, MMAX

        FLM = FLOAT(M)
        
        NMIN = -NMAX

        IF (L .EQ. 0 .AND. M .EQ. 0) THEN
           NMIN = 1
        ENDIF

        DO N = NMIN, NMAX

           FLN = FLOAT(N)

           K(1) = FLL*RECIPVECS(1,1) + FLM*RECIPVECS(2,1) + &
                FLN*RECIPVECS(3,1)
           K(2) = FLL*RECIPVECS(1,2) + FLM*RECIPVECS(2,2) + &
                FLN*RECIPVECS(3,2)
           K(3) = FLL*RECIPVECS(1,3) + FLM*RECIPVECS(2,3) + &
                FLN*RECIPVECS(3,3)

           K2 = K(1)*K(1) + K(2)*K(2) + K(3)*K(3)

           IF (K2 .LE. KCUTOFF2) THEN

              PREFACTOR = EIGHT*PI*EXP(MINUSONE*K2/(FOUR*CALPHA2)) / &
                   (COULVOL*K2)

              PREVIR = TWO*((ONE/K2) + (ONE/(FOUR*CALPHA2)))

              COSSUM = ZERO
              SINSUM = ZERO

              ! Doing the sin and cos sums

              DO I = 1, NATS

                 DOT = K(1)*CR(1,I) + K(2)*CR(2,I) + K(3)*CR(3,I)

                 COSSUM = COSSUM + DELTAQ(I)*COS(DOT)
                 SINSUM = SINSUM + DELTAQ(I)*SIN(DOT)

              ENDDO

              COSSUM2 = COSSUM*COSSUM
              SINSUM2 = SINSUM*SINSUM

              ! Add up energy and force contributions
              
              DO I = 1, NATS

                 DOT = K(1)*CR(1,I) + K(2)*CR(2,I) + K(3)*CR(3,I)

                 MYSIN = SIN(DOT)
                 MYCOS = COS(DOT)

                 COULOMBV(I) = COULOMBV(I) + KECONST*PREFACTOR* &
                      (MYCOS*COSSUM + MYSIN*SINSUM)

                 FORCE = KECONST*PREFACTOR*(MYSIN*COSSUM - &
                      MYCOS*SINSUM)

                 DO J = 1, 3
                    FCOUL(J,I) = FCOUL(J,I) + FORCE*DELTAQ(I)*K(J)
                 ENDDO
                 
              ENDDO

              VIRCOUL(1) = VIRCOUL(1) + KECONST*PREFACTOR*(ONE - &
                      PREVIR*K(1)*K(1))*(COSSUM2 + SINSUM2)
              VIRCOUL(2) = VIRCOUL(2) + KECONST*PREFACTOR*(ONE - &
                      PREVIR*K(2)*K(2))*(COSSUM2 + SINSUM2)
              VIRCOUL(3) = VIRCOUL(3) + KECONST*PREFACTOR*(ONE - &
                      PREVIR*K(3)*K(3))*(COSSUM2 + SINSUM2)
              VIRCOUL(4) = VIRCOUL(4) - KECONST*PREFACTOR*PREVIR* &
                   K(1)*K(2)*(COSSUM2 + SINSUM2)
              VIRCOUL(5) = VIRCOUL(5) - KECONST*PREFACTOR*PREVIR* &
                   K(2)*K(3)*(COSSUM2 + SINSUM2)
              VIRCOUL(6) = VIRCOUL(6) - KECONST*PREFACTOR*PREVIR* &
                   K(3)*K(1)*(COSSUM2 + SINSUM2)
              
           ENDIF

        ENDDO
     ENDDO
  ENDDO

  ! Point self energy

  DO I = 1, NATS

     COULOMBV(I) = COULOMBV(I) - TWO*KECONST*CALPHA*DELTAQ(I)/SQRTPI

  ENDDO

  RETURN

END SUBROUTINE COULOMBEWALD
              
