!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Copyright 2010.  Los Alamos National Security, LLC. This material was    !
! produced under U.S. Government contract DE-AC52-06NA25396 for Los Alamos !
! National Laboratory (LANL), which is operated by Los Alamos National     !
! Security, LLC for the U.S. Department of Energy. The U.S. Government has !
! rights to use, reproduce, and distribute this software.  NEITHER THE     !
! GOVERNMENT NOR LOS ALAMOS NATIONAL SECURITY, LLC MAKES ANY WARRANTY,     !
! EXPRESS OR IMPLIED, OR ASSUMES ANY LIABILITY FOR THE USE OF THIS         !
! SOFTWARE.  If software is modified to produce derivative works, such     !
! modified software should be clearly marked, so as not to confuse it      !
! with the version available from LANL.                                    !
!                                                                          !
! Additionally, this program is free software; you can redistribute it     !
! and/or modify it under the terms of the GNU General Public License as    !
! published by the Free Software Foundation; version 2.0 of the License.   !
! Accordingly, this program is distributed in the hope that it will be     !
! useful, but WITHOUT ANY WARRANTY; without even the implied warranty of   !
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General !
! Public License for more details.                                         !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

SUBROUTINE DGSP(MAGR, IGS, DC, DGSPDR, SCLGSP)

  USE GSPARRAY
  USE MYPRECISION

  IMPLICIT NONE

  INTEGER :: IGS
  REAL(LATTEPREC) :: MAGR
  REAL(LATTEPREC) :: DC(3), DGSPDR(3), SCLGSP, TMPGSP
  REAL(LATTEPREC) :: RMINUSR1, RMINUSR12, RMINUSR14

  IF (MAGR .LE. GSPR1(IGS)) THEN

     CALL GSP(MAGR, IGS, SCLGSP)

     TMPGSP = GSPN(IGS)*SCLGSP*(GSPNC(IGS)* &
          ((MAGR/GSPRC(IGS))**GSPNC(IGS)) + ONE)/MAGR

  ELSEIF (MAGR .GT. GSPR1(IGS) .AND. MAGR .LT. GSPRCUT(IGS)) THEN

     RMINUSR1 = MAGR - GSPR1(IGS)
     RMINUSR12 = RMINUSR1*RMINUSR1
     RMINUSR14 = RMINUSR12*RMINUSR12

     SCLGSP = B(1,IGS) + B(2,IGS)*RMINUSR1 + B(3,IGS)*RMINUSR12 + &
          B(4,IGS)*RMINUSR12*RMINUSR1 + B(5,IGS)*RMINUSR14 + &
          B(6,IGS)*RMINUSR14*RMINUSR1

     TMPGSP = MINUSONE*(B(2,IGS) + TWO*B(3,IGS)*RMINUSR1 + &
          THREE*B(4,IGS)*RMINUSR12 + FOUR*B(5,IGS)*RMINUSR12*RMINUSR1 + &
          FIVE*B(6,IGS)*RMINUSR14)

  ELSE

     SCLGSP = ZERO
     TMPGSP = ZERO

  ENDIF
  
  DGSPDR = TMPGSP*DC

  RETURN

END SUBROUTINE DGSP
